/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.ISignatureVerificationAlgorithm;
import logging.LogHolder;
import logging.LogType;

public final class ByteSignature {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    private ByteSignature() {
    }

    public static boolean verify(byte[] byArray, byte[] byArray2, AsymmetricCryptoKeyPair asymmetricCryptoKeyPair) {
        return ByteSignature.verify(byArray, byArray2, asymmetricCryptoKeyPair.getPublic());
    }

    public static boolean verify(byte[] byArray, byte[] byArray2, IMyPublicKey iMyPublicKey) {
        if (iMyPublicKey == null) {
            LogHolder.log(7, LogType.CRYPTO, "key==null!");
            return false;
        }
        ISignatureVerificationAlgorithm iSignatureVerificationAlgorithm = iMyPublicKey.getSignatureAlgorithm();
        if (iSignatureVerificationAlgorithm == null) {
            LogHolder.log(2, LogType.CRYPTO, "Try to verify a message - unknown algorithm!");
            return false;
        }
        return iSignatureVerificationAlgorithm.verify(byArray, byArray2);
    }

    public static byte[] sign(byte[] byArray, AsymmetricCryptoKeyPair asymmetricCryptoKeyPair) {
        return ByteSignature.sign(byArray, asymmetricCryptoKeyPair.getPrivate());
    }

    public static byte[] sign(byte[] byArray, IMyPrivateKey iMyPrivateKey) {
        if (iMyPrivateKey == null) {
            return null;
        }
        return iMyPrivateKey.getSignatureAlgorithm().sign(byArray);
    }

    public static String toHexString(byte[] byArray) {
        int n;
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        char[] cArray = new char[byArray.length * 3 - 1];
        int n2 = 0;
        for (int i = 0; i < byArray.length - 1; ++i) {
            n = 0xFF & byArray[i];
            cArray[n2++] = HEX_CHARS[n >> 4];
            cArray[n2++] = HEX_CHARS[n & 0xF];
            cArray[n2++] = 58;
        }
        n = 0xFF & byArray[byArray.length - 1];
        cArray[n2++] = HEX_CHARS[n >> 4];
        cArray[n2++] = HEX_CHARS[n & 0xF];
        return new String(cArray);
    }
}

