/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.parsers;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import org.xml.sax.SAXException;

public abstract class SAXParserFactory {
    private boolean validating = false;
    private boolean namespaceAware = false;

    protected SAXParserFactory() {
    }

    public static SAXParserFactory newInstance() {
        SAXParserFactory sAXParserFactory;
        String string = null;
        try {
            string = System.getProperty("javax.xml.parsers.SAXParserFactory", "com.sun.xml.parser.SAXParserFactoryImpl");
        }
        catch (SecurityException securityException) {
            string = "com.sun.xml.parser.SAXParserFactoryImpl";
        }
        try {
            Class<?> clazz = Class.forName(string);
            sAXParserFactory = (SAXParserFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FactoryConfigurationError(classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FactoryConfigurationError(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new FactoryConfigurationError(instantiationException);
        }
        return sAXParserFactory;
    }

    public abstract SAXParser newSAXParser() throws ParserConfigurationException, SAXException;

    public void setNamespaceAware(boolean bl) {
        this.namespaceAware = bl;
    }

    public void setValidating(boolean bl) {
        this.validating = bl;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }
}

