/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.NVPair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

class SimpleAuthPrompt
implements AuthorizationPrompter {
    SimpleAuthPrompt() {
    }

    public synchronized NVPair getUsernamePassword(AuthorizationInfo challenge) {
        String pass;
        String user;
        if (challenge.getScheme().equalsIgnoreCase("SOCKS5")) {
            System.out.println("Enter username and password for SOCKS server on host " + challenge.getHost());
            System.out.println("Authentication Method: username/password");
        } else {
            System.out.println("Enter username and password for realm `" + challenge.getRealm() + "' on host " + challenge.getHost() + ":" + challenge.getPort());
            System.out.println("Authentication Scheme: " + challenge.getScheme());
        }
        BufferedReader inp = new BufferedReader(new InputStreamReader(System.in));
        System.out.print("Username: ");
        System.out.flush();
        try {
            user = inp.readLine();
        }
        catch (IOException ioe) {
            return null;
        }
        if (user == null || user.length() == 0) {
            return null;
        }
        SimpleAuthPrompt.disableEcho();
        System.out.print("Password: ");
        System.out.flush();
        try {
            pass = inp.readLine();
        }
        catch (IOException ioe) {
            return null;
        }
        System.out.println();
        SimpleAuthPrompt.enableEcho();
        if (pass == null) {
            return null;
        }
        return new NVPair(user, pass);
    }

    private static void disableEcho() {
        String os = System.getProperty("os.name");
        if (os.equalsIgnoreCase("Windows 95") || os.equalsIgnoreCase("Windows NT")) {
            String echo_off = "echo off";
            try {
                Runtime.getRuntime().exec(echo_off).waitFor();
            }
            catch (Exception e) {}
        } else if (!(os.equalsIgnoreCase("Windows NT") || os.equalsIgnoreCase("Windows") || os.equalsIgnoreCase("16-bit Windows") || os.equalsIgnoreCase("OS/2") || os.equalsIgnoreCase("Mac OS") || os.equalsIgnoreCase("MacOS"))) {
            if (os.equalsIgnoreCase("OpenVMS") || os.equalsIgnoreCase("VMS")) {
                String echo_off = "SET TERMINAL /NOECHO";
                try {
                    Runtime.getRuntime().exec(echo_off).waitFor();
                }
                catch (Exception e) {}
            } else {
                String[] echo_off = new String[]{"/bin/sh", "-c", "stty -echo < /dev/tty"};
                try {
                    Runtime.getRuntime().exec(echo_off).waitFor();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void enableEcho() {
        String os = System.getProperty("os.name");
        if (os.equalsIgnoreCase("Windows 95") || os.equalsIgnoreCase("Windows NT")) {
            String echo_on = "echo on";
            try {
                Runtime.getRuntime().exec(echo_on).waitFor();
            }
            catch (Exception e) {}
        } else if (!(os.equalsIgnoreCase("Windows") || os.equalsIgnoreCase("16-bit Windows") || os.equalsIgnoreCase("OS/2") || os.equalsIgnoreCase("Mac OS") || os.equalsIgnoreCase("MacOS"))) {
            if (os.equalsIgnoreCase("OpenVMS") || os.equalsIgnoreCase("VMS")) {
                String echo_on = "SET TERMINAL /ECHO";
                try {
                    Runtime.getRuntime().exec(echo_on).waitFor();
                }
                catch (Exception e) {}
            } else {
                String[] echo_on = new String[]{"/bin/sh", "-c", "stty echo < /dev/tty"};
                try {
                    Runtime.getRuntime().exec(echo_on).waitFor();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

