/*
 * Decompiled with CFR 0.152.
 */
package gui;

import anon.crypto.CertPathInfo;
import anon.crypto.JAPCertificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MultiCertTrustGraph {
    Hashtable m_rootNodes;
    Hashtable m_opNodes;
    Hashtable m_endNodes;

    public MultiCertTrustGraph(CertPathInfo[] certPathInfoArray) {
        this.createGraph(certPathInfoArray);
    }

    private void createGraph(CertPathInfo[] certPathInfoArray) {
        JAPCertificate jAPCertificate;
        JAPCertificate jAPCertificate2;
        JAPCertificate jAPCertificate3;
        int n;
        this.m_rootNodes = new Hashtable();
        this.m_opNodes = new Hashtable();
        this.m_endNodes = new Hashtable();
        for (n = 0; n < certPathInfoArray.length; ++n) {
            jAPCertificate3 = certPathInfoArray[n].getRootCertificate();
            jAPCertificate2 = certPathInfoArray[n].getSecondCertificate();
            jAPCertificate = certPathInfoArray[n].getFirstCertificate();
            boolean bl = certPathInfoArray[n].isVerified();
            if (jAPCertificate3 != null) {
                this.m_rootNodes.put(jAPCertificate3, new Node(jAPCertificate3, bl));
            }
            if (jAPCertificate2 != null) {
                this.m_opNodes.put(jAPCertificate2, new Node(jAPCertificate2, bl));
            }
            this.m_endNodes.put(jAPCertificate, new Node(jAPCertificate, bl));
        }
        for (n = 0; n < certPathInfoArray.length; ++n) {
            Node node;
            Node node2;
            jAPCertificate3 = certPathInfoArray[n].getRootCertificate();
            jAPCertificate2 = certPathInfoArray[n].getSecondCertificate();
            jAPCertificate = certPathInfoArray[n].getFirstCertificate();
            if (jAPCertificate2 != null) {
                node2 = (Node)this.m_opNodes.get(jAPCertificate2);
                if (jAPCertificate3 != null) {
                    node = (Node)this.m_rootNodes.get(jAPCertificate3);
                    node.addChild(node2);
                    this.m_opNodes.remove(jAPCertificate2);
                }
                node = node2;
                node2 = new Node(certPathInfoArray[n].getFirstCertificate());
                node.addChild(node2);
                this.m_endNodes.remove(jAPCertificate);
                continue;
            }
            if (jAPCertificate3 == null) continue;
            node2 = new Node(certPathInfoArray[n].getFirstCertificate());
            node = (Node)this.m_rootNodes.get(jAPCertificate3);
            node.addChild(node2);
            this.m_endNodes.remove(jAPCertificate);
        }
    }

    public Enumeration getRootNodes() {
        return this.m_rootNodes.elements();
    }

    public Enumeration getOperatorNodes() {
        return this.m_opNodes.elements();
    }

    public Enumeration getEndNodes() {
        return this.m_endNodes.elements();
    }

    public int countTrustedRootNodes() {
        int n = 0;
        Enumeration enumeration = this.getRootNodes();
        Date date = new Date();
        block0: while (enumeration.hasMoreElements()) {
            Node node = (Node)enumeration.nextElement();
            if (!node.isTrusted() || !node.getCertificate().getValidity().isValid(date) || !node.hasChildNodes()) continue;
            Enumeration enumeration2 = node.getChildNodes();
            while (enumeration2.hasMoreElements()) {
                Node node2 = (Node)enumeration2.nextElement();
                if (!node2.getCertificate().getValidity().isValid(date)) continue;
                ++n;
                continue block0;
            }
        }
        return n;
    }

    public final class Node {
        private JAPCertificate m_cert;
        private Vector m_childNodes;
        private boolean m_trusted;

        public Node(JAPCertificate jAPCertificate, boolean bl) {
            this.m_cert = jAPCertificate;
            this.m_trusted = bl;
            this.m_childNodes = new Vector();
        }

        public Node(JAPCertificate jAPCertificate) {
            this(jAPCertificate, false);
        }

        public void addChild(Node node) {
            if (!this.m_childNodes.contains(node)) {
                this.m_childNodes.addElement(node);
                node.m_trusted = this.m_trusted;
            }
        }

        public JAPCertificate getCertificate() {
            return this.m_cert;
        }

        public boolean isTrusted() {
            return this.m_trusted;
        }

        public Enumeration getChildNodes() {
            return this.m_childNodes.elements();
        }

        public boolean hasChildNodes() {
            return this.m_childNodes.size() > 0;
        }

        public int getWidth() {
            if (this.m_childNodes.size() == 0) {
                return 1;
            }
            return this.m_childNodes.size();
        }
    }
}

