/*
 * Decompiled with CFR 0.152.
 */
package anon.xmlrpc.server;

import anon.AnonChannel;
import anon.AnonService;
import anon.shared.AbstractChannel;
import anon.xmlrpc.server.ClientEntry;
import anon.xmlrpc.server.ClientList;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.apache.xmlrpc.WebServer;
import org.apache.xmlrpc.XmlRpcHandler;

public class AnonServiceImplRemote
implements XmlRpcHandler {
    private AnonService m_AnonService;
    private WebServer m_RpcServer;
    private ClientList m_ClientList;

    public AnonServiceImplRemote(AnonService anonService) {
        this.m_AnonService = anonService;
        this.m_ClientList = new ClientList();
    }

    public int startService() {
        try {
            this.m_RpcServer = new WebServer(8889);
            this.m_RpcServer.addHandler("ANONXMLRPC", (Object)this);
            this.m_RpcServer.start();
            return 0;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int stopService() {
        return 0;
    }

    public Object execute(String string, Vector vector) throws Exception {
        if (string.equals("registerClient")) {
            return this.doRegisterClient(vector);
        }
        if (string.equals("createChannel")) {
            return this.doCreateChannel(vector);
        }
        if (string.equals("channelInputStreamRead")) {
            return this.doChannelInputStreamRead(vector);
        }
        if (string.equals("channelOutputStreamWrite")) {
            return this.doChannelOutputStreamWrite(vector);
        }
        throw new Exception("Unknown Method");
    }

    private Object doRegisterClient(Vector vector) throws Exception {
        int n = this.m_ClientList.addNewClient();
        return new Integer(n);
    }

    private Object doCreateChannel(Vector vector) throws Exception {
        Integer n = (Integer)vector.elementAt(0);
        ClientEntry clientEntry = this.m_ClientList.getClient(n);
        AnonChannel anonChannel = this.m_AnonService.createChannel(0);
        clientEntry.addChannel(anonChannel);
        return new Integer(((AbstractChannel)anonChannel).hashCode());
    }

    private Object doChannelInputStreamRead(Vector vector) throws Exception {
        int n;
        byte[] byArray;
        Integer n2 = (Integer)vector.elementAt(0);
        ClientEntry clientEntry = this.m_ClientList.getClient(n2);
        AnonChannel anonChannel = clientEntry.getChannel((Integer)vector.elementAt(1));
        InputStream inputStream = anonChannel.getInputStream();
        int n3 = inputStream.read(byArray = new byte[n = ((Integer)vector.elementAt(2)).intValue()]);
        if (n3 < 0) {
            return new Integer(-1);
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    private Object doChannelOutputStreamWrite(Vector vector) throws Exception {
        Integer n = (Integer)vector.elementAt(0);
        ClientEntry clientEntry = this.m_ClientList.getClient(n);
        AnonChannel anonChannel = clientEntry.getChannel((Integer)vector.elementAt(1));
        OutputStream outputStream = anonChannel.getOutputStream();
        byte[] byArray = (byte[])vector.elementAt(2);
        outputStream.write(byArray);
        outputStream.flush();
        return new Integer(0);
    }
}

