/*
 * Decompiled with CFR 0.152.
 */
package anon.proxy;

import java.io.ByteArrayOutputStream;

public class ProxyCallbackBuffer {
    private byte[] chunk = null;
    private int modificationStartOffset = 0;
    private int modificationEndOffset = 0;
    private int payloadLength = 0;
    private int status = 2;

    public ProxyCallbackBuffer() {
        this(new byte[1000]);
    }

    public ProxyCallbackBuffer(byte[] byArray) {
        this(byArray, 0, byArray.length - 1);
    }

    public ProxyCallbackBuffer(byte[] byArray, int n, int n2) {
        this.setChunk(byArray);
        this.setModificationStartOffset(n);
        this.setPayloadLength(n2);
        this.setModificationEndOffset(n2 - 1);
        this.status = 2;
    }

    public ProxyCallbackBuffer(byte[] byArray, int n, int n2, int n3) {
        this.setChunk(byArray);
        this.setModificationStartOffset(n);
        this.setModificationEndOffset(n2);
        this.status = 2;
    }

    public byte[] getChunk() {
        return this.chunk;
    }

    public void setChunk(byte[] byArray) {
        this.chunk = byArray;
        this.modificationStartOffset = 0;
        this.modificationEndOffset = byArray.length - 1;
        this.payloadLength = byArray.length;
    }

    public int getModificationStartOffset() {
        return this.modificationStartOffset;
    }

    public void setModificationStartOffset(int n) {
        if (n < 0 || n > this.chunk.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal modification start index: " + n + " (chunk length: " + this.chunk.length + ")");
        }
        this.modificationStartOffset = n;
    }

    public int getModificationEndOffset() {
        return this.modificationEndOffset;
    }

    public void setModificationEndOffset(int n) {
        if (n < 0 || n > this.chunk.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal modification end index: " + n + " (chunk length: " + this.chunk.length + ")");
        }
        this.modificationEndOffset = n;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    public void setPayloadLength(int n) {
        if (n < 0 || n > this.chunk.length) {
            throw new ArrayIndexOutOfBoundsException("Illegal payload length: " + n);
        }
        this.payloadLength = n;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        if (n < 0 || n > 2) {
            throw new IllegalArgumentException("Illegal status specified: " + n);
        }
        this.status = n;
    }

    public void copyLeadingData(ByteArrayOutputStream byteArrayOutputStream) {
        if (this.modificationStartOffset > 0) {
            byteArrayOutputStream.write(this.chunk, 0, this.modificationStartOffset);
        }
    }

    public void copyLeadingData(byte[] byArray) {
        this.copyLeadingData(byArray, 0);
    }

    public void copyLeadingData(byte[] byArray, int n) {
        if (n + this.modificationStartOffset > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("leading data length " + this.modificationStartOffset + " excceeds destination array");
        }
        if (this.modificationStartOffset > 0) {
            System.arraycopy(this.chunk, 0, byArray, n, this.modificationStartOffset);
        }
    }

    public void copyTrailingData(ByteArrayOutputStream byteArrayOutputStream) {
        int n = this.getTrailingDataLength();
        if (n > 0) {
            byteArrayOutputStream.write(this.chunk, this.modificationEndOffset + 1, n);
        }
    }

    public void copyTrailingData(byte[] byArray, int n) {
        int n2 = this.getTrailingDataLength();
        if (n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException("trailing data length " + n2 + " excceeds destination array");
        }
        if (n2 > 0) {
            System.arraycopy(this.chunk, this.modificationEndOffset + 1, byArray, n, n2);
        }
    }

    public int getLeadingDataLength() {
        return this.modificationStartOffset;
    }

    public int getTrailingDataLength() {
        return this.payloadLength - (this.modificationEndOffset + 1);
    }
}

