/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.util.Base64;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLChallenge
implements IXMLEncodable {
    private byte[] m_arbChallenge;
    private int m_prepaidBytes;
    public static final String XML_ELEMENT_NAME = "Challenge";

    public XMLChallenge(String string) throws Exception {
        Document document = XMLUtil.toXMLDocument(string);
        this.setValues(document.getDocumentElement());
    }

    public XMLChallenge(Element element) throws Exception {
        this.setValues(element);
    }

    public XMLChallenge(Document document) throws Exception {
        this.setValues(document.getDocumentElement());
    }

    public XMLChallenge(byte[] byArray) {
        this.m_arbChallenge = byArray;
    }

    private void setValues(Element element) throws Exception {
        if (!element.getTagName().equals(XML_ELEMENT_NAME)) {
            throw new Exception("XMLChallenge wrong XML structure");
        }
        Element element2 = (Element)XMLUtil.getFirstChildByName(element, "DontPanic");
        this.m_arbChallenge = Base64.decode(XMLUtil.parseValue((Node)element2, ""));
        this.m_prepaidBytes = XMLUtil.parseValue(XMLUtil.getFirstChildByName(element, "PrepaidBytes"), 0);
    }

    public int getPrepaidBytes() {
        return this.m_prepaidBytes;
    }

    public byte[] getChallengeForSigning() {
        byte[] byArray = new byte[this.m_arbChallenge.length];
        System.arraycopy(this.m_arbChallenge, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public byte[] getChallengeForCaptcha() {
        String string = "<DontPanic>" + Base64.encodeBytes(this.m_arbChallenge) + "</DontPanic>";
        return string.getBytes();
    }

    public Element toXmlElement(Document document) {
        Element element = document.createElement(XML_ELEMENT_NAME);
        Element element2 = document.createElement("DontPanic");
        element.appendChild(element2);
        XMLUtil.setValue((Node)element2, Base64.encodeBytes(this.m_arbChallenge));
        return element;
    }
}

