/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractX509Extension;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.IssuingDistributionPoint;
import org.bouncycastle.asn1.x509.ReasonFlags;
import org.bouncycastle.asn1.x509.X509Extensions;

public class X509IssuingDistributionPoint
extends AbstractX509Extension {
    public static final String IDENTIFIER = X509Extensions.IssuingDistributionPoint.getId();
    private IssuingDistributionPoint m_issuingDistributionPoint;

    public X509IssuingDistributionPoint(DistributionPointName distributionPointName, boolean bl, boolean bl2, ReasonFlags reasonFlags, boolean bl3, boolean bl4) {
        super(IDENTIFIER, false, X509IssuingDistributionPoint.createDEROctets(distributionPointName, !bl, !bl2, reasonFlags, !bl3, !bl4));
        this.m_issuingDistributionPoint = new IssuingDistributionPoint(distributionPointName, !bl, !bl2, reasonFlags, !bl3, !bl4);
    }

    public X509IssuingDistributionPoint(boolean bl) {
        this(null, false, false, null, bl, false);
    }

    public X509IssuingDistributionPoint(DERSequence dERSequence) {
        super(dERSequence);
        this.createValue();
    }

    private void createValue() {
        try {
            this.m_issuingDistributionPoint = new IssuingDistributionPoint((ASN1Sequence)((DERSequence)new ASN1InputStream((InputStream)new ByteArrayInputStream(this.getDEROctets())).readObject()));
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not read issuing distribution point extension from byte array!");
        }
    }

    private static byte[] createDEROctets(DistributionPointName distributionPointName, boolean bl, boolean bl2, ReasonFlags reasonFlags, boolean bl3, boolean bl4) {
        return new IssuingDistributionPoint(distributionPointName, bl, bl2, reasonFlags, bl3, bl4).getDEREncoded();
    }

    public String getName() {
        return "IssuingDistributionPoint";
    }

    public Vector getValues() {
        return null;
    }

    public boolean isIndirectCRL() {
        return this.m_issuingDistributionPoint.isIndirectCRL();
    }

    public IssuingDistributionPoint getIssuingDistributionPoint() {
        return this.m_issuingDistributionPoint;
    }
}

