/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.util;

import java.io.Serializable;
import java.util.Hashtable;
import org.apache.oro.util.Cache;
import org.apache.oro.util.GenericCacheEntry;

public abstract class GenericCache
implements Cache,
Serializable {
    public static final int DEFAULT_CAPACITY = 20;
    int _numEntries = 0;
    GenericCacheEntry[] _cache;
    Hashtable _table;

    GenericCache(int capacity) {
        this._table = new Hashtable(capacity);
        this._cache = new GenericCacheEntry[capacity];
        while (--capacity >= 0) {
            this._cache[capacity] = new GenericCacheEntry(capacity);
        }
    }

    public abstract void addElement(Object var1, Object var2);

    public synchronized Object getElement(Object key) {
        Object obj = this._table.get(key);
        if (obj != null) {
            return ((GenericCacheEntry)obj)._value;
        }
        return null;
    }

    public final int size() {
        return this._numEntries;
    }

    public final int capacity() {
        return this._cache.length;
    }

    public final boolean isFull() {
        return this._numEntries >= this._cache.length;
    }
}

