/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import anon.crypto.JAPCertificate;
import anon.infoservice.Database;
import anon.infoservice.OperatorAddress;
import anon.infoservice.ServiceOperator;
import anon.terms.TCComposite;
import anon.terms.TermsAndConditions;
import anon.terms.template.TermsAndConditionsTemplate;
import anon.util.Base64;
import anon.util.JAPMessages;
import anon.util.LanguageMapper;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import gui.DateListener;
import gui.DatePanel;
import gui.GUIUtils;
import gui.MixConfigTextField;
import gui.TermsAndConditionsDialog;
import gui.TitledGridBagPanel;
import gui.dialog.DialogContentPane;
import gui.dialog.JAPDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SignatureException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.MutableComboBoxModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import logging.LogHolder;
import logging.LogType;
import mixconfig.ConfigurationEvent;
import mixconfig.MixConfig;
import mixconfig.MixConfiguration;
import mixconfig.infoservice.InfoServiceData;
import mixconfig.infoservice.InfoServiceTableModel;
import mixconfig.panels.MixConfigPanel;
import mixconfig.panels.TermsAndConditionsContentDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class TermsAndConditionsPanel
extends MixConfigPanel
implements ActionListener,
DateListener,
ChangeListener,
MouseListener {
    private static final String MSG_TC_CAPTION = TermsAndConditionsPanel.class.getName() + "_caption";
    private static final String MSG_TITLE_OP_GENERAL = TermsAndConditionsPanel.class.getName() + "_titleopGeneral";
    private static final String MSG_TITLE_OP_WITH_LANG = TermsAndConditionsPanel.class.getName() + "_titleopWithLang";
    private static final String MSG_TITLE_URLS = TermsAndConditionsPanel.class.getName() + "_titleurls";
    private static final String MSG_ADD_TRANSLATIONS_DIALOG = TermsAndConditionsPanel.class.getName() + "_addTranslationsDialog";
    private static final String MSG_TEMPLATE_MISMATCH = TermsAndConditionsPanel.class.getName() + "_templateMismatch";
    private static final String MSG_INFOSERVICE = TermsAndConditionsPanel.class.getName() + "_infoservice";
    static final String MSG_PREVIEW = TermsAndConditionsPanel.class.getName() + "_preview";
    private static final String MSG_URL = TermsAndConditionsPanel.class.getName() + "_url";
    private static final String MSG_PATH = TermsAndConditionsPanel.class.getName() + "_path";
    private static final String MSG_FILE = TermsAndConditionsPanel.class.getName() + "_file";
    static final String MSG_RESET = TermsAndConditionsPanel.class.getName() + "_reset";
    private static final String MSG_EXPORT = TermsAndConditionsPanel.class.getName() + "_export";
    private static final String MSG_DEFAULT_TRANSLATION = TermsAndConditionsPanel.class.getName() + "_defaultTranslation";
    private static final String MSG_AVAIL_LANG_LABEL = TermsAndConditionsPanel.class.getName() + "_availableLanguagesLabel";
    private static final String MSG_VALID_LABEL = TermsAndConditionsPanel.class.getName() + "_validLabel";
    static final String MSG_TEMPLATE_LABEL = TermsAndConditionsPanel.class.getName() + "_templateLabel";
    private static final String MSG_LANGUAGE_LABEL = TermsAndConditionsPanel.class.getName() + "_languageLabel";
    static final String MSG_TRANSLATION_LABEL = TermsAndConditionsPanel.class.getName() + "_translationLabel";
    private static final String MSG_STREET_LABEL = TermsAndConditionsPanel.class.getName() + "_streetLabel";
    private static final String MSG_ZIP_LABEL = TermsAndConditionsPanel.class.getName() + "_zipLabel";
    private static final String MSG_CITY_LABEL = TermsAndConditionsPanel.class.getName() + "_cityLabel";
    private static final String MSG_FAX_LABEL = TermsAndConditionsPanel.class.getName() + "_faxLabel";
    private static final String MSG_ADDITIONAL_INFO_LABEL = TermsAndConditionsPanel.class.getName() + "_additionalInfoLabel";
    private static final String MSG_VAT_LABEL = TermsAndConditionsPanel.class.getName() + "_vatLabel";
    private static final String MSG_VENUE_LABEL = TermsAndConditionsPanel.class.getName() + "_venueLabel";
    private static final String MSG_PRIVACY_POLICY_LABEL = TermsAndConditionsPanel.class.getName() + "_privacyPolicyURLLabel";
    private static final String MSG_LEGAL_OPINIONS_LABEL = TermsAndConditionsPanel.class.getName() + "_legalOpinionsURLLabel";
    private static final String MSG_OP_AGREEMENT_LABEL = TermsAndConditionsPanel.class.getName() + "_operationalAgreementURLLabel";
    private static final String MSG_PHOLDER_NONE_AVAIL = TermsAndConditionsPanel.class.getName() + "_pholderNoneAvail";
    private static final String MSG_PHOLDER_ADD_TRANSLATION = TermsAndConditionsPanel.class.getName() + "_pholderAddTranslation";
    private static final String MSG_PHOLDER_UPDATE = TermsAndConditionsPanel.class.getName() + "_pholderUpdate";
    private static final String MSG_FILE_EXISTS = TermsAndConditionsPanel.class.getName() + "_fileExists";
    private static final String MSG_SAVE_FILE_ERROR = TermsAndConditionsPanel.class.getName() + "_saveFileError";
    private static final String MSG_LOAD_FILE_ERROR = TermsAndConditionsPanel.class.getName() + "_loadFileError";
    private static final String ACTION_CMD_ADD_TRANSLATION = "addTranslation";
    static final String MSG_SECTION = TermsAndConditionsPanel.class.getName() + "_section";
    static final String MSG_PARAGRAPH = TermsAndConditionsPanel.class.getName() + "_paragraph";
    static final String MSG_CONTENT = TermsAndConditionsPanel.class.getName() + "_content";
    private static final String MSG_EDIT_CONTENT = TermsAndConditionsPanel.class.getName() + "_editContent";
    private static final String MSG_IMPORT_WHOLE = TermsAndConditionsPanel.class.getName() + "_importWhole";
    private static final String MSG_TEMPLATE_NOT_LOADED = TermsAndConditionsPanel.class.getName() + "_templateNotLoaded";
    private static final String MSG_TEMPLATE_NOT_LOADED_TITLE = TermsAndConditionsPanel.class.getName() + "_templateNotLoadedTitle";
    private static final String MSG_TEMPLATE_NOT_DEFINED = TermsAndConditionsPanel.class.getName() + "_templateNotDefined";
    private static final String MSG_TEMPLATE_NOT_DEFINED_TITLE = TermsAndConditionsPanel.class.getName() + "_templateNotDefinedTitle";
    private static final String MSG_WARNING_TEMPLATE_LANGUAGE = TermsAndConditionsPanel.class.getName() + "_warningTemplateLanguage";
    private static final String MSG_RECOMMEND_MIX_PATH = TermsAndConditionsPanel.class.getName() + "_recommendMixPath";
    public static final String XML_ELEMENT_TEMPLATES = "Templates";
    public static final String XML_ELEMENT_TEMPLATE = "Template";
    public static final String XML_ELEMENT_TC_OPTIONS = "TermsAndConditionsOptions";
    public static final String XML_ELEMENT_TC_TRANSLATION_IMPORTS = "TCTranslationImports";
    public static final String XMLPATH_TERMS_OPTIONS = "TermsAndConditionsOptions";
    public static final String PRIVACY_POLICY_TAG = "PrivacyPolicyUrl";
    public static final String LEGAL_OPINIONS_TAG = "LegalOpinionsUrl";
    public static final String OPERATIONAL_AGREEMENT_TAG = "OperationalAgreementUrl";
    public static final String TEMPLATE_EXPORT_ENCODING = "UTF-8";
    private DefaultComboBoxModel m_modelReferenceIDs = new DefaultComboBoxModel();
    private JComboBox m_cbReferenceIDs = new JComboBox(this.m_modelReferenceIDs);
    private JComboBox m_cbTranslations = new JComboBox();
    private boolean m_bIgnoreTemplateWarningMessages = false;
    private JButton m_btnPreview;
    private JButton m_btnAddTranslation;
    private JButton m_btnDefaultTranslation;
    private JButton m_btnDeleteTranslation;
    private JLabel m_lblWarningWrongTemplate;
    private JLabel m_lblNoticeTemplatePath;
    private JButton m_btnInfoServiceTemplate;
    private JButton m_btnFileTemplate;
    private JButton m_btnExportTemplate;
    private JButton m_btnDeleteTemplate;
    private JButton m_btnImportWhole;
    private JButton m_btnContent;
    private DatePanel m_pnlDate;
    private JTextField m_tf_templateURL;
    TitledGridBagPanel panelOperatorLeft;
    private JTextField m_tf_general_additionalInfo;
    private JTextField m_tf_general_Street;
    private JTextField m_tf_general_Post;
    private JTextField m_tf_general_City;
    private JTextField m_tf_general_VAT;
    private JTextField m_tf_general_Fax;
    private JTextField m_tf_general_Venue;
    TitledGridBagPanel panelOperatorRight;
    private JTextField m_tf_lang_additionalInfo;
    private JTextField m_tf_lang_Street;
    private JTextField m_tf_lang_Post;
    private JTextField m_tf_lang_City;
    private JTextField m_tf_lang_Fax;
    private JTextField m_tf_lang_Venue;
    private JTextField m_tfUrlPP;
    private JTextField m_tfUrlLO;
    private JTextField m_tfUrlOA;
    private JTextField m_tf_templateReferenceId;
    private PropertyToComponentMapping<JTextField>[] generalAddressMappings;
    private PropertyToComponentMapping<JTextField>[] translationAddressMappings;
    private PropertyToComponentMapping<JTextField>[] translationUrlMappings;
    private TermsAndConditions operatorTCs = null;
    private OperatorAddress generalAddress = null;
    private String selectedLanguage = "";
    private File lastOpened = null;
    private static Vector<LanguageMapper> LANGUAGE_CHOICE = LanguageMapper.getLocalisedLanguages();
    DateFormat m_dateFormatter = new SimpleDateFormat("yyyyMMdd");
    private boolean savingEnabled = true;
    private static TermsAndConditionsPanel panelSingleton = null;
    private boolean m_bInitialisingTranslations = false;

    public static TermsAndConditionsPanel get() {
        if (panelSingleton == null) {
            panelSingleton = new TermsAndConditionsPanel();
        }
        return panelSingleton;
    }

    private TermsAndConditionsPanel() {
        super(JAPMessages.getString(MSG_TC_CAPTION));
        GridBagConstraints constraints = this.getInitialConstraints();
        TitledGridBagPanel panelTranslation = new TitledGridBagPanel(JAPMessages.getString(MSG_TRANSLATION_LABEL));
        TitledGridBagPanel panelTemplate = new TitledGridBagPanel(JAPMessages.getString(MSG_TEMPLATE_LABEL));
        constraints.insets = new Insets(3, 3, 3, 3);
        constraints.gridwidth = 1;
        ++constraints.gridx;
        this.add((Component)panelTranslation, constraints);
        --constraints.gridx;
        this.add((Component)panelTemplate, constraints);
        this.m_tf_templateReferenceId = new MixConfigTextField(20);
        this.m_tf_templateReferenceId.addFocusListener(this);
        this.m_tf_templateURL = new MixConfigTextField();
        this.m_tf_templateURL.addFocusListener(this);
        this.m_btnInfoServiceTemplate = new JButton(JAPMessages.getString(MSG_INFOSERVICE));
        this.m_btnInfoServiceTemplate.addActionListener(this);
        this.m_btnPreview = new JButton(JAPMessages.getString(MSG_PREVIEW));
        this.m_btnPreview.addActionListener(this);
        this.m_btnAddTranslation = GUIUtils.createButton("bttnAdd");
        this.m_btnAddTranslation.addActionListener(this);
        this.m_btnDefaultTranslation = new JButton(JAPMessages.getString(MSG_DEFAULT_TRANSLATION));
        this.m_btnDefaultTranslation.addActionListener(this);
        this.m_btnDeleteTranslation = GUIUtils.createButton("bttnDelete");
        this.m_btnDeleteTranslation.addActionListener(this);
        this.m_btnFileTemplate = new JButton(JAPMessages.getString(MSG_FILE));
        this.m_btnFileTemplate.addActionListener(this);
        this.m_btnExportTemplate = new JButton(JAPMessages.getString(MSG_EXPORT));
        this.m_btnExportTemplate.addActionListener(this);
        this.m_btnDeleteTemplate = GUIUtils.createButton("bttnDelete");
        this.m_btnDeleteTemplate.addActionListener(this);
        this.m_btnContent = new JButton(JAPMessages.getString(MSG_EDIT_CONTENT));
        this.m_btnContent.addActionListener(this);
        this.m_btnImportWhole = new JButton(JAPMessages.getString(MSG_IMPORT_WHOLE));
        this.m_btnImportWhole.addActionListener(this);
        JPanel translationButtonPanel = new JPanel();
        translationButtonPanel.add(this.m_btnAddTranslation);
        translationButtonPanel.add(this.m_btnDefaultTranslation);
        translationButtonPanel.add(this.m_btnPreview);
        JPanel templateButtonPanel = new JPanel();
        templateButtonPanel.add(this.m_btnInfoServiceTemplate);
        templateButtonPanel.add(this.m_btnFileTemplate);
        templateButtonPanel.add(this.m_btnExportTemplate);
        JPanel templateURLPanel = new JPanel(new GridBagLayout());
        GridBagConstraints contr = new GridBagConstraints();
        contr.fill = 2;
        contr.gridx = 0;
        contr.gridy = 0;
        contr.insets = new Insets(0, 0, 0, 5);
        templateURLPanel.add((Component)GUIUtils.createLabel(MSG_URL, MSG_PATH), contr);
        ++contr.gridx;
        contr.insets = new Insets(0, 0, 0, 0);
        contr.weightx = 1.0;
        templateURLPanel.add((Component)this.m_tf_templateURL, contr);
        ++contr.gridx;
        contr.weightx = 0.0;
        contr.insets = new Insets(0, 5, 0, 0);
        this.m_lblNoticeTemplatePath = new JLabel(GUIUtils.loadImageIcon("info.png"));
        this.m_lblNoticeTemplatePath.addMouseListener(this);
        this.m_lblNoticeTemplatePath.setCursor(Cursor.getPredefinedCursor(12));
        templateURLPanel.add((Component)this.m_lblNoticeTemplatePath, contr);
        Date now = new Date(System.currentTimeMillis());
        this.m_pnlDate = new DatePanel(now);
        this.m_pnlDate.addDateListener(this);
        panelTranslation.addRow((Component)GUIUtils.createLabel(MSG_LANGUAGE_LABEL), (Component)this.m_cbTranslations, this.m_btnDeleteTranslation);
        panelTranslation.addRow(new Component[]{GUIUtils.createLabel(MSG_VALID_LABEL), this.m_pnlDate}, new int[]{1, 2});
        panelTranslation.addRow(new Component[]{translationButtonPanel}, new int[]{3});
        this.m_lblWarningWrongTemplate = new JLabel(GUIUtils.loadImageIcon("warning.gif"));
        this.m_lblWarningWrongTemplate.addMouseListener(this);
        this.m_lblWarningWrongTemplate.setCursor(Cursor.getPredefinedCursor(12));
        panelTemplate.addRow((Component)this.m_cbReferenceIDs, (Component)this.m_lblWarningWrongTemplate, this.m_btnDeleteTemplate);
        panelTemplate.addRow(new Component[]{templateURLPanel}, new int[2]);
        panelTemplate.addRow(new Component[]{templateButtonPanel}, new int[2]);
        this.panelOperatorLeft = new TitledGridBagPanel(JAPMessages.getString(MSG_TITLE_OP_GENERAL));
        ++constraints.gridy;
        constraints.gridwidth = 1;
        this.add((Component)this.panelOperatorLeft, constraints);
        this.m_tf_general_Street = new MixConfigTextField(20);
        this.m_tf_general_Street.addFocusListener(this);
        this.panelOperatorLeft.addRow((Component)GUIUtils.createLabel(MSG_STREET_LABEL), (Component)this.m_tf_general_Street, null);
        this.m_tf_general_Post = new MixConfigTextField(20);
        this.m_tf_general_Post.addFocusListener(this);
        this.m_tf_general_City = new MixConfigTextField(20);
        this.m_tf_general_City.addFocusListener(this);
        this.panelOperatorLeft.addRow((Component)GUIUtils.createLabel(MSG_ZIP_LABEL, MSG_CITY_LABEL), (Component)this.m_tf_general_Post, this.m_tf_general_City);
        this.m_tf_general_additionalInfo = new MixConfigTextField(20);
        this.m_tf_general_additionalInfo.addFocusListener(this);
        this.panelOperatorLeft.addRow((Component)GUIUtils.createLabel(MSG_ADDITIONAL_INFO_LABEL), (Component)this.m_tf_general_additionalInfo, null);
        this.m_tf_general_Fax = new MixConfigTextField(20);
        this.m_tf_general_Fax.addFocusListener(this);
        this.panelOperatorLeft.addRow((Component)GUIUtils.createLabel(MSG_FAX_LABEL), (Component)this.m_tf_general_Fax, null);
        this.m_tf_general_Venue = new MixConfigTextField(20);
        this.m_tf_general_Venue.addFocusListener(this);
        this.panelOperatorLeft.addRow((Component)GUIUtils.createLabel(MSG_VENUE_LABEL), (Component)this.m_tf_general_Venue, null);
        this.m_tf_general_VAT = new MixConfigTextField(20);
        this.m_tf_general_VAT.addFocusListener(this);
        this.panelOperatorLeft.addRow((Component)GUIUtils.createLabel(MSG_VAT_LABEL), (Component)this.m_tf_general_VAT, null);
        this.panelOperatorRight = new TitledGridBagPanel(JAPMessages.getString(MSG_TITLE_OP_WITH_LANG) + " " + this.selectedLanguage);
        ++constraints.gridx;
        constraints.fill = 1;
        this.add((Component)this.panelOperatorRight, constraints);
        constraints.fill = 2;
        this.m_tf_lang_Street = new MixConfigTextField(20);
        this.m_tf_lang_Street.addFocusListener(this);
        this.panelOperatorRight.addRow((Component)GUIUtils.createLabel(MSG_STREET_LABEL), (Component)this.m_tf_lang_Street, null);
        this.m_tf_lang_Post = new MixConfigTextField(20);
        this.m_tf_lang_Post.addFocusListener(this);
        this.m_tf_lang_City = new MixConfigTextField(20);
        this.m_tf_lang_City.addFocusListener(this);
        this.panelOperatorRight.addRow((Component)GUIUtils.createLabel(MSG_ZIP_LABEL, MSG_CITY_LABEL), (Component)this.m_tf_lang_Post, this.m_tf_lang_City);
        this.m_tf_lang_additionalInfo = new MixConfigTextField(20);
        this.m_tf_lang_additionalInfo.addFocusListener(this);
        this.panelOperatorRight.addRow((Component)GUIUtils.createLabel(MSG_ADDITIONAL_INFO_LABEL), (Component)this.m_tf_lang_additionalInfo, null);
        this.m_tf_lang_Fax = new MixConfigTextField(20);
        this.m_tf_lang_Fax.addFocusListener(this);
        this.panelOperatorRight.addRow((Component)GUIUtils.createLabel(MSG_FAX_LABEL), (Component)this.m_tf_lang_Fax, null);
        this.m_tf_lang_Venue = new MixConfigTextField(20);
        this.m_tf_lang_Venue.addFocusListener(this);
        this.panelOperatorRight.addRow((Component)GUIUtils.createLabel(MSG_VENUE_LABEL), (Component)this.m_tf_lang_Venue, null);
        this.panelOperatorRight.addRow(new Component[]{this.m_btnContent}, new int[]{1, 0});
        TitledGridBagPanel panelURLs = new TitledGridBagPanel(JAPMessages.getString(MSG_TITLE_URLS));
        --constraints.gridx;
        ++constraints.gridy;
        constraints.gridwidth = 2;
        this.add((Component)panelURLs, constraints);
        this.m_tfUrlPP = new MixConfigTextField(20);
        this.m_tfUrlPP.addFocusListener(this);
        panelURLs.addRow((Component)GUIUtils.createLabel(MSG_PRIVACY_POLICY_LABEL), (Component)this.m_tfUrlPP, null);
        this.m_tfUrlLO = new MixConfigTextField(20);
        this.m_tfUrlLO.addFocusListener(this);
        panelURLs.addRow((Component)GUIUtils.createLabel(MSG_LEGAL_OPINIONS_LABEL), (Component)this.m_tfUrlLO, null);
        this.m_tfUrlOA = new MixConfigTextField(20);
        this.m_tfUrlOA.addFocusListener(this);
        panelURLs.addRow((Component)GUIUtils.createLabel(MSG_OP_AGREEMENT_LABEL), (Component)this.m_tfUrlOA, null);
        panelURLs.setVisible(false);
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.gridwidth = 2;
        JPanel universalButtonPanel = new JPanel();
        universalButtonPanel.add(this.m_btnImportWhole);
        this.add((Component)universalButtonPanel, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        this.add((Component)new JLabel(), constraints);
        PropertyToComponentMapping privacyPolicyMapping = null;
        PropertyToComponentMapping operationalAgreementsMapping = null;
        PropertyToComponentMapping legalOpinionsMapping = null;
        try {
            BeanInfo info = Introspector.getBeanInfo(TermsAndConditions.Translation.class);
            PropertyDescriptor[] pds = info.getPropertyDescriptors();
            for (int i = 0; i < pds.length; ++i) {
                if (pds[i].getName().equals("privacyPolicyUrl")) {
                    privacyPolicyMapping = new PropertyToComponentMapping(this, pds[i], (Component)this.m_tfUrlPP);
                    continue;
                }
                if (pds[i].getName().equals("operationalAgreementUrl")) {
                    operationalAgreementsMapping = new PropertyToComponentMapping(this, pds[i], (Component)this.m_tfUrlOA);
                    continue;
                }
                if (!pds[i].getName().equals("legalOpinionsUrl")) continue;
                legalOpinionsMapping = new PropertyToComponentMapping(this, pds[i], (Component)this.m_tfUrlLO);
            }
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        this.translationUrlMappings = new PropertyToComponentMapping[]{privacyPolicyMapping, operationalAgreementsMapping, legalOpinionsMapping};
        this.generalAddressMappings = new PropertyToComponentMapping[]{new PropertyToComponentMapping(this, OperatorAddressIntrospection.getDescriptor("city"), (Component)this.m_tf_general_City), new PropertyToComponentMapping(this, OperatorAddressIntrospection.getDescriptor("street"), (Component)this.m_tf_general_Street), new PropertyToComponentMapping(this, OperatorAddressIntrospection.getDescriptor("postalCode"), (Component)this.m_tf_general_Post), new PropertyToComponentMapping(this, OperatorAddressIntrospection.getDescriptor("fax"), (Component)this.m_tf_general_Fax), new PropertyToComponentMapping(this, OperatorAddressIntrospection.getDescriptor("additionalInfo"), (Component)this.m_tf_general_additionalInfo), new PropertyToComponentMapping(this, OperatorAddressIntrospection.getDescriptor("vat"), (Component)this.m_tf_general_VAT), new PropertyToComponentMapping(this, OperatorAddressIntrospection.getDescriptor("venue"), (Component)this.m_tf_general_Venue)};
        this.translationAddressMappings = new PropertyToComponentMapping[]{new PropertyToComponentMapping(this, OperatorAddressIntrospection.getDescriptor("city"), (Component)this.m_tf_lang_City), new PropertyToComponentMapping(this, OperatorAddressIntrospection.getDescriptor("street"), (Component)this.m_tf_lang_Street), new PropertyToComponentMapping(this, OperatorAddressIntrospection.getDescriptor("postalCode"), (Component)this.m_tf_lang_Post), new PropertyToComponentMapping(this, OperatorAddressIntrospection.getDescriptor("fax"), (Component)this.m_tf_lang_Fax), new PropertyToComponentMapping(this, OperatorAddressIntrospection.getDescriptor("additionalInfo"), (Component)this.m_tf_lang_additionalInfo), new PropertyToComponentMapping(this, OperatorAddressIntrospection.getDescriptor("venue"), (Component)this.m_tf_lang_Venue)};
        this.m_cbReferenceIDs.addItemListener(this);
        this.m_cbTranslations.addItemListener(this);
    }

    @Override
    public void setConfiguration(MixConfiguration a_conf) throws IOException {
        this.enableComponents();
        super.setConfiguration(a_conf);
        a_conf.removeChangeListener(this);
        a_conf.addChangeListener(this);
        this.enableComponents();
    }

    @Override
    public void dateChanged() {
        this.saveAndLog();
    }

    @Override
    public void itemStateChanged(ItemEvent a_event) {
        if (a_event.getStateChange() == 1 && a_event.getItem() instanceof ComboBoxPlaceHolder) {
            LogHolder.log(7, LogType.MISC, "Placeholder selected: ignoring event.");
            this.m_lblWarningWrongTemplate.setVisible(false);
            return;
        }
        if (a_event.getSource() == this.m_cbReferenceIDs) {
            if (a_event.getStateChange() == 1) {
                TemplateReferenceID refId = this.getSelectedTemplateReferenceID();
                TermsAndConditions.Translation currentTrans = null;
                TermsAndConditions.Translation otherTrans = null;
                if (!this.m_bIgnoreTemplateWarningMessages && !this.m_bInitialisingTranslations) {
                    if (currentTrans != null) {
                        currentTrans.setTemplateReferenceId(refId != null ? refId.getReferenceID() : null);
                    }
                    if (refId != null && refId.isComplete()) {
                        Enumeration allTranslations = this.operatorTCs.getAllTranslations();
                        Vector<TemplateReferenceID> matchingTemplates = null;
                        while (allTranslations.hasMoreElements()) {
                            otherTrans = (TermsAndConditions.Translation)allTranslations.nextElement();
                            if (otherTrans == currentTrans || (matchingTemplates = this.getMatchingTemplateReferenceIDs(refId.getType(), otherTrans.getLocale(), refId.getDate())).size() <= 0) continue;
                            otherTrans.setTemplateReferenceId(matchingTemplates.firstElement().getReferenceID());
                        }
                    }
                }
                this.saveAndLog();
                if (refId != null && refId.getSource() == null) {
                    LogHolder.log(4, LogType.MISC, "RefId '" + refId.getReferenceID() + "' has no source specified.");
                }
                this.m_tf_templateURL.setText(refId != null ? (refId.getSource() != null ? refId.getSource().toString() : "") : "");
            }
        } else if (a_event.getSource() == this.m_cbTranslations && !this.m_bInitialisingTranslations) {
            TermsAndConditions.Translation selectedTranslation = this.getSelectedTranslation();
            if (a_event.getStateChange() == 1 && selectedTranslation != null) {
                this.loadTranslation(selectedTranslation);
                this.selectedLanguage = selectedTranslation.toString();
                this.m_bIgnoreTemplateWarningMessages = true;
                if (!this.selectTemplateReferenceID(selectedTranslation.getTemplateReferenceId())) {
                    TemplateReferenceID refId = this.getSelectedTemplateReferenceID();
                    if (refId != null) {
                        LogHolder.log(7, LogType.MISC, "Set refId of translation " + selectedTranslation + " to " + refId.getReferenceID());
                        selectedTranslation.setTemplateReferenceId(refId.getReferenceID());
                    } else {
                        LogHolder.log(4, LogType.MISC, "Template '" + selectedTranslation.getTemplateReferenceId() + "' was not found");
                    }
                }
                this.m_bIgnoreTemplateWarningMessages = false;
                ((TitledBorder)this.panelOperatorRight.getBorder()).setTitle(JAPMessages.getString(MSG_TITLE_OP_WITH_LANG) + " " + this.selectedLanguage);
                this.repaint();
            }
        } else {
            super.itemStateChanged(a_event);
        }
        if (a_event.getStateChange() == 1) {
            this.enableComponents();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        ConfigurationEvent configEvent;
        String sPath;
        if (event instanceof ConfigurationEvent && (sPath = (configEvent = (ConfigurationEvent)event).getModifiedXMLPath()).startsWith("Certificates/OperatorOwnCertificate")) {
            if (this.getServiceOperator() != null) {
                if (!this.isEnabled()) {
                    this.setEnabled(true);
                    try {
                        this.load();
                    }
                    catch (IOException e) {
                        LogHolder.log(4, LogType.MISC, "T&C panel could not be loaded.");
                    }
                }
            } else {
                this.setEnabled(false);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent a_event) {
        if (a_event.getSource() == this.m_lblWarningWrongTemplate) {
            JAPDialog.showWarningDialog(this, JAPMessages.getString(MSG_WARNING_TEMPLATE_LANGUAGE));
        } else if (a_event.getSource() == this.m_lblNoticeTemplatePath) {
            JAPDialog.showMessageDialog(this, JAPMessages.getString(MSG_RECOMMEND_MIX_PATH));
        }
    }

    @Override
    public void mouseEntered(MouseEvent a_event) {
    }

    @Override
    public void mouseExited(MouseEvent a_event) {
    }

    @Override
    public void mousePressed(MouseEvent a_event) {
    }

    @Override
    public void mouseReleased(MouseEvent a_event) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.m_btnInfoServiceTemplate) {
            this.updateFromInfoService();
            TermsAndConditions.Translation selectedTranslation = this.getSelectedTranslation();
            if (selectedTranslation != null && this.selectTemplateReferenceID(selectedTranslation.getTemplateReferenceId())) {
                LogHolder.log(7, LogType.MISC, "Model contains refID");
            } else {
                this.m_cbReferenceIDs.setSelectedItem(this.m_modelReferenceIDs.getElementAt(0));
            }
        } else if (ae.getSource() == this.m_btnAddTranslation) {
            this.actionAddTranslation();
        } else if (ae.getSource() == this.m_btnDeleteTranslation) {
            this.actionDeleteTranslation();
        } else if (ae.getSource() == this.m_btnDefaultTranslation) {
            this.actionDefaultTranslation();
        } else if (ae.getSource() == this.m_btnPreview) {
            this.actionPreviewTranslation();
        } else if (ae.getSource() == this.m_btnFileTemplate) {
            this.actionLoadTemplateFromFile();
        } else if (ae.getSource() == this.m_btnExportTemplate) {
            this.actionExportTemplate();
        } else if (ae.getSource() == this.m_btnDeleteTemplate) {
            this.actionDeleteTemplate();
        } else if (ae.getSource() == this.m_btnContent) {
            this.showContentDialog();
        } else if (ae.getSource() == this.m_btnImportWhole) {
            this.actionImportWhole();
        }
        this.saveAndLog();
        this.enableComponents();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.m_tf_templateURL) {
            this.actionSetTemplatePath();
        }
        this.saveAndLog();
        this.enableComponents();
    }

    @Override
    public synchronized Vector<String> check() {
        LogHolder.log(7, LogType.MISC, "Check invoked.");
        Vector<String> messages = new Vector<String>();
        if (this.operatorTCs == null) {
            messages.add("T&C container is null. This must not happen and seems to be a bug.");
            return messages;
        }
        if (!this.operatorTCs.hasTranslations()) {
            if (XMLUtil.getFirstChildByName(this.getConfiguration().getDocument().getDocumentElement(), "TermsAndConditionsOptions") != null) {
                messages.add("Warning: no translations defined. Please specify at least one default translation. The mix won't start without.");
            }
        } else if (!this.operatorTCs.hasDefaultTranslation()) {
            messages.add("Warning: no default translation defined. The mix won't start unless a default translation is defined.");
        }
        Enumeration enumTranslations = this.operatorTCs.getAllTranslations();
        Hashtable<String, TemplateReferenceID> hashRefIDs = new Hashtable<String, TemplateReferenceID>();
        String commonType = null;
        boolean bInvalidTemplatePath = false;
        boolean bLanguageWarning = false;
        boolean bTypeWarning = false;
        Vector<TemplateReferenceID> allRefIds = this.getAllTemplateReferenceIds();
        for (TemplateReferenceID templateReferenceID : allRefIds) {
            hashRefIDs.put(templateReferenceID.getReferenceID(), templateReferenceID);
        }
        while (enumTranslations.hasMoreElements()) {
            TermsAndConditionsTemplate template;
            TermsAndConditions.Translation translation = (TermsAndConditions.Translation)enumTranslations.nextElement();
            TemplateReferenceID templateRefID = (TemplateReferenceID)hashRefIDs.get(translation.getTemplateReferenceId());
            if (templateRefID != null) {
                if (this.operatorTCs.getDate().before(templateRefID.getDate())) {
                    messages.add("Error: The valid date of your terms  is earlier than the date of the corresponding template '" + templateRefID + "'.");
                }
                template = (TermsAndConditionsTemplate)Database.getInstance(TermsAndConditionsTemplate.class).getEntryById(templateRefID.getReferenceID());
                if (!this.checkTemplatePath(templateRefID)) {
                    bInvalidTemplatePath = true;
                }
            } else {
                template = null;
                bInvalidTemplatePath = true;
            }
            if (template == null) continue;
            if (!template.getLanguage().equals(translation.getLocale())) {
                bLanguageWarning = true;
            }
            if (commonType != null && !template.getType().equals(commonType)) {
                bTypeWarning = true;
                continue;
            }
            commonType = template.getType();
        }
        if (bInvalidTemplatePath) {
            messages.add("You should set the template path(s) for your terms and conditions to a file path on your mix server. Do not forget to export your template(s) to this path.");
        }
        if (bLanguageWarning) {
            messages.add(JAPMessages.getString(MSG_WARNING_TEMPLATE_LANGUAGE));
        }
        if (bTypeWarning) {
            messages.add("Your terms and condition translations use different template types. Warning: This may lead to juristically different terms for different languages!");
        }
        if (this.operatorTCs.getDate() == null) {
            messages.add("T&C container has no valid date set. This must not happen and seems to be a bug.");
        }
        Enumeration allTrans = this.operatorTCs.getAllTranslations();
        TermsAndConditions.Translation currentTrans = null;
        String currentTemplateRefId = null;
        while (allTrans.hasMoreElements()) {
            currentTrans = (TermsAndConditions.Translation)allTrans.nextElement();
            currentTemplateRefId = currentTrans.getTemplateReferenceId();
            if (currentTemplateRefId != null && !currentTemplateRefId.equals("")) continue;
            messages.add("Translation " + currentTrans + " has not specified a template and cannot be rendered.");
        }
        for (String message : messages) {
            LogHolder.log(4, LogType.MISC, "Found Inconsistency: " + message);
        }
        return messages;
    }

    @Override
    public String getHelpContext() {
        return TermsAndConditionsPanel.class.getName();
    }

    @Override
    public Container getHelpExtractionDisplayContext() {
        return null;
    }

    @Override
    public void load() throws IOException {
        this.load((Document)null);
    }

    private void load(Document configDoc) throws IOException {
        this.savingEnabled = false;
        try {
            this.m_lblWarningWrongTemplate.setVisible(false);
            this.initTermsAndConditionsSettings(configDoc);
            this.initGeneralAddress();
            this.initTemplates(configDoc);
            this.initTranslations();
            this.loadDate();
        }
        catch (NotLoadedException e) {
            LogHolder.log(4, LogType.MISC, "T&C panel could not be loaded.");
        }
        this.savingEnabled = true;
    }

    @Override
    public void save() throws IOException {
        Element mixConfRoot;
        NodeList nl;
        Element templatesRoot;
        if (!this.savingEnabled) {
            return;
        }
        Document configDoc = this.getConfiguration().getDocument();
        Element tcOptionsRoot = configDoc.createElement("TermsAndConditionsOptions");
        if (this.operatorTCs != null) {
            Element operatorTCsRoot;
            this.saveDate();
            TermsAndConditions.Translation selectedTranslation = this.getSelectedTranslation();
            if (selectedTranslation != null) {
                this.saveTranslation(selectedTranslation);
            }
            if ((operatorTCsRoot = this.operatorTCs.createXMLOutput(configDoc)) == null) {
                operatorTCsRoot = this.operatorTCs.createTCRoot(configDoc);
            }
            if (this.generalAddress != null) {
                this.saveGeneralAddress();
                Enumeration generalAddressElements = this.generalAddress.getAddressAsNodeList(configDoc);
                if (generalAddressElements.hasMoreElements()) {
                    Element tcTransImports = configDoc.createElement(XML_ELEMENT_TC_TRANSLATION_IMPORTS);
                    Element tcTransImportsAddress = configDoc.createElement("Operator");
                    tcTransImports.appendChild(tcTransImportsAddress);
                    operatorTCsRoot.appendChild(tcTransImports);
                    do {
                        tcTransImportsAddress.appendChild((Node)generalAddressElements.nextElement());
                    } while (generalAddressElements.hasMoreElements());
                }
            }
            if (operatorTCsRoot.hasChildNodes()) {
                tcOptionsRoot.appendChild(operatorTCsRoot);
            }
        }
        if ((templatesRoot = this.getSpecifiedTemplatesElement(configDoc)) != null) {
            tcOptionsRoot.appendChild(templatesRoot);
        }
        if ((nl = (mixConfRoot = configDoc.getDocumentElement()).getElementsByTagName("TermsAndConditionsOptions")).getLength() > 0) {
            if (tcOptionsRoot.hasChildNodes()) {
                mixConfRoot.replaceChild(tcOptionsRoot, nl.item(0));
            } else {
                mixConfRoot.removeChild(nl.item(0));
            }
        } else if (tcOptionsRoot.hasChildNodes()) {
            mixConfRoot.appendChild(tcOptionsRoot);
        }
    }

    @Override
    protected void load(Container a_container) throws IOException {
    }

    @Override
    protected void load(JComboBox a_comboBox) {
        if (a_comboBox != this.m_cbReferenceIDs && a_comboBox != this.m_cbTranslations) {
            super.load(a_comboBox);
        }
    }

    @Override
    protected void save(Container a_container) throws IOException {
        super.save(a_container);
    }

    @Override
    protected void save(JComboBox a_comboBox) {
        if (a_comboBox != this.m_cbReferenceIDs && a_comboBox != this.m_cbTranslations) {
            super.save(a_comboBox);
        }
    }

    @Override
    protected void enableComponents() {
        this.m_btnDeleteTranslation.setEnabled(this.isDeleteTranslationPossible());
        this.m_btnDefaultTranslation.setEnabled(this.isDefaultLanguagePossible());
        this.m_btnDeleteTemplate.setEnabled(this.isDeleteTemplatePossible());
        this.m_btnExportTemplate.setEnabled(this.isExportTemplatePossible());
        this.panelOperatorRight.setEnabled(this.isATranslationLoaded());
        this.m_btnContent.setEnabled(this.isContentManagementPossible());
        this.m_btnPreview.setEnabled(this.isPreviewPossible());
        this.m_tf_templateURL.setEnabled(this.isDeleteTemplatePossible());
        if (this.m_cbReferenceIDs.getItemCount() == 0) {
            this.m_cbReferenceIDs.addItem(ComboBoxPlaceHolder.createPlaceHolder(MSG_PHOLDER_UPDATE));
            this.m_tf_templateURL.setText("");
        }
        if (this.m_cbTranslations.getItemCount() == 0) {
            this.m_cbTranslations.addItem(ComboBoxPlaceHolder.createPlaceHolder(MSG_PHOLDER_ADD_TRANSLATION));
        }
        this.m_btnAddTranslation.setEnabled(this.isAddTranslationPossible());
        TemplateReferenceID refId = this.getSelectedTemplateReferenceID();
        this.m_lblNoticeTemplatePath.setVisible(!this.checkTemplatePath(refId));
        this.m_lblWarningWrongTemplate.setVisible(this.isWrongTemplateSet());
        this.repaint();
    }

    private DialogResult<LanguageMapper> showAddTranslationsDialog(String selected) {
        final JAPDialog translationsDialog = new JAPDialog(MixConfig.getMainWindow(), JAPMessages.getString(MSG_ADD_TRANSLATIONS_DIALOG), true);
        final JComboBox<LanguageMapper> languageChoiceBox = new JComboBox<LanguageMapper>();
        final DialogResult result = new DialogResult();
        translationsDialog.setDefaultCloseOperation(1);
        translationsDialog.getContentPane().setLayout(new BorderLayout());
        JPanel langPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        langPanel.setLayout(new FlowLayout());
        buttonPanel.setLayout(new FlowLayout());
        JLabel langLabel = GUIUtils.createLabel(MSG_AVAIL_LANG_LABEL);
        final JButton addButton = GUIUtils.createButton("bttnAdd");
        addButton.setActionCommand(ACTION_CMD_ADD_TRANSLATION);
        final JButton cancelButton = new JButton(JAPMessages.getString(DialogContentPane.MSG_CANCEL));
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    Object selectedItem = languageChoiceBox.getSelectedItem();
                    if (selectedItem != null && selectedItem instanceof LanguageMapper) {
                        String selectedLang = ((LanguageMapper)selectedItem).getISOCode().toLowerCase();
                        addButton.setEnabled(!TermsAndConditionsPanel.this.operatorTCs.hasTranslation(selectedLang));
                    } else {
                        addButton.setEnabled(false);
                    }
                }
            }
        };
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                result.reset();
                if (e.getSource() != cancelButton && languageChoiceBox.getSelectedItem() instanceof LanguageMapper) {
                    result.setCommand(e.getActionCommand());
                    result.setResult((LanguageMapper)languageChoiceBox.getSelectedItem());
                }
                translationsDialog.setVisible(false);
            }
        };
        addButton.addActionListener(buttonListener);
        cancelButton.addActionListener(buttonListener);
        languageChoiceBox.addItemListener(itemListener);
        for (LanguageMapper langMapper : LANGUAGE_CHOICE) {
            languageChoiceBox.addItem(langMapper);
            if (selected == null || !langMapper.getISOCode().equals(selected)) continue;
            languageChoiceBox.setSelectedItem(langMapper);
        }
        langPanel.add(langLabel);
        langPanel.add(languageChoiceBox);
        buttonPanel.add(cancelButton);
        buttonPanel.add(addButton);
        translationsDialog.getContentPane().add((Component)langPanel, "Center");
        translationsDialog.getContentPane().add((Component)buttonPanel, "South");
        translationsDialog.pack();
        translationsDialog.setVisible(true);
        return result.getCommand() != null && result.getResult() != null ? result : null;
    }

    private boolean checkTemplatePath(TemplateReferenceID templateRefID) {
        URI templateURI;
        if (templateRefID == null) {
            return true;
        }
        if (templateRefID.getSource() == null) {
            return false;
        }
        try {
            templateURI = new URI(templateRefID.getSource().toString());
        }
        catch (URISyntaxException e) {
            LogHolder.log(2, LogType.GUI, e);
            return false;
        }
        return templateRefID.getSource().getProtocol().equals("file") && !new File(templateURI).exists();
    }

    private void showContentDialog() {
        TermsAndConditions.Translation translation;
        TermsAndConditionsTemplate template = this.getSelectedTemplate();
        TCComposite translationSections = TermsAndConditionsContentDialog.showContentDialog(this, template, translation = this.getSelectedTranslation());
        if (translationSections != null) {
            translation.setSections(translationSections);
        }
    }

    private TermsAndConditionsTemplate getSelectedTemplate() {
        TemplateReferenceID refId = this.getSelectedTemplateReferenceID();
        TermsAndConditionsTemplate template = (TermsAndConditionsTemplate)(refId != null ? Database.getInstance(TermsAndConditionsTemplate.class).getEntryById(refId.getReferenceID()) : null);
        return template;
    }

    private void actionAddTranslation() {
        DialogResult<LanguageMapper> result;
        String newLangCode = null;
        TemplateReferenceID selectedRefId = this.getSelectedTemplateReferenceID();
        if (selectedRefId == null || !selectedRefId.isComplete()) {
            return;
        }
        if (this.getSelectedTemplate() == null && JAPDialog.showYesNoDialog((Component)this, JAPMessages.getString(MSG_TEMPLATE_NOT_LOADED, selectedRefId), JAPMessages.getString(MSG_TEMPLATE_NOT_LOADED_TITLE))) {
            this.updateFromInfoService();
        }
        Vector<TemplateReferenceID> templateRefIDs = this.getAllTemplateReferenceIds();
        for (TemplateReferenceID templateReferenceID : templateRefIDs) {
            if (this.operatorTCs.hasTranslation(templateReferenceID.getLangCode())) continue;
            newLangCode = templateReferenceID.getLangCode();
            break;
        }
        if ((result = this.showAddTranslationsDialog(newLangCode)) != null && result.getResult() != null && result.getCommand() != null) {
            LanguageMapper langMapper = result.getResult();
            String cmd = result.getCommand();
            TermsAndConditions.Translation t = null;
            if (cmd.equals(ACTION_CMD_ADD_TRANSLATION)) {
                String langCode = langMapper.getISOCode().toLowerCase();
                TermsAndConditionsPanel.removeFirstPlaceHolder(this.m_cbTranslations);
                if (this.operatorTCs.hasTranslation(langCode)) {
                    LogHolder.log(4, LogType.MISC, "Translation " + langMapper + " already exists");
                } else {
                    LogHolder.log(7, LogType.MISC, "Add translation " + langMapper);
                    t = this.operatorTCs.initializeEmptyTranslation(langCode);
                    boolean refIdSet = false;
                    for (int i = 0; i < 3; ++i) {
                        templateRefIDs = this.getMatchingTemplateReferenceIDs(i > 1 ? selectedRefId.getType() : null, langCode, i > 0 ? selectedRefId.getDate() : null);
                        if (templateRefIDs.size() <= 0) continue;
                        String matchingRefId = templateRefIDs.firstElement().getReferenceID();
                        TermsAndConditionsTemplate matchingTemplate = (TermsAndConditionsTemplate)Database.getInstance(TermsAndConditionsTemplate.class).getEntryById(matchingRefId);
                        if (matchingTemplate == null && JAPDialog.showYesNoDialog((Component)this, JAPMessages.getString(MSG_TEMPLATE_NOT_LOADED, matchingRefId), JAPMessages.getString(MSG_TEMPLATE_NOT_LOADED_TITLE))) {
                            this.updateFromInfoService();
                        }
                        t.setTemplateReferenceId(matchingRefId);
                        refIdSet = true;
                        break;
                    }
                    if (!refIdSet) {
                        Locale loc = new Locale(langCode);
                        JAPDialog.showWarningDialog((Component)this, JAPMessages.getString(MSG_TEMPLATE_NOT_DEFINED, loc.getDisplayLanguage()), JAPMessages.getString(MSG_TEMPLATE_NOT_DEFINED_TITLE));
                    }
                    TermsAndConditionsPanel.updateObject(this.m_cbTranslations, t, true);
                    if (!this.operatorTCs.hasDefaultTranslation() || langCode.equals("en")) {
                        t.setDefaultTranslation(true);
                    }
                }
            }
        }
    }

    private void actionPreviewTranslation() {
        TermsAndConditions.Translation previewTranslation = this.getPreviewTranslation();
        if (previewTranslation != null) {
            TermsAndConditionsDialog.previewTranslation(this, previewTranslation);
        }
    }

    private void actionLoadTemplateFromFile() {
        JFileChooser fc = this.lastOpened != null ? new JFileChooser(this.lastOpened) : new JFileChooser();
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(true);
        int clicked = fc.showDialog(this, JAPMessages.getString("bttnLoad"));
        switch (clicked) {
            case 0: {
                File[] fs;
                boolean somethingAdded = false;
                TermsAndConditionsTemplate currentTemplate = null;
                for (File file : fs = fc.getSelectedFiles()) {
                    try {
                        currentTemplate = new TermsAndConditionsTemplate(file);
                        if (!currentTemplate.isVerified() && !JAPDialog.showYesNoDialog(this, "The template " + currentTemplate.getId() + " does not have a valid signature! It will not be accepted by the users. Load it nevertheless?")) continue;
                        Database.getInstance(TermsAndConditionsTemplate.class).update(currentTemplate);
                        if (!somethingAdded) {
                            somethingAdded = true;
                            TermsAndConditionsPanel.removeFirstPlaceHolder(this.m_cbReferenceIDs);
                        }
                        if (!this.isTemplateReferenceIdInComboBox(currentTemplate.getId())) {
                            TermsAndConditionsPanel.updateObject(this.m_cbReferenceIDs, new TemplateReferenceID(currentTemplate.getId(), file.toURI().toURL()), false);
                        }
                        this.lastOpened = file.getParentFile();
                    }
                    catch (XMLParseException e) {
                        JAPDialog.showErrorDialog((Component)this, JAPMessages.getString(MSG_LOAD_FILE_ERROR), (Throwable)e);
                    }
                    catch (IOException e) {
                        JAPDialog.showErrorDialog((Component)this, JAPMessages.getString(MSG_LOAD_FILE_ERROR), (Throwable)e);
                    }
                }
                break;
            }
            case 1: {
                break;
            }
        }
    }

    private void actionImportWhole() {
        JFileChooser fc = this.lastOpened != null ? new JFileChooser(this.lastOpened) : new JFileChooser();
        fc.setFileSelectionMode(0);
        int clicked = fc.showDialog(this, JAPMessages.getString("bttnLoad"));
        switch (clicked) {
            case 0: {
                File file = fc.getSelectedFile();
                try {
                    InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), TEMPLATE_EXPORT_ENCODING);
                    Document doc = XMLUtil.readXMLDocument(reader);
                    if (doc == null || doc.getDocumentElement() == null) {
                        throw new XMLParseException("No document found");
                    }
                    NodeList nl = doc.getElementsByTagName("TermsAndConditionsOptions");
                    if (nl.getLength() < 1) {
                        throw new XMLParseException("No T&C Options element found");
                    }
                    Element tcOptionsRoot = (Element)nl.item(0);
                    if ((nl = tcOptionsRoot.getElementsByTagName("TermsAndConditions")).getLength() < 1) {
                        throw new XMLParseException("No T&C element found");
                    }
                    this.load(doc);
                }
                catch (XMLParseException e) {
                    JAPDialog.showErrorDialog((Component)this, JAPMessages.getString(MSG_LOAD_FILE_ERROR), (Throwable)e);
                }
                catch (IOException e) {
                    JAPDialog.showErrorDialog((Component)this, JAPMessages.getString(MSG_LOAD_FILE_ERROR), (Throwable)e);
                }
                break;
            }
            case 1: {
                break;
            }
        }
    }

    private void actionExportTemplate() {
        TemplateReferenceID refId = this.getSelectedTemplateReferenceID();
        TermsAndConditionsTemplate template = (TermsAndConditionsTemplate)(refId != null ? Database.getInstance(TermsAndConditionsTemplate.class).getEntryById(refId.getReferenceID()) : null);
        if (template != null) {
            String suggestedFileName = refId.getReferenceID() + ".xml";
            JFileChooser fc = this.lastOpened != null ? new JFileChooser(this.lastOpened) : new JFileChooser();
            File suggestedFile = new File(fc.getCurrentDirectory() + File.separator + suggestedFileName);
            fc.setSelectedFile(suggestedFile);
            int clicked = fc.showSaveDialog(this);
            switch (clicked) {
                case 0: {
                    File selectedFile = fc.getSelectedFile();
                    boolean confirmed = true;
                    if (selectedFile.exists()) {
                        boolean bl = confirmed = JAPDialog.showConfirmDialog((Component)this, JAPMessages.getString(MSG_FILE_EXISTS, selectedFile.getName()), 0, 3) == 0;
                    }
                    if (!confirmed) break;
                    try {
                        String exportEncoding = template.getDocument().getTextContent();
                        if (exportEncoding == null) {
                            exportEncoding = TEMPLATE_EXPORT_ENCODING;
                        }
                        OutputStreamWriter exportWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(selectedFile), exportEncoding);
                        XMLUtil.write(template.getDocument(), exportWriter);
                        exportWriter.flush();
                        exportWriter.close();
                    }
                    catch (IOException e) {
                        JAPDialog.showErrorDialog((Component)this, JAPMessages.getString(MSG_SAVE_FILE_ERROR, selectedFile.getName()), (Throwable)e);
                    }
                    break;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    private void actionDeleteTemplate() {
        TemplateReferenceID refId = this.getSelectedTemplateReferenceID();
        if (refId != null) {
            this.m_cbReferenceIDs.removeItem(refId);
            Database.getInstance(TermsAndConditionsTemplate.class).remove(refId.getReferenceID());
        }
    }

    private void actionSetTemplatePath() {
        TemplateReferenceID refId = this.getSelectedTemplateReferenceID();
        if (refId != null && this.m_tf_templateURL.getText() != null && !this.m_tf_templateURL.getText().equals("")) {
            TermsAndConditionsTemplate template = null;
            try {
                URL newTemplateUrl = new URL(this.m_tf_templateURL.getText());
                try {
                    template = this.getTemplateFromURL(newTemplateUrl);
                    if (template != null) {
                        if (!template.getId().equals(refId.getReferenceID())) {
                            JAPDialog.showErrorDialog((Component)this, JAPMessages.getString(MSG_TEMPLATE_MISMATCH, new Object[]{template.getId(), refId.getReferenceID()}));
                            this.m_tf_templateURL.setText(refId.getSource().toString());
                            return;
                        }
                        Database.getInstance(TermsAndConditionsTemplate.class).update(template);
                    }
                }
                catch (IOException e) {
                }
                catch (XMLParseException e) {
                    LogHolder.log(4, LogType.MISC, "The template at '" + refId.getSource() + "' cannot be parsed.");
                }
                refId.setSource(newTemplateUrl);
            }
            catch (MalformedURLException e) {
                this.m_tf_templateURL.setText(refId.getSource().toString());
            }
        }
    }

    private void actionDeleteTranslation() {
        TermsAndConditions.Translation selectedTranslation = this.getSelectedTranslation();
        if (selectedTranslation != null) {
            LogHolder.log(7, LogType.MISC, "Remove translation: " + selectedTranslation);
            this.operatorTCs.removeTranslation(selectedTranslation.getLocale());
            this.clearTranslationFields();
            this.m_cbTranslations.removeItem(selectedTranslation);
        }
    }

    private void actionDefaultTranslation() {
        TermsAndConditions.Translation oldDefault = this.operatorTCs.getDefaultTranslation();
        TermsAndConditions.Translation newDefault = this.getSelectedTranslation();
        if (newDefault != null && newDefault != oldDefault) {
            if (oldDefault != null) {
                oldDefault.setDefaultTranslation(false);
            }
            LogHolder.log(7, LogType.MISC, "set translation: " + newDefault + " to default");
            newDefault.setDefaultTranslation(true);
        }
    }

    private void loadDate() {
        Date date = this.operatorTCs != null ? this.operatorTCs.getDate() : new Date(System.currentTimeMillis());
        LogHolder.log(7, LogType.MISC, "Loading date " + date);
        this.m_pnlDate.setDate(date);
    }

    private void loadTranslation(TermsAndConditions.Translation translation) {
        if (translation != null) {
            int i;
            OperatorAddress addr = translation.getOperatorAddress();
            Method currentGetter = null;
            Object currentValue = null;
            for (i = 0; i < this.translationUrlMappings.length; ++i) {
                currentGetter = this.translationUrlMappings[i].getPropertyDescriptor().getReadMethod();
                try {
                    currentValue = currentGetter.invoke((Object)translation, (Object[])null);
                }
                catch (Exception e) {
                    LogHolder.log(2, LogType.MISC, e);
                }
                if (this.translationUrlMappings[i].getComponent() == null) continue;
                this.translationUrlMappings[i].getComponent().setText(currentValue != null ? currentValue.toString() : "");
            }
            for (i = 0; i < this.translationAddressMappings.length; ++i) {
                currentGetter = this.translationAddressMappings[i].getPropertyDescriptor().getReadMethod();
                try {
                    currentValue = addr != null ? currentGetter.invoke((Object)addr, (Object[])null) : null;
                }
                catch (Exception e) {
                    LogHolder.log(2, LogType.MISC, e);
                }
                this.translationAddressMappings[i].getComponent().setText(currentValue != null ? currentValue.toString() : "");
            }
        }
    }

    private ServiceOperator getServiceOperator() {
        if (this.getConfiguration() == null) {
            return null;
        }
        String opCertFromConfig = this.getConfiguration().getValue("Certificates/OperatorOwnCertificate/X509Certificate");
        JAPCertificate operatorCertificate = opCertFromConfig != null ? JAPCertificate.getInstance(Base64.decode(opCertFromConfig)) : null;
        return operatorCertificate != null ? new ServiceOperator(operatorCertificate) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTermsAndConditionsSettings(Document configDoc) throws IOException, NotLoadedException {
        Document rootConfigDoc = configDoc != null ? configDoc : this.getConfiguration().getDocument();
        NodeList nl = rootConfigDoc.getElementsByTagName("TermsAndConditions");
        ServiceOperator operator = this.getServiceOperator();
        this.operatorTCs = null;
        if (operator == null) {
            LogHolder.log(3, LogType.MISC, "No operator is specified. Cannot initiate any terms and conditions without operator settings.");
            this.setEnabled(false);
            throw new NotLoadedException();
        }
        try {
            if (nl.getLength() > 0) {
                Element root = (Element)nl.item(0);
                this.operatorTCs = new TermsAndConditions(root, operator, false);
                String[] parentNames = new String[]{XML_ELEMENT_TC_TRANSLATION_IMPORTS, "Operator"};
                for (int i = 0; i < parentNames.length && root != null; ++i) {
                    nl = root.getElementsByTagName(parentNames[i]);
                    root = (Element)(nl.getLength() > 0 ? nl.item(0) : null);
                }
                this.generalAddress = root != null ? new OperatorAddress(root) : new OperatorAddress();
            }
        }
        catch (SignatureException se) {
            LogHolder.log(3, LogType.MISC, se);
        }
        catch (XMLParseException xpe) {
            LogHolder.log(3, LogType.MISC, xpe);
        }
        catch (ParseException pe) {
            LogHolder.log(3, LogType.MISC, pe);
        }
        finally {
            if (this.operatorTCs == null) {
                LogHolder.log(6, LogType.MISC, "creating new Terms And Conditions container.");
                try {
                    Date now = new Date(System.currentTimeMillis());
                    this.operatorTCs = new TermsAndConditions(operator, now);
                    this.generalAddress = new OperatorAddress();
                }
                catch (ParseException e) {
                    throw new IOException("Wrong format of the newly created date. This should never happen!");
                }
            }
            this.setEnabled(true);
        }
    }

    private void initGeneralAddress() {
        Method currentGetter = null;
        Object currentValue = null;
        for (int i = 0; i < this.generalAddressMappings.length; ++i) {
            currentGetter = this.generalAddressMappings[i].getPropertyDescriptor().getReadMethod();
            try {
                currentValue = currentGetter.invoke((Object)this.generalAddress, (Object[])null);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            this.generalAddressMappings[i].getComponent().setText(currentValue != null ? currentValue.toString() : "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTemplates(Document configDoc) {
        Document rootConfigDoc;
        Document document = rootConfigDoc = configDoc != null ? configDoc : this.getConfiguration().getDocument();
        if (rootConfigDoc == null || rootConfigDoc.getDocumentElement() == null) {
            return;
        }
        NodeList nl = rootConfigDoc.getElementsByTagName(XML_ELEMENT_TEMPLATE);
        Element currentElement = null;
        String currentTemplateURLValue = null;
        if (nl.getLength() == 0) {
            return;
        }
        TemplateReferenceID[] allRefIds = new TemplateReferenceID[nl.getLength()];
        this.m_bInitialisingTranslations = true;
        for (int i = 0; i < nl.getLength(); ++i) {
            TemplateReferenceID refIdItem;
            block17: {
                URL currentTemplateURL;
                block14: {
                    TermsAndConditionsTemplate template;
                    block12: {
                        block16: {
                            block13: {
                                currentElement = (Element)nl.item(i);
                                currentTemplateURLValue = currentElement.getTextContent();
                                template = null;
                                currentTemplateURL = null;
                                if (currentElement.hasAttribute("id") && currentTemplateURLValue != null) break block12;
                                LogHolder.log(3, LogType.MISC, "Will not load template, because it is not specified correctly.");
                                allRefIds[i] = null;
                                refIdItem = null;
                                if (template == null) break block13;
                                Database.getInstance(TermsAndConditionsTemplate.class).update(template);
                                refIdItem = new TemplateReferenceID(template.getId(), currentTemplateURL);
                                break block16;
                            }
                            refIdItem = new TemplateReferenceID(currentElement.getAttribute("id"), currentTemplateURL);
                        }
                        if (refIdItem != null && this.isTemplateReferenceIdInComboBox(refIdItem.getReferenceID())) continue;
                        allRefIds[i] = refIdItem;
                        continue;
                    }
                    try {
                        currentTemplateURL = new URL(currentTemplateURLValue);
                        template = this.getTemplateFromURL(currentTemplateURL);
                        refIdItem = null;
                        if (template == null) break block14;
                    }
                    catch (Exception e) {
                        block18: {
                            block15: {
                                try {
                                    LogHolder.log(3, LogType.MISC, "Could not load template, reason: " + e.getMessage());
                                    refIdItem = null;
                                    if (template == null) break block15;
                                }
                                catch (Throwable throwable) {
                                    TemplateReferenceID refIdItem2 = null;
                                    if (template != null) {
                                        Database.getInstance(TermsAndConditionsTemplate.class).update(template);
                                        refIdItem2 = new TemplateReferenceID(template.getId(), currentTemplateURL);
                                    } else {
                                        refIdItem2 = new TemplateReferenceID(currentElement.getAttribute("id"), currentTemplateURL);
                                    }
                                    if (refIdItem2 == null || !this.isTemplateReferenceIdInComboBox(refIdItem2.getReferenceID())) {
                                        allRefIds[i] = refIdItem2;
                                    }
                                    throw throwable;
                                }
                                Database.getInstance(TermsAndConditionsTemplate.class).update(template);
                                refIdItem = new TemplateReferenceID(template.getId(), currentTemplateURL);
                                break block18;
                            }
                            refIdItem = new TemplateReferenceID(currentElement.getAttribute("id"), currentTemplateURL);
                        }
                        if (refIdItem != null && this.isTemplateReferenceIdInComboBox(refIdItem.getReferenceID())) continue;
                        allRefIds[i] = refIdItem;
                        continue;
                    }
                    Database.getInstance(TermsAndConditionsTemplate.class).update(template);
                    refIdItem = new TemplateReferenceID(template.getId(), currentTemplateURL);
                    break block17;
                }
                refIdItem = new TemplateReferenceID(currentElement.getAttribute("id"), currentTemplateURL);
            }
            if (refIdItem != null && this.isTemplateReferenceIdInComboBox(refIdItem.getReferenceID())) continue;
            allRefIds[i] = refIdItem;
            continue;
        }
        for (TemplateReferenceID refId : allRefIds) {
            if (refId == null) continue;
            TermsAndConditionsPanel.updateObject(this.m_cbReferenceIDs, refId, false);
        }
        this.m_bInitialisingTranslations = false;
    }

    private void initTranslations() {
        this.m_cbTranslations.removeAllItems();
        this.clearTranslationFields();
        if (this.operatorTCs != null) {
            this.m_bInitialisingTranslations = true;
            Enumeration supportedLanguages = this.operatorTCs.getAllTranslations();
            TermsAndConditions.Translation currentTrans = null;
            while (supportedLanguages.hasMoreElements()) {
                currentTrans = (TermsAndConditions.Translation)supportedLanguages.nextElement();
                TermsAndConditionsPanel.updateObject(this.m_cbTranslations, currentTrans, false);
                if (!currentTrans.isDefaultTranslation()) continue;
                this.m_cbTranslations.setSelectedItem(currentTrans);
                this.loadTranslation(currentTrans);
            }
            TermsAndConditions.Translation selectedTranslation = this.getSelectedTranslation();
            String string = this.selectedLanguage = selectedTranslation != null ? selectedTranslation.getLocale() : null;
            if (this.selectedLanguage != null) {
                ((TitledBorder)this.panelOperatorRight.getBorder()).setTitle(JAPMessages.getString(MSG_TITLE_OP_WITH_LANG) + " " + this.selectedLanguage);
            }
            this.m_bInitialisingTranslations = false;
            this.itemStateChanged(new ItemEvent(this.m_cbTranslations, 701, this.m_cbTranslations.getSelectedItem(), 1));
        }
    }

    private synchronized void saveAndLog() {
        try {
            this.save();
        }
        catch (IOException e) {
            LogHolder.log(4, LogType.MISC, "Could not save the T&C configuration, reason: " + e.getMessage());
        }
    }

    private InfoServiceTableModel getInfoServices() {
        InfoServiceTableModel tableModel = new InfoServiceTableModel();
        NodeList infoServices = this.getConfiguration().getDocument().getElementsByTagName("InfoServices");
        if (infoServices.getLength() == 1) {
            tableModel.readFromElement((Element)infoServices.item(0));
        }
        return tableModel;
    }

    private TermsAndConditionsTemplate getTemplateFromURL(URL templateURL) throws IOException, XMLParseException {
        InputStream inputStream = null;
        URLConnection currentConn = templateURL.openConnection();
        try {
            inputStream = currentConn.getContentEncoding() != null && currentConn.getContentEncoding().contains("deflate") ? new InflaterInputStream(currentConn.getInputStream()) : currentConn.getInputStream();
        }
        catch (NullPointerException npe) {
            throw new IOException(npe);
        }
        Document templateDoc = XMLUtil.readXMLDocument(inputStream);
        Element docElement = templateDoc.getDocumentElement();
        if (currentConn instanceof HttpURLConnection) {
            ((HttpURLConnection)currentConn).disconnect();
        }
        TermsAndConditionsTemplate template = docElement != null ? new TermsAndConditionsTemplate(docElement) : null;
        return template;
    }

    public void updateFromInfoService() {
        LogHolder.log(7, LogType.MISC, "Getting available 'Terms and Conditions Templates'");
        InfoServiceTableModel infoServices = this.getInfoServices();
        int infoServicesNumber = infoServices.getRowCount();
        boolean success = false;
        for (int counter = 0; !success && counter < infoServicesNumber; ++counter) {
            InfoServiceData isData = infoServices.getData(counter);
            String host = isData.getListenerInterface(0).getHost();
            int port = isData.getListenerInterface(0).getPort();
            LogHolder.log(7, LogType.MISC, "Asking " + host + ":" + port);
            try {
                URL requestURL = new URL("http", host, port, "/tctemplates");
                HttpURLConnection conn = (HttpURLConnection)requestURL.openConnection();
                DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document serialsDoc = db.parse(conn.getInputStream());
                conn.disconnect();
                NodeList nl = serialsDoc.getDocumentElement().getElementsByTagName(TermsAndConditionsTemplate.XML_ELEMENT_NAME);
                String currentTemplateRefID = null;
                URL currentTemplateURL = null;
                if (nl.getLength() == 0) {
                    LogHolder.log(7, LogType.MISC, "Failed ...");
                    continue;
                }
                if (nl.getLength() <= 0) continue;
                TermsAndConditionsPanel.removeFirstPlaceHolder(this.m_cbReferenceIDs);
                success = true;
                TermsAndConditionsTemplate currentTemplate = null;
                for (int i = 0; i < nl.getLength(); ++i) {
                    currentTemplateRefID = ((Element)nl.item(i)).getAttribute("id");
                    currentTemplateURL = new URL("http", host, port, "/tctemplate/" + currentTemplateRefID);
                    currentTemplate = this.getTemplateFromURL(currentTemplateURL);
                    if (currentTemplate == null) continue;
                    Database.getInstance(TermsAndConditionsTemplate.class).update(currentTemplate);
                    if (this.isTemplateReferenceIdInComboBox(currentTemplate.getId())) continue;
                    TemplateReferenceID refIdItem = new TemplateReferenceID(currentTemplate.getId(), currentTemplateURL);
                    TermsAndConditionsPanel.updateObject(this.m_cbReferenceIDs, refIdItem, false);
                }
                continue;
            }
            catch (MalformedURLException mue) {
                LogHolder.log(2, LogType.NET, "Error: " + mue.getMessage());
                continue;
            }
            catch (IOException ioe) {
                LogHolder.log(2, LogType.NET, "Error: " + ioe.getMessage());
                continue;
            }
            catch (SAXException se) {
                LogHolder.log(2, LogType.MISC, "Error: " + se.getMessage());
                continue;
            }
            catch (ParserConfigurationException pce) {
                LogHolder.log(2, LogType.MISC, "Error: " + pce.getMessage());
                continue;
            }
            catch (IllegalArgumentException iae) {
                LogHolder.log(2, LogType.MISC, "Error: " + iae.getMessage());
                continue;
            }
            catch (XMLParseException xpe) {
                LogHolder.log(2, LogType.MISC, "Error: " + xpe.getMessage());
            }
        }
    }

    private void saveDate() {
        if (this.operatorTCs != null) {
            Calendar cal = this.m_pnlDate.getCalendar();
            String sDate = this.m_dateFormatter.format(cal.getTime());
            LogHolder.log(7, LogType.MISC, "Saving the date: " + sDate);
            this.operatorTCs.setDate(this.m_pnlDate.getDate());
        }
    }

    private Element getSpecifiedTemplatesElement(Document ownerDoc) {
        Element templatesRoot = null;
        if (this.m_cbReferenceIDs.getItemCount() > 0 && !(this.m_cbReferenceIDs.getSelectedItem() instanceof ComboBoxPlaceHolder)) {
            templatesRoot = ownerDoc.createElement(XML_ELEMENT_TEMPLATES);
            Element currentTemplateElement = null;
            Object currentItem = null;
            TemplateReferenceID currentRefId = null;
            for (int i = 0; i < this.m_cbReferenceIDs.getItemCount(); ++i) {
                currentItem = this.m_cbReferenceIDs.getItemAt(i);
                if (currentItem == null || !(currentItem instanceof TemplateReferenceID)) continue;
                currentRefId = (TemplateReferenceID)this.m_cbReferenceIDs.getItemAt(i);
                currentTemplateElement = currentRefId.toXMLElement(ownerDoc);
                currentTemplateElement.setAttribute("id", currentRefId.getReferenceID());
                templatesRoot.appendChild(currentTemplateElement);
            }
        }
        return templatesRoot;
    }

    private void saveTranslation(TermsAndConditions.Translation translation) {
        if (translation != null) {
            int i;
            OperatorAddress addr = translation.getOperatorAddress();
            Method currentSetter = null;
            String currentValue = null;
            for (i = 0; i < this.translationUrlMappings.length; ++i) {
                currentSetter = this.translationUrlMappings[i].getPropertyDescriptor().getWriteMethod();
                if (this.translationUrlMappings[i].getComponent() == null) continue;
                currentValue = this.translationUrlMappings[i].getComponent().getText();
                try {
                    currentSetter.invoke((Object)translation, currentValue);
                    continue;
                }
                catch (Exception e) {
                    LogHolder.log(2, LogType.GUI, e);
                }
            }
            if (addr == null) {
                addr = new OperatorAddress();
                translation.setOperatorAddress(addr);
            }
            for (i = 0; i < this.translationAddressMappings.length; ++i) {
                currentSetter = this.translationAddressMappings[i].getPropertyDescriptor().getWriteMethod();
                currentValue = this.translationAddressMappings[i].getComponent().getText();
                try {
                    currentSetter.invoke((Object)addr, currentValue);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    continue;
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void saveGeneralAddress() {
        Method currentSetter = null;
        String currentValue = null;
        for (int i = 0; i < this.generalAddressMappings.length; ++i) {
            currentSetter = this.generalAddressMappings[i].getPropertyDescriptor().getWriteMethod();
            currentValue = this.generalAddressMappings[i].getComponent().getText();
            try {
                currentSetter.invoke((Object)this.generalAddress, currentValue);
                continue;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void clearTranslationFields() {
        int i;
        for (i = 0; i < this.translationUrlMappings.length; ++i) {
            this.translationUrlMappings[i].getComponent().setText("");
        }
        for (i = 0; i < this.translationAddressMappings.length; ++i) {
            this.translationAddressMappings[i].getComponent().setText("");
        }
    }

    private boolean selectTemplateReferenceID(String templateReferenceID) {
        TemplateReferenceID currentTemplateRefId = null;
        for (int i = 0; i < this.m_cbReferenceIDs.getItemCount(); ++i) {
            if (!(this.m_cbReferenceIDs.getItemAt(i) instanceof TemplateReferenceID) || (currentTemplateRefId = (TemplateReferenceID)this.m_cbReferenceIDs.getItemAt(i)).getReferenceID() == null || !currentTemplateRefId.getReferenceID().equals(templateReferenceID)) continue;
            if (this.m_cbReferenceIDs.getSelectedIndex() != i) {
                this.m_cbReferenceIDs.setSelectedIndex(i);
            }
            return true;
        }
        return false;
    }

    private boolean isATranslationLoaded() {
        return this.m_cbTranslations.getItemCount() > 1 || this.m_cbTranslations.getItemCount() == 1 && this.m_cbTranslations.getItemAt(0) instanceof TermsAndConditions.Translation;
    }

    private boolean isTemplateReferenceIdInComboBox(String templateReferenceID) {
        TemplateReferenceID currentTemplateRefId = null;
        for (int i = 0; i < this.m_cbReferenceIDs.getItemCount(); ++i) {
            if (!(this.m_cbReferenceIDs.getItemAt(i) instanceof TemplateReferenceID) || (currentTemplateRefId = (TemplateReferenceID)this.m_cbReferenceIDs.getItemAt(i)).getReferenceID() == null || !currentTemplateRefId.getReferenceID().equals(templateReferenceID)) continue;
            return true;
        }
        return false;
    }

    private boolean isAddTranslationPossible() {
        TemplateReferenceID selectedRefId = this.getSelectedTemplateReferenceID();
        return selectedRefId != null && selectedRefId.isComplete();
    }

    TermsAndConditions.Translation getPreviewTranslation() {
        Document rootConfigDoc = this.getConfiguration().getDocument();
        NodeList nl = rootConfigDoc.getElementsByTagName(XML_ELEMENT_TC_TRANSLATION_IMPORTS);
        TermsAndConditions.Translation currentTranslation = this.getSelectedTranslation();
        if (currentTranslation == null || this.operatorTCs == null) {
            return null;
        }
        return nl.getLength() > 0 ? TermsAndConditionsPanel.duplicateWithImports(this.operatorTCs, currentTranslation, (Element)nl.item(0)) : currentTranslation;
    }

    private boolean isDefaultLanguagePossible() {
        TermsAndConditions.Translation currentTrans = this.getSelectedTranslation();
        return currentTrans != null ? !currentTrans.isDefaultTranslation() : false;
    }

    private boolean isDeleteTranslationPossible() {
        return this.getSelectedTranslation() != null;
    }

    private boolean isWrongTemplateSet() {
        TemplateReferenceID refId = this.getSelectedTemplateReferenceID();
        TermsAndConditions.Translation currentTrans = this.getSelectedTranslation();
        return currentTrans != null && currentTrans.getLocale() != null && refId != null && refId.getLangCode() != null && !currentTrans.getLocale().equals(refId.getLangCode());
    }

    boolean isPreviewPossible() {
        return this.isTransformationPossible();
    }

    private boolean isContentManagementPossible() {
        return this.isTransformationPossible();
    }

    private boolean isTransformationPossible() {
        TermsAndConditionsTemplate template = null;
        TermsAndConditions.Translation currentTranslation = this.getSelectedTranslation();
        String templateRefID = null;
        if (currentTranslation != null && (templateRefID = currentTranslation.getTemplateReferenceId()) != null && !templateRefID.equals("")) {
            template = (TermsAndConditionsTemplate)Database.getInstance(TermsAndConditionsTemplate.class).getEntryById(templateRefID);
            return template != null;
        }
        return false;
    }

    private boolean isExportTemplatePossible() {
        TemplateReferenceID refId = this.getSelectedTemplateReferenceID();
        TermsAndConditionsTemplate template = (TermsAndConditionsTemplate)(refId != null ? Database.getInstance(TermsAndConditionsTemplate.class).getEntryById(refId.getReferenceID()) : null);
        return template != null;
    }

    private boolean isDeleteTemplatePossible() {
        return this.getSelectedTemplateReferenceID() != null;
    }

    private TermsAndConditions.Translation getSelectedTranslation() {
        Object selected = this.m_cbTranslations.getSelectedItem();
        return (TermsAndConditions.Translation)(selected instanceof TermsAndConditions.Translation ? selected : null);
    }

    private TemplateReferenceID getSelectedTemplateReferenceID() {
        Object selected = this.m_cbReferenceIDs.getSelectedItem();
        return (TemplateReferenceID)(selected instanceof TemplateReferenceID ? selected : null);
    }

    private Vector<TemplateReferenceID> getAllTemplateReferenceIds() {
        return this.getMatchingTemplateReferenceIDs(null, null, null);
    }

    private Vector<TemplateReferenceID> getMatchingTemplateReferenceIDs(String type, String langCode, Date date) {
        Vector<TemplateReferenceID> returnItems = new Vector<TemplateReferenceID>();
        Object currentItem = null;
        TemplateReferenceID refId = null;
        boolean typeMatches = false;
        boolean langCodeMatches = false;
        boolean dateMatches = false;
        for (int i = 0; i < this.m_cbReferenceIDs.getItemCount(); ++i) {
            currentItem = this.m_cbReferenceIDs.getItemAt(i);
            if (currentItem == null || !(currentItem instanceof TemplateReferenceID)) continue;
            refId = currentItem;
            boolean bl = type != null ? (refId.getType() != null ? refId.getType().equals(type) : false) : (typeMatches = true);
            boolean bl2 = langCode != null ? (refId.getLangCode() != null ? refId.getLangCode().equals(langCode) : false) : (langCodeMatches = true);
            boolean bl3 = date != null ? (refId.getDate() != null ? refId.getDate().equals(date) : false) : (dateMatches = true);
            if (!typeMatches || !langCodeMatches || !dateMatches) continue;
            returnItems.add(refId);
        }
        return returnItems;
    }

    private static void updateObject(JComboBox comboBox, Object o, boolean selectForced) {
        boolean selectedRemoved = false;
        if (comboBox.getModel() instanceof MutableComboBoxModel) {
            MutableComboBoxModel cbModel = (MutableComboBoxModel)comboBox.getModel();
            Object currentItem = null;
            Object selectedItem = cbModel.getSelectedItem();
            TermsAndConditionsPanel.removeFirstPlaceHolder(comboBox);
            for (int i = 0; i < cbModel.getSize(); ++i) {
                currentItem = cbModel.getElementAt(i);
                if (!cbModel.getElementAt(i).equals(o)) continue;
                cbModel.removeElementAt(i);
                selectedRemoved = selectedItem == currentItem;
                break;
            }
        }
        comboBox.addItem(o);
        if (selectForced || selectedRemoved) {
            comboBox.setSelectedItem(o);
        }
    }

    private static void removeFirstPlaceHolder(JComboBox comboBox) {
        if (comboBox.getModel() instanceof MutableComboBoxModel) {
            MutableComboBoxModel cbModel = (MutableComboBoxModel)comboBox.getModel();
            for (int i = 0; i < cbModel.getSize(); ++i) {
                if (!(cbModel.getElementAt(i) instanceof ComboBoxPlaceHolder)) continue;
                cbModel.removeElementAt(i);
                return;
            }
        }
    }

    private static TermsAndConditions.Translation duplicateWithImports(TermsAndConditions tcsContainer, TermsAndConditions.Translation translation, Element xmlImports) {
        try {
            TermsAndConditions termsAndConditions = tcsContainer;
            termsAndConditions.getClass();
            TermsAndConditions.Translation importTrans = termsAndConditions.new TermsAndConditions.Translation(xmlImports, false);
            Object currentValue = null;
            Method currentGetter = null;
            Method currentSetter = null;
            PropertyDescriptor[] translationPDs = Introspector.getBeanInfo(translation.getClass()).getPropertyDescriptors();
            for (int i = 0; i < translationPDs.length; ++i) {
                if (translationPDs[i].getName().equals("operatorAddress") || translationPDs[i].getName().equals("defaultTranslation") || translationPDs[i].getWriteMethod() == null) continue;
                currentGetter = translationPDs[i].getReadMethod();
                currentSetter = translationPDs[i].getWriteMethod();
                System.out.println("invoking getter: " + currentGetter);
                currentValue = currentGetter.invoke((Object)translation, null);
                if (currentValue == null || currentValue.toString().equals("")) continue;
                currentSetter.invoke((Object)importTrans, currentValue);
            }
            if (importTrans.getOperator() == null) {
                importTrans.setOperatorAddress(translation.getOperatorAddress());
            } else if (translation.getOperatorAddress() != null) {
                PropertyDescriptor[] addressPDs = Introspector.getBeanInfo(OperatorAddress.class).getPropertyDescriptors();
                for (int i = 0; i < addressPDs.length; ++i) {
                    if (addressPDs[i].getWriteMethod() == null) continue;
                    currentGetter = addressPDs[i].getReadMethod();
                    currentSetter = addressPDs[i].getWriteMethod();
                    currentValue = currentGetter.invoke((Object)translation.getOperatorAddress(), null);
                    if (currentValue == null || currentValue.toString().equals("")) continue;
                    currentSetter.invoke((Object)importTrans.getOperatorAddress(), currentValue);
                }
            }
            return importTrans;
        }
        catch (XMLParseException e) {
            e.printStackTrace();
        }
        catch (IntrospectionException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    static class OperatorAddressIntrospection {
        private static Hashtable propertyDescriptors = new Hashtable();

        OperatorAddressIntrospection() {
        }

        public static PropertyDescriptor getDescriptor(String propertyName) {
            return (PropertyDescriptor)propertyDescriptors.get(propertyName);
        }

        static {
            try {
                BeanInfo info = Introspector.getBeanInfo(OperatorAddress.class);
                PropertyDescriptor[] pds = info.getPropertyDescriptors();
                for (int i = 0; i < pds.length; ++i) {
                    propertyDescriptors.put(pds[i].getName(), pds[i]);
                }
            }
            catch (IntrospectionException introspectionException) {
                // empty catch block
            }
        }
    }

    class NotLoadedException
    extends Exception {
        NotLoadedException() {
        }
    }

    private class DialogResult<ResultType> {
        private ResultType result = null;
        private String command = null;

        public DialogResult() {
        }

        public void reset() {
            this.result = null;
            this.command = null;
        }

        public DialogResult(String command, ResultType result) {
            this.result = result;
            this.command = command;
        }

        public ResultType getResult() {
            return this.result;
        }

        public void setResult(ResultType locale) {
            this.result = locale;
        }

        public String getCommand() {
            return this.command;
        }

        public void setCommand(String command) {
            this.command = command;
        }
    }

    private static class PropertyToComponentMapping<ComponentType extends Component> {
        private PropertyDescriptor propertyDescriptor = null;
        private ComponentType component = null;
        final /* synthetic */ TermsAndConditionsPanel this$0;

        public PropertyToComponentMapping(PropertyDescriptor propertyDescriptor, ComponentType component) {
            this.this$0 = var1_1;
            this.propertyDescriptor = propertyDescriptor;
            this.component = component;
        }

        public PropertyDescriptor getPropertyDescriptor() {
            return this.propertyDescriptor;
        }

        public void setPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
            this.propertyDescriptor = propertyDescriptor;
        }

        public ComponentType getComponent() {
            return this.component;
        }

        public void setComponent(ComponentType component) {
            this.component = component;
        }
    }

    private class TemplateReferenceID {
        private URL source;
        private String type;
        private Date date;
        private String langCode;

        private TemplateReferenceID() {
            this.type = null;
            this.date = null;
            this.langCode = null;
            this.source = null;
        }

        private TemplateReferenceID(String name, LanguageMapper langMapper, Date date, String sourceURL) throws MalformedURLException {
            this(name, langMapper, date, new URL(sourceURL));
        }

        private TemplateReferenceID(String type, LanguageMapper langMapper, Date date, URL source) {
            this(type, langMapper.getISOCode().toLowerCase(), date, source);
        }

        private TemplateReferenceID(String type, String langCode, Date date, URL source) {
            this.type = type;
            this.date = date;
            this.langCode = langCode;
            this.source = source;
        }

        private TemplateReferenceID(String referenceID, URL source) {
            this.setReferenceID(referenceID);
            this.source = source;
        }

        public String getReferenceID() {
            return this.isComplete() ? this.type + "_" + this.langCode + "_" + TermsAndConditionsPanel.this.m_dateFormatter.format(this.date) : null;
        }

        private void setReferenceID(String referenceId) {
            StringTokenizer refIdTokenizer = new StringTokenizer(referenceId, "_");
            if (refIdTokenizer.countTokens() != 3) {
                throw new IllegalArgumentException("Not a valid template reference id: " + referenceId);
            }
            String tempType = refIdTokenizer.nextToken();
            String tempLangCode = refIdTokenizer.nextToken();
            Date tempDate = null;
            try {
                tempDate = new SimpleDateFormat("yyyyMMdd").parse(refIdTokenizer.nextToken());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("refernce id " + referenceId + " contains invalid date.");
            }
            this.setType(tempType);
            this.setLangCode(tempLangCode);
            this.setDate(tempDate);
        }

        public URL getSource() {
            return this.source;
        }

        public void setSource(URL source) {
            this.source = source;
        }

        public boolean equals(Object otherRefid) {
            if (otherRefid == null) {
                return false;
            }
            if (!(otherRefid instanceof TemplateReferenceID)) {
                return false;
            }
            return ((TemplateReferenceID)otherRefid).getReferenceID().equals(this.getReferenceID());
        }

        public String toString() {
            return this.getReferenceID();
        }

        public Element toXMLElement(Document doc) {
            Element templateElement = doc.createElement(TermsAndConditionsPanel.XML_ELEMENT_TEMPLATE);
            templateElement.setTextContent(this.source.toString());
            return templateElement;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Date getDate() {
            return this.date;
        }

        public void setDate(Date date) {
            this.date = date;
        }

        public String getLangCode() {
            return this.langCode;
        }

        public void setLangCode(String langCode) {
            this.langCode = langCode;
        }

        public boolean isComplete() {
            return this.type != null && this.langCode != null && this.date != null;
        }
    }

    private static class ComboBoxPlaceHolder {
        private String message;

        private ComboBoxPlaceHolder() {
            this.message = null;
        }

        private ComboBoxPlaceHolder(String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public String toString() {
            return this.getMessage();
        }

        public boolean equals(Object o) {
            return o instanceof ComboBoxPlaceHolder ? this.message.equals(((ComboBoxPlaceHolder)o).message) : false;
        }

        public static ComboBoxPlaceHolder createPlaceHolder(String messageKey) {
            return new ComboBoxPlaceHolder(JAPMessages.getString(messageKey));
        }
    }
}

