/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import anon.crypto.ICertificate;
import anon.crypto.MyRSAPublicKey;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import logging.LogHolder;
import logging.LogType;
import mixconfig.MixConfiguration;
import mixconfig.panels.CertPanel;
import mixconfig.panels.MixConfigPanel;
import mixconfig.tools.dataretention.DataRetentionEncryptionCertCreationValidator;
import mixconfig.tools.dataretention.DataRetentionSmartCard;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DataRetentionPanel
extends JPanel
implements ActionListener,
FocusListener {
    private static final String ACTIONCOMMAND_IMPORTDATARETENTIONKEY = "impordataretentionkey";
    private MixConfigPanel m_parentPanel = null;
    private JButton m_bttnImportDataRetentionKey;
    private JTextField m_tfDataRetentionKey;
    private JPanel m_panelDataRetentionKeyStoreCards;
    private JTextField m_tfDataRetentionLogDir;
    private JCheckBox m_cbDoDataRetention;

    public DataRetentionPanel(MixConfigPanel parentPanel) {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Data Retention"));
        this.m_parentPanel = parentPanel;
        this.m_cbDoDataRetention = new JCheckBox("Enable Data Retention Logs");
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.fill = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        this.add((Component)this.m_cbDoDataRetention, c);
        JPanel panelKeyStore = new JPanel(new GridBagLayout());
        panelKeyStore.setBorder(new TitledBorder("Encryption Key Storage"));
        c.gridy = 0;
        c.gridx = 3;
        c.gridwidth = 1;
        c.gridheight = 2;
        c.weightx = 0.0;
        this.add((Component)panelKeyStore, c);
        JRadioButton radiobuttonSmartCard = new JRadioButton("Store on SmartCard");
        JRadioButton radiobuttonDisk = new JRadioButton("Store on Disk (USB-Stick etc.)");
        ButtonGroup bttngrpDataRetentionKeyStore = new ButtonGroup();
        bttngrpDataRetentionKeyStore.add(radiobuttonDisk);
        bttngrpDataRetentionKeyStore.add(radiobuttonSmartCard);
        radiobuttonDisk.setSelected(true);
        radiobuttonSmartCard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((CardLayout)DataRetentionPanel.this.m_panelDataRetentionKeyStoreCards.getLayout()).show(DataRetentionPanel.this.m_panelDataRetentionKeyStoreCards, "smartcard");
            }
        });
        radiobuttonDisk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((CardLayout)DataRetentionPanel.this.m_panelDataRetentionKeyStoreCards.getLayout()).show(DataRetentionPanel.this.m_panelDataRetentionKeyStoreCards, "disk");
            }
        });
        JPanel panelDataRetentionKeyStoreSelection = new JPanel();
        panelDataRetentionKeyStoreSelection.add(radiobuttonDisk);
        panelDataRetentionKeyStoreSelection.add(radiobuttonSmartCard);
        GridBagConstraints constraintsPanelKeyStore = new GridBagConstraints();
        constraintsPanelKeyStore.gridy = 0;
        panelKeyStore.add((Component)panelDataRetentionKeyStoreSelection, constraintsPanelKeyStore);
        this.m_panelDataRetentionKeyStoreCards = new JPanel(new CardLayout());
        constraintsPanelKeyStore.gridy = 1;
        constraintsPanelKeyStore.gridx = 0;
        constraintsPanelKeyStore.fill = 1;
        constraintsPanelKeyStore.weightx = 1.0;
        constraintsPanelKeyStore.weighty = 1.0;
        panelKeyStore.add((Component)this.m_panelDataRetentionKeyStoreCards, constraintsPanelKeyStore);
        JPanel p = new JPanel(new GridBagLayout());
        GridBagConstraints cp = new GridBagConstraints();
        final CertPanel certp = new CertPanel("Log encryption key (USB stick or similar external storage)", "This key is used to encrypt the data retention logs", null, 1, 0, 2048);
        certp.setCertCreationValidator(new DataRetentionEncryptionCertCreationValidator());
        certp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent arg0) {
                MixConfiguration c = DataRetentionPanel.this.m_parentPanel.getConfiguration();
                Document doc = c.getDocument();
                ICertificate cert = certp.getCert();
                if (cert == null) {
                    c.removeNode("DataRetention/PublicEncryptionKey");
                } else {
                    MyRSAPublicKey key = (MyRSAPublicKey)cert.getPublicKey();
                    Element elem = key.toXmlElement(doc);
                    Element elemPEK = doc.createElement("PublicEncryptionKey");
                    c.setValue("DataRetention", elemPEK);
                }
            }
        });
        cp.gridy = 0;
        cp.weightx = 1.0;
        cp.weighty = 1.0;
        cp.fill = 1;
        p.add((Component)certp, cp);
        this.m_panelDataRetentionKeyStoreCards.add((Component)p, "disk");
        p = new JPanel(new GridBagLayout());
        this.m_bttnImportDataRetentionKey = new JButton("Import public key from Smart Card...");
        this.m_bttnImportDataRetentionKey.setActionCommand(ACTIONCOMMAND_IMPORTDATARETENTIONKEY);
        this.m_bttnImportDataRetentionKey.addActionListener(this);
        cp.gridy = 0;
        p.add((Component)this.m_bttnImportDataRetentionKey, cp);
        this.m_tfDataRetentionKey = new JTextField();
        cp.gridy = 1;
        cp.weightx = 1.0;
        cp.fill = 2;
        p.add((Component)this.m_tfDataRetentionKey, cp);
        this.m_panelDataRetentionKeyStoreCards.add((Component)p, "smartcard");
        JLabel l = new JLabel("Log directory:");
        c.anchor = 18;
        c.fill = 2;
        c.weightx = 0.0;
        c.gridy = 1;
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        this.add((Component)l, c);
        this.m_tfDataRetentionLogDir = new JTextField();
        this.m_tfDataRetentionLogDir.setName("DataRetention/LogDir");
        this.m_tfDataRetentionLogDir.addFocusListener(this);
        c.anchor = 18;
        c.fill = 2;
        c.weightx = 1.0;
        c.gridy = 1;
        c.gridx = 1;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.insets = new Insets(0, 10, 0, 10);
        this.add((Component)this.m_tfDataRetentionLogDir, c);
    }

    @Override
    public void focusGained(FocusEvent a_event) {
    }

    @Override
    public void focusLost(FocusEvent a_event) {
        if (a_event.getSource() == this.m_tfDataRetentionLogDir) {
            this.m_parentPanel.save(this.m_tfDataRetentionLogDir);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(ACTIONCOMMAND_IMPORTDATARETENTIONKEY)) {
            this.importDataRetentionKey();
        }
    }

    private void importDataRetentionKey() {
        try {
            DataRetentionSmartCard smartcard = new DataRetentionSmartCard();
            smartcard.connectToSmartCard();
            MyRSAPublicKey key = smartcard.retrievePublicKey();
            this.m_tfDataRetentionKey.setText(key.toString());
            MixConfiguration c = this.m_parentPanel.getConfiguration();
            Document doc = c.getDocument();
            Element elem = key.toXmlElement(doc);
            Element elemPEK = doc.createElement("PublicEncryptionKey");
            elemPEK.appendChild(elem);
            c.setValue("DataRetention", elemPEK);
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.MISC, "Error accesing smart card " + e.getMessage());
        }
    }
}

