/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import gui.GUIUtils;
import gui.MixConfigTextField;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import mixconfig.ConfigurationEvent;
import mixconfig.MixConfig;
import mixconfig.MixConfiguration;
import mixconfig.panels.MixConfigPanel;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class CascadePanel
extends MixConfigPanel
implements ActionListener,
ListSelectionListener,
ChangeListener {
    private static final String IMG_ARROW_DOWN = CascadePanel.class.getName() + "_downarrow.gif";
    private static final String IMG_ARROW_UP = CascadePanel.class.getName() + "_uparrow.gif";
    private JTable m_availableMixTable;
    private JTable m_configuredMixTable;
    private JButton m_moveMixUpButton;
    private JButton m_moveMixDownButton;
    private JButton m_addMixButton;
    private JButton m_remMixButton;
    private JButton m_recvMixListButton;
    private JTextField m_tfCascadeName;

    public CascadePanel() {
        super("Cascade");
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagConstraints constraints = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        constraints.fill = 0;
        constraints.anchor = 18;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.m_tfCascadeName = new MixConfigTextField(20);
        this.m_tfCascadeName.setName("General/CascadeName");
        this.m_tfCascadeName.addFocusListener(this);
        constraints.fill = 2;
        this.add((Component)new JLabel("Cascade name"), constraints);
        constraints.gridx = 1;
        constraints.gridwidth = 2;
        this.add((Component)this.m_tfCascadeName, constraints);
        constraints.fill = 0;
        constraints.gridwidth = 1;
        constraints.gridx = 0;
        ++constraints.gridy;
        this.m_recvMixListButton = new JButton("Update");
        this.m_recvMixListButton.addActionListener(this);
        this.m_availableMixTable = new JTable(new MixListTableModel());
        JScrollPane scrollPane1 = new JScrollPane(this.m_availableMixTable, 22, 30);
        ++constraints.gridy;
        this.add((Component)new JLabel("Available mixes:"), constraints);
        ++constraints.gridx;
        this.add((Component)this.m_recvMixListButton, constraints);
        this.m_availableMixTable.getSelectionModel().addListSelectionListener(this);
        ++constraints.gridy;
        constraints.fill = 1;
        constraints.weighty = 0.5;
        constraints.gridx = 0;
        constraints.gridwidth = 3;
        this.add((Component)scrollPane1, constraints);
        constraints.fill = 0;
        constraints.weighty = 0.0;
        ImageIcon downarrow = GUIUtils.loadImageIcon(IMG_ARROW_DOWN);
        this.m_addMixButton = new JButton(downarrow);
        this.m_addMixButton.addActionListener(this);
        this.m_addMixButton.setToolTipText("Use the buttons to move available mixes into your cascade.");
        ImageIcon uparrow = GUIUtils.loadImageIcon(IMG_ARROW_UP);
        this.m_remMixButton = new JButton(uparrow);
        this.m_remMixButton.addActionListener(this);
        this.m_remMixButton.setToolTipText("Use the buttons to move available mixes into your cascade.");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(1));
        buttonPanel.add(this.m_addMixButton);
        buttonPanel.add(this.m_remMixButton);
        ++constraints.gridy;
        constraints.gridwidth = 3;
        constraints.anchor = 10;
        constraints.gridx = 0;
        this.add((Component)buttonPanel, constraints);
        this.m_configuredMixTable = new JTable(new MixListTableModel());
        JScrollPane scrollPane2 = new JScrollPane(this.m_configuredMixTable, 22, 30);
        this.m_configuredMixTable.getSelectionModel().addListSelectionListener(this);
        this.m_configuredMixTable.setName("MixCascade");
        constraints.gridx = 0;
        ++constraints.gridy;
        constraints.anchor = 18;
        this.add((Component)new JLabel("Current cascade (top entry = first mix):"), constraints);
        ++constraints.gridy;
        constraints.fill = 1;
        constraints.weighty = 0.5;
        constraints.gridwidth = 3;
        this.add((Component)scrollPane2, constraints);
        constraints.gridwidth = 1;
        constraints.fill = 0;
        this.m_moveMixUpButton = new JButton(GUIUtils.loadImageIcon("arrowUp.gif"));
        this.m_moveMixUpButton.addActionListener(this);
        this.m_moveMixUpButton.setToolTipText("Move selected mix up in cascade");
        this.m_moveMixDownButton = new JButton(GUIUtils.loadImageIcon("arrowDown.gif"));
        this.m_moveMixDownButton.addActionListener(this);
        this.m_moveMixDownButton.setToolTipText("Move selected mix down in cascade");
        JPanel buttonPanel2 = new JPanel();
        buttonPanel2.setLayout(new FlowLayout());
        buttonPanel2.add(this.m_moveMixUpButton);
        buttonPanel2.add(this.m_moveMixDownButton);
        constraints.gridx = 2;
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.anchor = 12;
        this.add((Component)buttonPanel2, constraints);
        this.enableComponents();
    }

    @Override
    public Vector<String> check() {
        Vector<String> errors = new Vector<String>();
        MixListTableModel confMix = (MixListTableModel)this.m_configuredMixTable.getModel();
        if (this.getConfiguration().getMixType() != 4) {
            return errors;
        }
        String s = this.getConfiguration().getValue("General/CascadeName");
        if (s == null || s.equals("")) {
            errors.addElement("Cascade Name not entered.");
        }
        if (confMix.getRowCount() > 1) {
            int i;
            String mtype = confMix.getValueAt(0, 3).toString();
            if (!mtype.equals("FirstMix")) {
                errors.addElement(new String("The first mix in the cascade does not want to be first mix. Please re-arrange the cascade in Cascade Panel."));
            }
            if (!(mtype = confMix.getValueAt(confMix.getRowCount() - 1, 3).toString()).equals("LastMix")) {
                errors.addElement(new String("The last mix in the cascade does not want to be last mix. Please re-arrange the cascade in Cascade Panel."));
            }
            for (i = confMix.getRowCount() - 2; i > 0; --i) {
                mtype = confMix.getValueAt(i, 3).toString();
                if (mtype.equals("MiddleMix")) continue;
                errors.addElement(new String("One of the mixes in the cascade does not want to be middle mix. Please re-arrange the cascade."));
                break;
            }
            for (i = 0; i < confMix.getRowCount() - 2; ++i) {
                Object cascadeLength = confMix.getValueAt(i, 4);
                if (cascadeLength == null || cascadeLength.toString().trim().length() <= 0 || new Integer(cascadeLength.toString()) <= confMix.getRowCount()) continue;
                errors.addElement(new String("One or more of the mixes in the cascade require(s) a greater cascade size. Please add more mixes or remove that mix."));
                break;
            }
        } else {
            errors.addElement(new String("Too few mixes in cascade. Please add at least two mixes in Cascade Panel."));
        }
        return errors;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (e.getSource() == this.m_addMixButton) {
                CascadePanel.moveMix(this.m_availableMixTable, this.m_configuredMixTable);
            } else if (e.getSource() == this.m_recvMixListButton) {
                this.m_availableMixTable.setModel(new MixListTableModel());
                this.m_availableMixTable.setModel(new MixListTableModel(this.recvMixList()));
            } else if (e.getSource() == this.m_remMixButton) {
                CascadePanel.moveMix(this.m_configuredMixTable, this.m_availableMixTable);
            } else if (e.getSource() == this.m_moveMixUpButton) {
                int i = this.m_configuredMixTable.getSelectedRow();
                ((MixListTableModel)this.m_configuredMixTable.getModel()).moveRow(i, i - 1);
            } else if (e.getSource() == this.m_moveMixDownButton) {
                int i = this.m_configuredMixTable.getSelectedRow();
                ((MixListTableModel)this.m_configuredMixTable.getModel()).moveRow(i, i + 1);
            }
            this.save(this.m_configuredMixTable);
            this.enableComponents();
        }
        catch (ConnectException ce) {
            if (ce.getMessage().trim().equalsIgnoreCase("Connection refused")) {
                MixConfig.info("InfoService not available", new String[]{"The InfoService is not responding.", "You may continue configuration now and retry later"});
            }
        }
        catch (Exception ex) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), null, (Throwable)ex);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.enableComponents();
    }

    @Override
    public String getHelpContext() {
        return "index";
    }

    private static void moveMix(JTable src, JTable dest) {
        MixListTableModel smltm = (MixListTableModel)src.getModel();
        MixListTableModel dmltm = (MixListTableModel)dest.getModel();
        Object[] mix = smltm.getRow(src.getSelectedRow());
        smltm.removeRow(src.getSelectedRow());
        dmltm.addRow(mix);
    }

    @Override
    protected void enableComponents() {
        String hostName = null;
        String hostPort = null;
        int c = this.m_configuredMixTable.getRowCount() - 1;
        int s = this.m_configuredMixTable.getSelectedRow();
        if (this.getConfiguration() != null) {
            hostName = this.getConfiguration().getValue("Network/InfoService/Host");
            if (hostName == null || hostName.equals("")) {
                hostName = this.getConfiguration().getValue("Network/InfoService/IP");
            }
            hostPort = this.getConfiguration().getValue("Network/InfoService/Port");
        }
        this.m_recvMixListButton.setEnabled(hostName != null && hostPort != null);
        this.m_addMixButton.setEnabled(this.m_availableMixTable.getSelectedRowCount() == 1);
        this.m_remMixButton.setEnabled(this.m_configuredMixTable.getSelectedRowCount() == 1 && s < c);
        this.m_moveMixUpButton.setEnabled(s > 0 && s < c);
        this.m_moveMixDownButton.setEnabled(s >= 0 && s < c - 1);
    }

    private Element recvMixList() throws MalformedURLException, ParserConfigurationException, IOException, SAXException {
        String hostName = this.getConfiguration().getValue("Network/InfoService/Host");
        if (hostName == null || hostName.equals("")) {
            hostName = this.getConfiguration().getValue("Network/InfoService/IP");
        }
        String hostPort = this.getConfiguration().getValue("Network/InfoService/Port");
        URL infoService = new URL("http", hostName, Integer.valueOf(hostPort), "/availablemixes");
        HttpURLConnection conn = (HttpURLConnection)infoService.openConnection();
        DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document mixListDoc = db.parse(conn.getInputStream());
        conn.disconnect();
        NodeList nl = mixListDoc.getDocumentElement().getElementsByTagName("Mix");
        if (nl.getLength() == 0) {
            MixConfig.info("No mixes available", new String[]{"The InfoService returned an empty list.", "You may continue configuration now", "and retry later when enough mixes have", "registered themselves with the InfoService."});
        }
        return mixListDoc.getDocumentElement();
    }

    @Override
    protected void load(JTextField a_textField) {
        super.load(a_textField);
        if (a_textField == this.m_tfCascadeName && a_textField.getText() != null && a_textField.getText().equals("******Dynamic cascade bug*******")) {
            a_textField.setText("");
        }
    }

    @Override
    protected void load(JTable a_table) {
        if (a_table == this.m_configuredMixTable) {
            Object[] myself = new Object[5];
            myself[0] = this.getConfiguration().getValue("General/MixID");
            myself[1] = this.getConfiguration().getValue("General/MixName");
            myself[2] = this.getConfiguration().getValue("Description/Location/City");
            myself[3] = this.getConfiguration().getValue("General/MixType");
            if (myself[3] != null) {
                Integer t = new Integer(myself[3].toString());
                myself[3] = MixConfiguration.getMixTypeAsString(t);
            }
            myself[4] = new String();
            this.m_configuredMixTable.setModel(new MixListTableModel());
            this.m_availableMixTable.setModel(new MixListTableModel());
            NodeList n = this.getConfiguration().getDocument().getElementsByTagName("MixCascade");
            if (n.getLength() > 0) {
                this.m_configuredMixTable.setModel(new MixListTableModel((Element)n.item(0)));
            }
            ((MixListTableModel)this.m_configuredMixTable.getModel()).addRow(myself);
        }
    }

    @Override
    public void setConfiguration(MixConfiguration a_mixConf) throws IOException {
        super.setConfiguration(a_mixConf);
        a_mixConf.removeChangeListener(this);
        a_mixConf.addChangeListener(this);
        this.setEnabled(this.getConfiguration().getMixType() == 4 && this.getConfiguration().isAutoConfigurationAllowed());
    }

    @Override
    public void stateChanged(ChangeEvent a_event) {
        if (a_event instanceof ConfigurationEvent) {
            String value;
            int mixType = this.getConfiguration().getMixType();
            ConfigurationEvent ce = (ConfigurationEvent)a_event;
            int col = -1;
            if (ce.getModifiedXMLPath().endsWith("MixID")) {
                col = 0;
            } else if (ce.getModifiedXMLPath().endsWith("MixName")) {
                col = 1;
            } else if (ce.getModifiedXMLPath().endsWith("City")) {
                col = 2;
            } else if (ce.getModifiedXMLPath().equals("Network/InfoService/AllowAutoConfiguration")) {
                this.setEnabled(mixType == 4 && this.getConfiguration().isAutoConfigurationAllowed());
            } else if (ce.getModifiedXMLPath().equals("General/MixType")) {
                col = 3;
                this.setEnabled(mixType == 4 && this.getConfiguration().isAutoConfigurationAllowed());
            } else if (ce.getModifiedXMLPath().endsWith("MinCascadeLength")) {
                col = 4;
            } else if (ce.getModifiedXMLPath().equals("General/CascadeName") && ((value = this.getConfiguration().getValue("General/CascadeName")) == null || !value.equals(this.m_tfCascadeName.getText()))) {
                this.load(this.m_tfCascadeName);
            }
            if (col >= 0 && this.m_configuredMixTable.getRowCount() > 0) {
                String v = ce.getNewValue() == null ? "" : ce.getNewValue().toString();
                if (col == 3) {
                    Integer t = new Integer(v);
                    v = MixConfiguration.getMixTypeAsString(t);
                }
                this.m_configuredMixTable.setValueAt(v, this.m_configuredMixTable.getRowCount() - 1, col);
            }
            this.enableComponents();
        }
    }

    @Override
    public Container getHelpExtractionDisplayContext() {
        return null;
    }

    public class MixListTableModel
    extends AbstractTableModel {
        private final String[] columnName = new String[]{"Mix ID", "Mix name", "Location", "Type"};
        Vector<Object[]> mixList = new Vector();

        public MixListTableModel() {
        }

        public MixListTableModel(Element a_mixList) {
            NodeList nl = a_mixList.getElementsByTagName("Mix");
            for (int i = 0; i < nl.getLength(); ++i) {
                String strMixType = this.getElementData((Element)nl.item(i), "MixType");
                if (strMixType.equalsIgnoreCase("LastMix")) continue;
                this.addRow((Element)nl.item(i));
            }
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            if (this.mixList == null) {
                return 0;
            }
            return this.mixList.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return new String().getClass();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnName[columnIndex];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex > this.getColumnCount() - 1 || rowIndex > this.getRowCount() - 1) {
                return null;
            }
            Object[] mle = this.mixList.elementAt(rowIndex);
            return mle[columnIndex];
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            Object[] mle = this.mixList.elementAt(rowIndex);
            mle[columnIndex] = value;
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object[] getRow(int rowIndex) {
            return this.mixList.elementAt(rowIndex);
        }

        public void addRow(Object[] a_mix) {
            MixListTableModel m = (MixListTableModel)CascadePanel.this.m_availableMixTable.getModel();
            for (int j = 0; j < 2; ++j) {
                for (int i = 0; i < m.getRowCount(); ++i) {
                    if (m.getValueAt(i, 0) == null || !m.getValueAt(i, 0).equals(a_mix[0])) continue;
                    return;
                }
                m = (MixListTableModel)CascadePanel.this.m_configuredMixTable.getModel();
            }
            if (a_mix[3].toString().equalsIgnoreCase("FirstMix")) {
                this.mixList.insertElementAt(a_mix, 0);
                this.fireTableRowsInserted(0, 0);
            } else if (a_mix[3].toString().equalsIgnoreCase("LastMix")) {
                this.mixList.addElement(a_mix);
                this.fireTableRowsInserted(this.mixList.size() - 1, this.mixList.size() - 1);
            } else {
                String strMixType;
                int i;
                for (i = 0; i < this.mixList.size() && ((strMixType = this.mixList.elementAt(i)[3].toString()).equalsIgnoreCase(MixConfiguration.getMixTypeAsString(1)) || !strMixType.equalsIgnoreCase(MixConfiguration.getMixTypeAsString(2)) && !strMixType.equalsIgnoreCase(MixConfiguration.getMixTypeAsString(4))); ++i) {
                }
                this.mixList.insertElementAt(a_mix, i);
                this.fireTableRowsInserted(i, i);
            }
        }

        public void addRow(Element a_mix) {
            Object[] mix = new Object[this.getColumnCount()];
            mix[0] = a_mix.getAttribute("id");
            mix[1] = this.getElementData(a_mix, "Name");
            NodeList nl = a_mix.getElementsByTagName("Location");
            Element m = (Element)nl.item(0);
            mix[2] = this.getElementData(m, "City");
            mix[3] = this.getElementData(a_mix, "MixType");
            this.addRow(mix);
        }

        public void removeRow(Object a_mle) {
            int i = this.mixList.indexOf(a_mle);
            this.mixList.removeElement(a_mle);
            this.fireTableRowsDeleted(i, i);
        }

        public void removeRow(int rowIndex) {
            this.mixList.removeElementAt(rowIndex);
            this.fireTableRowsDeleted(rowIndex, rowIndex);
        }

        public void moveRow(int src, int dest) {
            Object[] o = this.mixList.elementAt(src);
            this.mixList.removeElementAt(src);
            this.mixList.insertElementAt(o, dest);
            CascadePanel.this.m_configuredMixTable.getSelectionModel().setSelectionInterval(dest, dest);
            if (src < dest) {
                this.fireTableChanged(new TableModelEvent(this, src, dest));
            } else {
                this.fireTableChanged(new TableModelEvent(this, dest, src));
            }
        }

        public Node toXmlElement(Document a_doc) {
            DocumentFragment e = a_doc.createDocumentFragment();
            Enumeration<Object[]> list = this.mixList.elements();
            while (list.hasMoreElements()) {
                Element g;
                Object[] mle = list.nextElement();
                String mixId = CascadePanel.this.getConfiguration().getValue("General/MixID");
                if (mle[0] == null || mle[0].equals(mixId)) continue;
                Element f = a_doc.createElement("Mix");
                e.appendChild(f);
                if (mle[0] != null) {
                    f.setAttribute("id", mle[0].toString());
                }
                if (mle[1] != null) {
                    g = a_doc.createElement("Name");
                    g.appendChild(a_doc.createTextNode(mle[1].toString()));
                    f.appendChild(g);
                }
                if (mle[2] != null) {
                    g = a_doc.createElement("Location");
                    f.appendChild(g);
                    Element h = a_doc.createElement("City");
                    g.appendChild(h);
                    h.appendChild(a_doc.createTextNode(mle[2].toString()));
                }
                if (mle[3] != null) {
                    g = a_doc.createElement("MixType");
                    f.appendChild(g);
                    g.appendChild(a_doc.createTextNode(mle[3].toString()));
                }
                if (mle[4] == null) continue;
                g = a_doc.createElement("MinCascadeLength");
                f.appendChild(g);
                g.appendChild(a_doc.createTextNode(mle[4].toString()));
            }
            return e;
        }

        private String getElementData(Element a_parent, String a_elementName) {
            NodeList nl = a_parent.getElementsByTagName(a_elementName);
            if (nl.getLength() == 0) {
                return null;
            }
            Node e = (Element)nl.item(0);
            for (e = e.getFirstChild(); e != null; e = e.getNextSibling()) {
                if (!(e instanceof Text)) continue;
                return ((Text)e).getData().trim();
            }
            return null;
        }
    }
}

