/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.network;

import mixconfig.network.ConnectionData;
import mixconfig.network.ConnectionTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ProxyTableModel
extends ConnectionTableModel {
    private static final String[] columnNames = new String[]{"No.", "Type", "Transport", "Host", "Port", "Visible Address"};

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    @Override
    public Object getValueAt(int row, int column) {
        ConnectionData data = this.getData(row);
        if (data == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                if (data.getType().equals("Proxy")) {
                    switch (data.getFlags() & 7) {
                        case 0: {
                            return "Proxy";
                        }
                        case 1: {
                            return "HTTP Proxy";
                        }
                        case 2: {
                            return "Socks Proxy";
                        }
                        case 4: {
                            return "VPN Proxy";
                        }
                    }
                } else {
                    return "Mix";
                }
            }
            case 2: {
                return new Integer(data.getTransport());
            }
            case 3: {
                return data.getHostname();
            }
            case 5: {
                return data.getVisibleAddress();
            }
            case 4: {
                return new Integer(data.getPort());
            }
        }
        return null;
    }

    public Element createProxiesAsElement(Document doc) {
        Element proxies = doc.createElement("Proxies");
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getData(i).getType().equals("Proxy")) continue;
            Element proxy = this.getData(i).toXmlElement(doc);
            proxies.appendChild(proxy);
        }
        if (proxies.hasChildNodes()) {
            return proxies;
        }
        return null;
    }

    public void readFromElement(Element element) {
        if (element.getTagName().equals("Proxies")) {
            for (int i = this.getRowCount() - 1; i >= 0; --i) {
                if (!this.getData(i).getType().equals("Proxy")) continue;
                this.deleteData(i);
            }
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                ConnectionData data;
                if (child.getNodeType() != 1 || (data = ConnectionData.createFromElement("Proxy", (Element)child)) == null) continue;
                this.addData(data);
            }
        }
    }
}

