/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.network;

import anon.util.JAPMessages;
import gui.JAPJIntField;
import gui.MixConfigTextField;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import mixconfig.network.ConnectionData;
import mixconfig.network.ConnectionTableModel;
import mixconfig.panels.MixOnCDPanel;

abstract class ConnectionDialog
extends JAPDialog {
    private MixConfigTextField m_tfHost;
    private JAPJIntField m_tfPort;
    private ButtonGroup ssl;
    private ButtonGroup m_bttngrpType;
    private JComboBox m_type;
    private JLabel namelabel;
    private JLabel iplabel;
    private JComponent m_firstone;
    private boolean m_bMixOnCD;
    protected final ActionListener nextfocusaction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent evt) {
            ((Component)evt.getSource()).transferFocus();
        }
    };

    protected abstract String getType();

    protected ConnectionData getData() {
        boolean bHidden = false;
        boolean bVirtual = false;
        if (this.m_type != null && this.m_type.getSelectedIndex() == 1) {
            bVirtual = true;
        }
        if (this.m_type != null && this.m_type.getSelectedIndex() == 2) {
            bHidden = true;
        }
        if (this.m_bttngrpType.getSelection().getActionCommand().equals("TCP")) {
            if (!this.m_bMixOnCD) {
                return new ConnectionData(this.getType(), this.ssl.getSelection().getActionCommand().equals("SSL") ? 2 : 0, this.m_tfHost.getText().trim(), this.m_tfPort.getText().length() == 0 ? 0 : Integer.parseInt(this.m_tfPort.getText()), 0, bVirtual, bHidden);
            }
            return new ConnectionData(this.getType(), this.ssl.getSelection().getActionCommand().equals("SSL") ? 2 : 0, JAPMessages.getString(MixOnCDPanel.MSG_CONFIGURED_BY_MIXONCD), this.m_tfPort.getText().length() == 0 ? 0 : Integer.parseInt(this.m_tfPort.getText()), 0, bVirtual, bHidden);
        }
        return new ConnectionData(this.getType(), this.ssl.getSelection().getActionCommand().equals("SSL") ? 3 : 1, this.m_tfHost.getText().trim());
    }

    protected void addTransport(ConnectionData data, GridBagLayout layout, GridBagConstraints lc, GridBagConstraints rc) {
        JLabel label = new JLabel("Transport");
        layout.setConstraints(label, lc);
        this.getContentPane().add(label);
        lc.gridy += 2;
        int ttype = data == null ? 0 : data.getTransport();
        rc.anchor = 10;
        rc.gridwidth = 3;
        this.m_bttngrpType = new ButtonGroup();
        JRadioButton t = new JRadioButton("TCP", (ttype & 1) == 0);
        if (this.m_firstone == null) {
            this.m_firstone = t;
        }
        t.setActionCommand("TCP");
        ActionListener tcpunixswitcher = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                boolean is_tcp = ev.getActionCommand().equals("TCP");
                ConnectionDialog.this.namelabel.setText(is_tcp ? "Host name" : "File name");
                ConnectionDialog.this.iplabel.setEnabled(is_tcp);
                ConnectionDialog.this.m_tfPort.setEnabled(is_tcp);
            }
        };
        t.addActionListener(tcpunixswitcher);
        layout.setConstraints(t, rc);
        this.getContentPane().add(t);
        this.m_bttngrpType.add(t);
        ++rc.gridy;
        t = new JRadioButton("Unix", (ttype & 1) != 0);
        t.setActionCommand("Unix");
        t.addActionListener(tcpunixswitcher);
        layout.setConstraints(t, rc);
        this.getContentPane().add(t);
        this.m_bttngrpType.add(t);
        --rc.gridy;
        rc.gridx += 3;
        rc.gridwidth = 1;
        rc.gridheight = 2;
        JSeparator vertLine = new JSeparator(1);
        rc.fill = 3;
        layout.setConstraints(vertLine, rc);
        rc.fill = 0;
        this.getContentPane().add(vertLine);
        ++rc.gridx;
        rc.gridwidth = 3;
        rc.gridheight = 1;
        this.ssl = new ButtonGroup();
        t = new JRadioButton("Raw", (ttype & 2) == 0);
        t.setActionCommand("Raw");
        layout.setConstraints(t, rc);
        this.getContentPane().add(t);
        this.ssl.add(t);
        ++rc.gridy;
        t = new JRadioButton("SSL", (ttype & 2) != 0);
        t.setActionCommand("SSL");
        t.setEnabled(false);
        layout.setConstraints(t, rc);
        this.getContentPane().add(t);
        this.ssl.add(t);
        ++rc.gridy;
        rc.gridx -= 4;
    }

    protected void addName(ConnectionData data, GridBagLayout layout, GridBagConstraints lc, GridBagConstraints rc, boolean a_enabled) {
        boolean isHost = this.m_bttngrpType.getSelection().getActionCommand().equals("TCP");
        this.namelabel = new JLabel(isHost ? "Hostname" : "Filename");
        layout.setConstraints(this.namelabel, lc);
        this.getContentPane().add(this.namelabel);
        ++lc.gridy;
        rc.anchor = 17;
        rc.gridwidth = 7;
        this.m_tfHost = data == null ? new MixConfigTextField(14) : new MixConfigTextField(String.valueOf(data.getHostname()), 14);
        this.m_tfHost.setMinimumSize(this.m_tfHost.getPreferredSize());
        layout.setConstraints(this.m_tfHost, rc);
        this.getContentPane().add(this.m_tfHost);
        this.m_tfHost.addActionListener(this.nextfocusaction);
        ++rc.gridy;
        if (this.m_firstone == null) {
            this.m_firstone = this.m_tfHost;
        }
        this.m_tfHost.setEnabled(a_enabled);
        this.namelabel.setEnabled(a_enabled);
    }

    protected void addPort(ConnectionData data, GridBagLayout layout, GridBagConstraints lc, GridBagConstraints rc) {
        boolean isHost = this.m_bttngrpType.getSelection().getActionCommand().equals("TCP");
        this.iplabel = new JLabel("Port");
        layout.setConstraints(this.iplabel, lc);
        this.getContentPane().add(this.iplabel);
        this.iplabel.setEnabled(isHost);
        ++lc.gridy;
        rc.gridwidth = 7;
        this.m_tfPort = new JAPJIntField(65535, true);
        this.m_tfPort.setMinimumSize(this.m_tfPort.getPreferredSize());
        if (isHost && data != null) {
            this.m_tfPort.setInt(data.getPort());
        }
        if (isHost && data == null) {
            if (this.getType().equals("Proxy")) {
                this.m_tfPort.setInt(3128);
            } else {
                this.m_tfPort.setInt(6544);
            }
        }
        layout.setConstraints(this.m_tfPort, rc);
        this.getContentPane().add(this.m_tfPort);
        this.m_tfPort.addActionListener(this.nextfocusaction);
        this.m_tfPort.setEnabled(isHost);
        ++rc.gridy;
        if (this.m_firstone == null) {
            this.m_firstone = this.m_tfPort;
        }
    }

    protected void addOptions(ConnectionData data, GridBagLayout layout, GridBagConstraints lc, GridBagConstraints rc, boolean a_enabled) {
        JPanel p = new JPanel(new GridLayout(1, 2));
        p.setToolTipText("These are two additional options which are useful if you are behind a NAT gateway for instance.");
        p.setBorder(new TitledBorder("Visibility"));
        lc.gridwidth = 8;
        lc.gridx = 0;
        lc.anchor = 12;
        lc.fill = 2;
        lc.weightx = 1.0;
        layout.setConstraints(p, lc);
        this.getContentPane().add(p);
        ++lc.gridy;
        ++rc.gridy;
        Vector<String> items = new Vector<String>();
        JLabel virtual = new JLabel("Virtual");
        virtual.setToolTipText("Virtual - the Mix will not bind or listen on this interface, but the information is transferred to the InfoService");
        items.addElement("Default");
        items.addElement("Virtual");
        items.addElement("Hidden");
        this.m_type = new JComboBox(items);
        this.m_type.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ConnectionDialog.this.m_type.getSelectedIndex() == 0) {
                    ConnectionDialog.this.m_type.setToolTipText("");
                } else if (ConnectionDialog.this.m_type.getSelectedIndex() == 1) {
                    ConnectionDialog.this.m_type.setToolTipText("Virtual - the Mix will not bind or listen on this interface, but the information is transferred to the InfoService");
                } else if (ConnectionDialog.this.m_type.getSelectedIndex() == 2) {
                    ConnectionDialog.this.m_type.setToolTipText("Hidden - information about this interface is not propagated to the InfoService.");
                }
            }
        });
        if (data != null) {
            if (data.isVirtual()) {
                this.m_type.setSelectedIndex(1);
            } else if (data.isHidden()) {
                this.m_type.setSelectedIndex(2);
            } else {
                this.m_type.setSelectedIndex(0);
            }
        }
        this.m_type.setEnabled(a_enabled);
        p.add(this.m_type);
    }

    protected void addKeys(final ConnectionData data, final ConnectionTableModel where, GridBagLayout layout, GridBagConstraints lc, GridBagConstraints rc) {
        JButton key;
        GridBagLayout keylayout = new GridBagLayout();
        JPanel keys = new JPanel(keylayout);
        GridBagConstraints kc = new GridBagConstraints();
        kc.weightx = 1.0;
        kc.gridx = 0;
        kc.gridy = 0;
        kc.gridwidth = 1;
        kc.fill = 2;
        kc.insets = new Insets(1, 1, 1, 1);
        if (data == null) {
            key = new JButton("Add");
            key.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    where.addData(ConnectionDialog.this.getData());
                    ConnectionDialog.this.dispose();
                }
            });
        } else {
            key = new JButton("Apply");
            key.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    where.changeData(ConnectionDialog.this.getData(), data);
                    ConnectionDialog.this.dispose();
                }
            });
        }
        key.setActionCommand("Ok");
        keylayout.setConstraints(key, kc);
        keys.add(key);
        ++kc.gridx;
        key = new JButton("Cancel");
        key.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ConnectionDialog.this.dispose();
            }
        });
        keylayout.setConstraints(key, kc);
        keys.add(key);
        if (this.m_firstone == null) {
            this.m_firstone = key;
        }
        lc.gridwidth = 8;
        lc.fill = 2;
        layout.setConstraints(keys, lc);
        this.getContentPane().add(keys);
        ++lc.gridy;
        ++rc.gridy;
    }

    ConnectionDialog(Frame parent, String title) {
        super(parent, title, true);
        this.setResizable(false);
    }

    protected void setMixOnCDEnabled(boolean a_bEnabled) {
        this.m_bMixOnCD = a_bEnabled;
    }

    protected JComponent getFirstone() {
        return this.m_firstone;
    }

    protected void setFirstone(JComponent a_firstone) {
        this.m_firstone = a_firstone;
    }
}

