/*
 * Decompiled with CFR 0.152.
 */
package mixconfig;

import anon.crypto.PKCS12;
import anon.crypto.X509DistinguishedName;
import anon.crypto.X509SubjectKeyIdentifier;
import anon.infoservice.Database;
import anon.infoservice.IDistributable;
import anon.infoservice.IDistributor;
import anon.infoservice.IMutableProxyInterface;
import anon.infoservice.InfoServiceDBEntry;
import anon.util.ClassUtil;
import anon.util.JAPMessages;
import anon.util.ResourceLoader;
import anon.util.XMLUtil;
import gui.ClipFrame;
import gui.GUIUtils;
import gui.dialog.JAPDialog;
import gui.help.JAPHelp;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.security.SecureRandom;
import javax.swing.Icon;
import javax.swing.JApplet;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import logging.LogHolder;
import logging.LogLevel;
import logging.LogType;
import logging.SystemErrLog;
import mixconfig.ChoicePanel;
import mixconfig.ConfigFrame;
import mixconfig.MixConfiguration;
import mixconfig.SimpleFileFilter;
import mixconfig.network.ProxyAdapter;
import mixconfig.tools.CertificateGenerator;
import org.w3c.dom.Document;

public class MixConfig
extends JApplet {
    public static final int SAVE_DIALOG = 1;
    public static final int OPEN_DIALOG = 2;
    public static final int CHOOSE_DIR_DIALOG = 3;
    public static final int OPEN_MULTIPLE_DIALOG = 4;
    public static final int FILTER_ALL = 0;
    public static final int FILTER_CER = 1;
    public static final int FILTER_XML = 2;
    public static final int FILTER_PFX = 4;
    public static final int FILTER_B64_PFX = 8;
    public static final int FILTER_B64_CER = 16;
    public static final int FILTER_P10 = 32;
    public static final int FILTER_B64_P10 = 64;
    public static final String VERSION = "00.05.045";
    private static final String IMG_MAIN;
    private static final String MSG_COULD_NOT_INITIALISE;
    private static final String MSG_CONFIG_FILE_NOT_FOUND;
    private static final String MSG_ERROR_OPEN_FILE;
    private static MixConfiguration m_mixConfiguration;
    protected static JPanel m_mainPanel;
    private static ChoicePanel m_startPanel;
    private static Frame m_MainWindow;
    private static File m_fileCurrentDir;
    private static String m_currentFileName;
    private static Proxy proxy;

    /*
     * Unable to fully structure code
     */
    public static void main(String[] argv) {
        f = null;
        startTime = System.currentTimeMillis();
        if (!JAPMessages.init("MixConfigMessages")) {
            GUIUtils.exitWithNoMessagesError("MixConfigMessages");
        }
lbl5:
        // 5 sources

        try {
            for (i = 0; i < argv.length; ++i) {
                block19: {
                    if (argv[i].equals("--help")) {
                        MixConfig.usage();
                        System.exit(0);
                        continue;
                    }
                    if (argv[i].equals("--createConf")) {
                        MixConfig.createMixOnCDConfiguration();
                        System.exit(0);
                        continue;
                    }
                    if (argv[i].equals("--logdetail")) {
                        try {
                            LogHolder.setDetailLevel(Integer.parseInt(argv[++i]));
                        }
                        catch (Exception a_e) {
                            MixConfig.usage();
                            System.exit(1);
                        }
                        continue;
                    }
                    if (!argv[i].equals("--loglevel")) break block19;
                    try {
                        ++i;
                        for (j = 0; j < LogLevel.getLevelCount(); ++j) {
                            if (!argv[i].trim().equalsIgnoreCase(LogLevel.getLevelName(j).trim())) continue;
                            LogHolder.setLogInstance(new SystemErrLog(j, LogType.ALL));
                            break;
                        }
                        if (j < LogLevel.getLevelCount()) ** GOTO lbl5
                        throw new Exception();
                    }
                    catch (Exception a_e) {
                        a_e.printStackTrace();
                        MixConfig.usage();
                        System.exit(1);
                    }
                    continue;
                }
                MixConfig.setCurrentFilename(argv[i]);
            }
            httpProxyHost = System.getProperty("http.proxyHost");
            httpProxyPort = System.getProperty("http.proxyPort");
            if (httpProxyHost != null && httpProxyPort != null) {
                MixConfig.configureProxy(httpProxyHost, httpProxyPort);
            }
            MixConfig.m_MainWindow = new JFrame();
            Database.registerDistributor(new IDistributor(){

                @Override
                public void addJob(IDistributable a_newJob) {
                }
            });
            ((JFrame)MixConfig.m_MainWindow).setDefaultCloseOperation(0);
            MixConfig.m_MainWindow.setResizable(false);
            JAPHelp.init(MixConfig.m_MainWindow, null);
            fileLoaded = false;
            if (MixConfig.m_currentFileName != null && (f = new File(MixConfig.m_currentFileName)).exists()) {
                LogHolder.log(7, LogType.MISC, "Load a configuration file...");
                reader = new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8");
                MixConfig.m_mixConfiguration = new MixConfiguration(reader);
                fileLoaded = true;
            } else {
                if (MixConfig.m_currentFileName != null) {
                    JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), JAPMessages.getString(MixConfig.MSG_CONFIG_FILE_NOT_FOUND, new File(MixConfig.m_currentFileName).toString()));
                }
                MixConfig.m_mixConfiguration = new MixConfiguration();
            }
            if (fileLoaded) {
                MixConfig.m_startPanel = new ChoicePanel((JFrame)MixConfig.m_MainWindow, null, "card_mainPanel_expert");
                MixConfig.m_startPanel.setExpertVisible();
            } else {
                MixConfig.m_startPanel = new ChoicePanel((JFrame)MixConfig.m_MainWindow, null, "card_choicePanel");
            }
            ((JFrame)MixConfig.m_MainWindow).setContentPane(MixConfig.m_startPanel);
            MixConfig.m_MainWindow.pack();
            GUIUtils.centerOnScreen(MixConfig.m_MainWindow);
            LogHolder.log(7, LogType.GUI, "Show the GUI's main window");
            MixConfig.m_MainWindow.setVisible(true);
            icon = GUIUtils.loadImageIcon(MixConfig.IMG_MAIN);
            if (icon != null) {
                MixConfig.m_MainWindow.setIconImage(icon.getImage());
            }
            MixConfig.m_MainWindow.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    this.windowClosing(e);
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    m_startPanel.getMenu().exit();
                }
            });
            MixConfig.m_startPanel.setMessageTitle();
            MixConfig.m_mixConfiguration.setSavedToFile();
            LogHolder.log(6, LogType.MISC, "Startup time: " + (System.currentTimeMillis() - startTime) + " ms");
            LogHolder.log(6, LogType.CRYPTO, "Initialising secure random generator ..");
            new SecureRandom().nextDouble();
            LogHolder.log(6, LogType.CRYPTO, "Secure random generator is initialised!");
        }
        catch (Exception e) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), JAPMessages.getString(MixConfig.MSG_COULD_NOT_INITIALISE), (Throwable)e);
            System.exit(1);
        }
    }

    public static void usage() {
        String logLevels = "";
        for (int i = 0; i < LogLevel.getLevelCount(); ++i) {
            logLevels = logLevels + LogLevel.getLevelName(i).trim() + ",";
        }
        if (logLevels.length() > 0) {
            logLevels = logLevels.substring(0, logLevels.length() - 1);
        }
        String[] message = new String[]{"Usage: java -cp <classpath> mixconfig.MixConfig [options] [configfilename]", "where options is one of", "--help       Show this message and exit.", "--logDetail  Sets the detail level of log messages. (lowest is 0, highest is 3)", "--logLevel   Sets the level of the log messages. (" + logLevels + ")", "--createConf Creates a generic configuration for MixOnCD."};
        for (int i = 0; i < message.length; ++i) {
            System.out.println(message[i]);
        }
    }

    @Override
    public void init() {
        try {
            if (!JAPMessages.init("MixConfigMessages")) {
                GUIUtils.exitWithNoMessagesError("MixConfigMessages");
            }
            Database.registerDistributor(new IDistributor(){

                @Override
                public void addJob(IDistributable a_newJob) {
                }
            });
            m_MainWindow = (Frame)GUIUtils.getParentWindow(this);
            m_mixConfiguration = new MixConfiguration();
            JAPHelp.init(m_MainWindow, null);
            m_mainPanel = new ConfigFrame(null);
            m_startPanel = new ChoicePanel(null, this.getRootPane());
            this.setContentPane(m_startPanel);
        }
        catch (Exception e) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), JAPMessages.getString(MSG_COULD_NOT_INITIALISE), (Throwable)e);
            System.exit(1);
        }
    }

    public static MixConfiguration getMixConfiguration() {
        return m_mixConfiguration;
    }

    public static void setMixConfiguration(MixConfiguration a_mixConfiguration) {
        m_mixConfiguration = a_mixConfiguration;
    }

    public static void setCurrentFilename(String filename) {
        m_currentFileName = filename;
    }

    public static String getCurrentFileName() {
        return m_currentFileName;
    }

    public static void configureProxy(String host, String port) {
        try {
            InetSocketAddress proxyAddress = new InetSocketAddress(host, Integer.parseInt(port));
            MixConfig.configureProxy(new Proxy(Proxy.Type.HTTP, proxyAddress));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Bad proxy port: " + port + ". Port must be a number between 0 and 65535");
        }
    }

    public static void configureProxy(Proxy proxy) {
        if (proxy.type().equals((Object)Proxy.Type.DIRECT)) {
            MixConfig.proxy = null;
            System.clearProperty("http.proxyHost");
            System.clearProperty("http.proxyPort");
            InfoServiceDBEntry.setMutableProxyInterface(new IMutableProxyInterface.DummyMutableProxyInterface());
        } else {
            MixConfig.proxy = proxy;
            System.setProperty("http.proxyHost", ((InetSocketAddress)proxy.address()).getHostName());
            System.setProperty("http.proxyPort", "" + ((InetSocketAddress)proxy.address()).getPort());
            InfoServiceDBEntry.setMutableProxyInterface(new ProxyAdapter(proxy));
        }
    }

    public static Proxy getProxy() {
        return proxy;
    }

    public static void info(String a_title, String[] a_message) {
        MixConfig.info(a_title, a_message, false);
    }

    public static void info(String a_title, String[] a_message, boolean a_bBlocking) {
        String message = "";
        if (a_message == null || a_message.length == 0) {
            JAPDialog.showMessageDialog((Component)MixConfig.getMainWindow(), "", a_title);
        } else if (a_message.length == 1) {
            JAPDialog.showMessageDialog((Component)MixConfig.getMainWindow(), a_message[0], a_title);
        } else {
            message = message + "<UL>";
            for (int i = 0; i < a_message.length && i < 20; ++i) {
                if (a_message[i] == null || a_message[i].trim().length() == 0) continue;
                message = message + "<LI>" + a_message[i] + "</LI>";
            }
            message = message + "</UL>";
            if (a_bBlocking) {
                JAPDialog.showMessageDialog((Component)MixConfig.getMainWindow(), message, a_title);
            } else {
                JAPDialog.showMessageDialog((Component)MixConfig.getMainWindow(), message, a_title, (JAPDialog.ILinkedInformation)new JAPDialog.LinkedInformationAdapter(){

                    @Override
                    public boolean isModal() {
                        return false;
                    }
                });
            }
        }
    }

    public static void about() {
        JAPDialog.showMessageDialog((Component)MixConfig.getMainWindow(), "Mix Configuration Tool<P>Version: 00.05.045</P>", "About", (Icon)GUIUtils.loadImageIcon(IMG_MAIN));
    }

    public static Frame getMainWindow() {
        return m_MainWindow;
    }

    public static JFileChooser showFileDialog(Component a_component, int type, int filter_type) {
        JFileChooser fd2;
        SimpleFileFilter active = null;
        try {
            fd2 = new JFileChooser(m_fileCurrentDir);
        }
        catch (SecurityException a_e) {
            JAPDialog.showErrorDialog(a_component, "Access to file system is not allowed when running as applet!");
            return null;
        }
        if (type == 3) {
            fd2.setFileSelectionMode(1);
        } else if (type == 4) {
            fd2.setFileSelectionMode(0);
            fd2.setMultiSelectionEnabled(true);
        } else {
            fd2.setFileSelectionMode(0);
        }
        if ((filter_type & 1) != 0) {
            active = new SimpleFileFilter(1);
            fd2.addChoosableFileFilter(active);
        }
        if ((filter_type & 0x10) != 0) {
            active = new SimpleFileFilter(16);
            fd2.addChoosableFileFilter(active);
        }
        if ((filter_type & 2) != 0) {
            active = new SimpleFileFilter(2);
            fd2.addChoosableFileFilter(active);
        }
        if ((filter_type & 0x20) != 0) {
            fd2.addChoosableFileFilter(new SimpleFileFilter(32));
        }
        if ((filter_type & 0x40) != 0) {
            fd2.addChoosableFileFilter(new SimpleFileFilter(64));
        }
        if ((filter_type & 4) != 0) {
            fd2.addChoosableFileFilter(new SimpleFileFilter(4));
        }
        if ((filter_type & 8) != 0) {
            fd2.addChoosableFileFilter(new SimpleFileFilter(8));
        }
        if (active != null) {
            fd2.setFileFilter(active);
        }
        fd2.setFileHidingEnabled(false);
        int returnValue = type == 1 ? fd2.showSaveDialog(a_component) : GUIUtils.showMonitoredFileChooser(fd2, a_component, "__FILE_CHOOSER_OPEN");
        if (returnValue == 1) {
            return null;
        }
        m_fileCurrentDir = fd2.getCurrentDirectory();
        if (type == 3) {
            m_fileCurrentDir = fd2.getSelectedFile();
        }
        return fd2;
    }

    public static byte[] openFile(Component a_component, int type) {
        try {
            JFileChooser fileChooser = MixConfig.showFileDialog(a_component, 2, type);
            if (fileChooser == null) {
                return null;
            }
            File file = fileChooser.getSelectedFile();
            if (file != null) {
                try {
                    return ResourceLoader.getStreamAsBytes(new FileInputStream(file));
                }
                catch (IOException e) {
                    JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), JAPMessages.getString(MSG_ERROR_OPEN_FILE, file.toString()), (Throwable)e);
                }
            }
        }
        catch (SecurityException a_e) {
            ClipFrame open = new ClipFrame(a_component, "Paste the data to be imported in the area provided.", true);
            open.setVisible(true);
            return open.getText().getBytes();
        }
        return null;
    }

    private static void createMixOnCDConfiguration() throws Exception {
        MixConfiguration configuration = new MixConfiguration();
        X509DistinguishedName dn = new X509DistinguishedName("CN=");
        CertificateGenerator certificateGenerator = new CertificateGenerator(dn, null, true);
        certificateGenerator.run();
        PKCS12 privateCert = certificateGenerator.getCertificate();
        configuration.setValue("Certificates/OwnCertificate/X509PKCS12", privateCert.toByteArray());
        configuration.setValue("Certificates/OwnCertificate/X509Certificate", privateCert.getX509Certificate().toByteArray());
        configuration.setValue("Network/ListenerInterfaces/ListenerInterface/Port", 6544);
        configuration.setValue("Network/ListenerInterfaces/ListenerInterface/NetworkProtocol", "RAW/TCP");
        configuration.setValue("General/CascadeName", "Dynamic Cascade");
        configuration.setValue("General/MixName", "Dynamic Mix");
        configuration.setValue("General/MixID", ((X509SubjectKeyIdentifier)privateCert.getExtensions().getExtension(X509SubjectKeyIdentifier.IDENTIFIER)).getValueWithoutColon());
        configuration.setValue("General/UserID", "mix");
        configuration.setValue("General/Logging/SysLog", true);
        configuration.setValue("Network/InfoService/AllowAutoConfiguration", true);
        Document document = configuration.getDocument();
        XMLUtil.formatHumanReadable(document);
        System.out.println(XMLUtil.toString(document));
    }

    static {
        LogHolder.setLogInstance(new SystemErrLog(6, LogType.ALL));
        IMG_MAIN = MixConfig.class.getName() + "_icon.gif";
        MSG_COULD_NOT_INITIALISE = MixConfig.class.getName() + "_couldNotInitialise";
        MSG_CONFIG_FILE_NOT_FOUND = MixConfig.class.getName() + "_configFileNotFound";
        MSG_ERROR_OPEN_FILE = MixConfig.class.getName() + "_errorOpenFile";
        m_fileCurrentDir = new File(ClassUtil.getUserDir());
        proxy = null;
    }
}

