/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import anon.util.XMLParseException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Vector;

public class XMLDuration {
    public static final int DURATION = 0;
    public static final int DURATION_DAYTIME = 1;
    public static final int DURATION_YEARMONTH = 2;
    public static final int LESSER = -1;
    public static final int EQUAL = 0;
    public static final int GREATER = 1;
    public static final int INDETERMINATE = 2;
    private static final int YEARS = 1;
    private static final int MONTHS = 2;
    private static final int DAYS = 3;
    private static final int HOURS = 4;
    private static final int MINUTES = 5;
    private static final int SECONDS = 6;
    private static final String[] NAMES = new String[]{"years", "months", "days", "hours", "minutes", "seconds"};
    private long m_years;
    private long m_months;
    private long m_days;
    private long m_hours;
    private long m_minutes;
    private double m_seconds;
    private boolean m_bNegativeSign;
    private String m_theDuration;
    private Vector m_setFields;
    private long m_calcYears;
    private long m_calcMonths;
    private long m_calcDays;
    private long m_calcHours;
    private long m_calcMinutes;
    private double m_calcSeconds;
    private int m_hashCode;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public XMLDuration() {
        this.m_years = 0L;
        this.m_months = 0L;
        this.m_days = 0L;
        this.m_hours = 0L;
        this.m_minutes = 0L;
        this.m_seconds = 0.0;
        this.m_bNegativeSign = false;
        this.m_theDuration = "P0Y";
        this.m_setFields = new Vector();
        this.m_setFields.addElement(new Integer(1));
        this.init();
    }

    public XMLDuration(XMLDuration a_duration) {
        if (a_duration == null) {
            throw new NullPointerException();
        }
        this.m_years = a_duration.m_years;
        this.m_months = a_duration.m_months;
        this.m_days = a_duration.m_days;
        this.m_hours = a_duration.m_hours;
        this.m_minutes = a_duration.m_minutes;
        this.m_seconds = a_duration.m_seconds;
        this.m_bNegativeSign = a_duration.m_bNegativeSign;
        this.m_theDuration = a_duration.m_theDuration;
        this.m_setFields = a_duration.m_setFields;
        this.init();
    }

    public XMLDuration(String a_duration) throws XMLParseException {
        if (a_duration == null) {
            throw new XMLParseException("##__null__##");
        }
        this.m_theDuration = a_duration;
        if (a_duration.length() == 0) {
            return;
        }
        if ((a_duration = a_duration.trim()).length() < 3) {
            throw new XMLParseException("Duration string is too short to parse: " + this.m_theDuration);
        }
        if (a_duration.startsWith("-")) {
            this.m_bNegativeSign = true;
            a_duration = a_duration.substring(1, a_duration.length());
        }
        if (!a_duration.startsWith("P")) {
            throw new XMLParseException("Duration string has invalid format: " + this.m_theDuration);
        }
        this.m_setFields = new Vector();
        String strDuration = a_duration = a_duration.substring(1, a_duration.length());
        a_duration = this.parseXMLSchemaPart(1, a_duration);
        a_duration = this.parseXMLSchemaPart(2, a_duration);
        if ((a_duration = this.parseXMLSchemaPart(3, a_duration)).startsWith("T")) {
            strDuration = a_duration = a_duration.substring(1, a_duration.length());
            a_duration = this.parseXMLSchemaPart(4, a_duration);
            a_duration = this.parseXMLSchemaPart(5, a_duration);
            a_duration = this.parseXMLSchemaPart(6, a_duration);
        } else if (a_duration.length() > 0) {
            throw new XMLParseException("Duration string has invalid format (T): " + this.m_theDuration);
        }
        if (a_duration.equals(strDuration)) {
            throw new XMLParseException("Duration string has invalid format: " + this.m_theDuration);
        }
        this.init();
    }

    private void setField(int a_field, Number a_value) {
        if (a_field == 1) {
            this.m_years = a_value.intValue();
        } else if (a_field == 2) {
            this.m_months = a_value.intValue();
        } else if (a_field == 3) {
            this.m_days = a_value.intValue();
        } else if (a_field == 4) {
            this.m_hours = a_value.intValue();
        } else if (a_field == 5) {
            this.m_minutes = a_value.intValue();
        } else if (a_field == 6) {
            this.m_seconds = a_value.doubleValue();
        }
    }

    private String parseXMLSchemaPart(int a_field, String a_strXMLDurationPart) throws XMLParseException {
        String schemaChar = "";
        if (a_field == 1) {
            schemaChar = "Y";
        } else if (a_field == 2) {
            schemaChar = "M";
        } else if (a_field == 3) {
            schemaChar = "D";
        } else if (a_field == 4) {
            schemaChar = "H";
        } else if (a_field == 5) {
            schemaChar = "M";
        } else if (a_field == 6) {
            schemaChar = "S";
        }
        int index = a_strXMLDurationPart.indexOf(schemaChar);
        if (index > 0) {
            String strValueToParse = a_strXMLDurationPart.substring(0, index);
            if (a_field == 2 && strValueToParse.indexOf("T") >= 0) {
                return a_strXMLDurationPart;
            }
            this.m_setFields.addElement(new Integer(a_field));
            try {
                if (a_field == 6) {
                    this.setField(a_field, Double.valueOf(strValueToParse));
                } else {
                    this.setField(a_field, Integer.valueOf(strValueToParse));
                }
                a_strXMLDurationPart = a_strXMLDurationPart.length() > index ? a_strXMLDurationPart.substring(index + 1, a_strXMLDurationPart.length()) : "";
            }
            catch (NumberFormatException a_e) {
                throw new XMLParseException("Duration string has invalid format (" + schemaChar + ", " + "NumberFormatException: " + a_e.getMessage() + "): " + this.m_theDuration);
            }
        }
        return a_strXMLDurationPart;
    }

    public String getXMLSchema() {
        return this.m_theDuration;
    }

    public int getXMLSchemaType() throws IllegalStateException {
        boolean yearSet = this.isSet(1);
        boolean monthSet = this.isSet(2);
        boolean daySet = this.isSet(3);
        boolean hourSet = this.isSet(4);
        boolean minuteSet = this.isSet(5);
        boolean secondSet = this.isSet(6);
        if (yearSet && monthSet && daySet && hourSet && minuteSet && secondSet) {
            return 0;
        }
        if (!yearSet && !monthSet && daySet && hourSet && minuteSet && secondSet) {
            return 1;
        }
        if (yearSet && monthSet && !daySet && !hourSet && !minuteSet && !secondSet) {
            return 2;
        }
        throw new IllegalStateException("This Duration does not match one of the XML Schema date/time datatypes: year set = " + yearSet + " month set = " + monthSet + " day set = " + daySet + " hour set = " + hourSet + " minute set = " + minuteSet + " second set = " + secondSet);
    }

    public int getSign() {
        if (this.m_bNegativeSign) {
            return -1;
        }
        return 1;
    }

    public long getYears() {
        return this.m_years;
    }

    public long getMonths() {
        return this.m_months;
    }

    public long getDays() {
        return this.m_days;
    }

    public long getHours() {
        return this.m_hours;
    }

    public long getMinutes() {
        return this.m_minutes;
    }

    public double getSeconds() {
        return this.m_seconds;
    }

    public static String getFieldName(Object a_field) {
        if (a_field == null || !(a_field instanceof Integer)) {
            return null;
        }
        return XMLDuration.getFieldName((Integer)a_field);
    }

    public static String getFieldName(int a_field) {
        if (a_field < 1 || a_field > 6) {
            return null;
        }
        return NAMES[a_field - 1];
    }

    public Enumeration getFields() {
        return this.m_setFields.elements();
    }

    public Number getField(Object a_field) {
        if (a_field == null || !(a_field instanceof Integer)) {
            return null;
        }
        return this.getField((Integer)a_field);
    }

    public Number getField(int a_field) {
        if (a_field == 1) {
            return BigInteger.valueOf(this.m_years);
        }
        if (a_field == 2) {
            return BigInteger.valueOf(this.m_months);
        }
        if (a_field == 3) {
            return BigInteger.valueOf(this.m_days);
        }
        if (a_field == 4) {
            return BigInteger.valueOf(this.m_hours);
        }
        if (a_field == 5) {
            return BigInteger.valueOf(this.m_minutes);
        }
        if (a_field == 6) {
            return new BigDecimal(this.m_seconds);
        }
        return null;
    }

    public boolean isSet(int a_field) {
        return this.m_setFields.contains(new Integer(a_field));
    }

    public XMLDuration negate() {
        XMLDuration duration = new XMLDuration(this);
        duration.m_bNegativeSign = !this.m_bNegativeSign;
        return duration;
    }

    public int compare(XMLDuration a_duration) {
        if (this.m_calcYears > a_duration.m_calcYears) {
            return 1;
        }
        if (this.m_calcYears < a_duration.m_calcYears) {
            return -1;
        }
        if (this.m_calcMonths > a_duration.m_calcMonths) {
            return 1;
        }
        if (this.m_calcMonths < a_duration.m_calcMonths) {
            return -1;
        }
        if (this.m_calcDays > a_duration.m_calcDays) {
            return 1;
        }
        if (this.m_calcDays < a_duration.m_calcDays) {
            return -1;
        }
        if (this.m_calcHours > a_duration.m_calcHours) {
            return 1;
        }
        if (this.m_calcHours < a_duration.m_calcHours) {
            return -1;
        }
        if (this.m_calcMinutes > a_duration.m_calcMinutes) {
            return 1;
        }
        if (this.m_calcMinutes < a_duration.m_calcMinutes) {
            return -1;
        }
        if (this.m_calcSeconds > a_duration.m_calcSeconds) {
            return 1;
        }
        if (this.m_calcSeconds < a_duration.m_calcSeconds) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object a_duration) {
        if (a_duration == null || !(a_duration instanceof XMLDuration)) {
            return false;
        }
        return this.compare((XMLDuration)a_duration) == 0;
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public boolean isLongerThan(XMLDuration a_duration) {
        return this.compare(a_duration) == 1;
    }

    public boolean isShorterThan(XMLDuration a_duration) {
        return this.compare(a_duration) == -1;
    }

    public int getLastFieldSet() {
        if (this.isSet(6)) {
            return 6;
        }
        if (this.isSet(5)) {
            return 5;
        }
        if (this.isSet(4)) {
            return 4;
        }
        if (this.isSet(3)) {
            return 3;
        }
        if (this.isSet(2)) {
            return 2;
        }
        return 1;
    }

    public String toString() {
        BigInteger days;
        BigInteger months;
        StringBuffer buf = new StringBuffer();
        if (this.getSign() < 0) {
            buf.append('-');
        }
        buf.append('P');
        BigInteger years = (BigInteger)this.getField(1);
        if (years != null) {
            buf.append(years + "Y");
        }
        if ((months = (BigInteger)this.getField(2)) != null) {
            buf.append(months + "M");
        }
        if ((days = (BigInteger)this.getField(3)) != null) {
            buf.append(days + "D");
        }
        BigInteger hours = (BigInteger)this.getField(4);
        BigInteger minutes = (BigInteger)this.getField(5);
        BigDecimal seconds = (BigDecimal)this.getField(6);
        if (hours != null || minutes != null || seconds != null) {
            buf.append('T');
            if (hours != null) {
                buf.append(hours + "H");
            }
            if (minutes != null) {
                buf.append(minutes + "M");
            }
            if (seconds != null) {
                buf.append(this.toString(seconds) + "S");
            }
        }
        return buf.toString();
    }

    private String toString(BigDecimal bd) {
        String result = this.toStringJDK5(bd);
        if (result == null) {
            result = bd.toString();
        }
        return result;
    }

    private String toStringJDK5(BigDecimal bd) {
        StringBuffer buf;
        BigInteger unscaledValue;
        try {
            unscaledValue = (BigInteger)(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = XMLDuration.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getMethod("unscaledValue", null).invoke((Object)bd, (Object[])null);
        }
        catch (Exception e) {
            return null;
        }
        String intString = unscaledValue.toString();
        int scale = bd.scale();
        if (scale == 0) {
            return intString;
        }
        int insertionPoint = intString.length() - scale;
        if (insertionPoint == 0) {
            return "0." + intString;
        }
        if (insertionPoint > 0) {
            buf = new StringBuffer(intString);
            buf.insert(insertionPoint, '.');
        } else {
            buf = new StringBuffer(3 - insertionPoint + intString.length());
            buf.append("0.");
            for (int i = 0; i < -insertionPoint; ++i) {
                buf.append('0');
            }
            buf.append(intString);
        }
        return buf.toString();
    }

    private void init() {
        this.m_calcSeconds = this.m_seconds;
        this.m_calcMinutes = this.m_minutes;
        this.m_calcHours = this.m_hours;
        this.m_calcDays = this.m_days;
        this.m_calcMonths = this.m_months;
        this.m_calcYears = this.m_years;
        this.m_calcMinutes += (long)((int)this.m_calcSeconds / 60);
        this.m_calcSeconds -= (double)((int)this.m_calcSeconds / 60 * 60);
        this.m_calcHours += this.m_calcMinutes / 60L;
        this.m_calcMinutes %= 60L;
        this.m_calcDays += this.m_calcHours / 24L;
        this.m_calcHours %= 24L;
        this.m_calcYears += this.m_calcDays / 365L;
        this.m_calcDays %= 365L;
        this.m_calcMonths += 5L * (this.m_calcDays / 150L);
        this.m_calcDays %= 150L;
        this.m_calcMonths += this.m_calcDays / 28L;
        this.m_calcDays %= 28L;
        this.m_calcYears += this.m_calcMonths / 12L;
        this.m_calcMonths %= 12L;
        this.m_hashCode = (int)((long)this.m_calcSeconds + this.m_calcMinutes + this.m_calcHours + this.m_calcDays + this.m_calcMonths + this.m_calcYears) * this.getSign();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

