/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import anon.util.AbstractISOCodeMapper;
import anon.util.JAPMessages;
import anon.util.Util;
import java.util.Locale;
import java.util.Vector;

public class LanguageMapper
extends AbstractISOCodeMapper {
    private static final String[] ms_languageCodes = new String[]{"AA", "AB", "AF", "AM", "AR", "AS", "AY", "AZ", "BA", "BE", "BG", "BH", "BI", "BN", "BO", "BR", "CA", "CO", "CS", "CY", "DA", "DE", "DZ", "EL", "EN", "EO", "ES", "ET", "EU", "FA", "FI", "FJ", "FO", "FR", "FY", "GA", "GD", "GL", "GN", "GU", "HA", "HI", "HR", "HU", "HY", "IA", "IE", "IK", "IN", "IS", "IT", "IW", "JA", "JI", "JW", "KA", "KK", "KL", "KM", "KN", "KO", "KS", "KU", "KY", "LA", "LN", "LO", "LT", "LV", "MG", "MI", "MK", "ML", "MN", "MO", "MR", "MS", "MT", "MY", "NA", "NE", "NL", "NO", "OC", "OM", "OR", "PA", "PL", "PS", "PT", "QU", "RM", "RN", "RO", "RU", "RW", "SA", "SD", "SG", "SH", "SI", "SK", "SL", "SM", "SN", "SO", "SQ", "SR", "SS", "ST", "SU", "SV", "SW", "TA", "TE", "TG", "TH", "TI", "TK", "TL", "TN", "TO", "TR", "TS", "TT", "TW", "UK", "UR", "UZ", "VI", "VO", "WO", "XH", "YO", "ZH", "ZU"};
    private static final String MSG_CHOOSE_LANGUAGE = (class$anon$util$LanguageMapper == null ? (class$anon$util$LanguageMapper = LanguageMapper.class$("anon.util.LanguageMapper")) : class$anon$util$LanguageMapper).getName() + "_ChooseLanguage";
    private Locale m_locale;
    static /* synthetic */ Class class$anon$util$LanguageMapper;

    public LanguageMapper() {
        this.createLocale();
    }

    public LanguageMapper(int a_maxTextLength) {
        super(a_maxTextLength);
        this.createLocale();
    }

    public LanguageMapper(String a_ISOCode, int a_maxTextLength) throws IllegalArgumentException {
        super(a_ISOCode, a_maxTextLength);
        this.createLocale();
    }

    public LanguageMapper(String a_ISOCode) throws IllegalArgumentException {
        super(a_ISOCode);
        this.createLocale();
    }

    public LanguageMapper(String a_ISOCode, Locale a_locale) throws IllegalArgumentException {
        super(a_ISOCode, a_locale);
        this.createLocale();
    }

    public LanguageMapper(String a_ISOCode, int a_maxTextLength, Locale a_locale) throws IllegalArgumentException {
        super(a_ISOCode, a_maxTextLength, a_locale);
        this.createLocale();
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public Locale getLocale(String a_countryCode) {
        if (this.getISOCode().length() == 0) {
            return null;
        }
        return new Locale(this.getISOCode(), a_countryCode);
    }

    public static Vector getLocalisedLanguages() {
        return LanguageMapper.getLocalisedLanguages(0, null);
    }

    public static Vector getLocalisedLanguages(Locale a_loc) {
        return LanguageMapper.getLocalisedLanguages(0, a_loc);
    }

    public static Vector getLocalisedLanguages(int a_maxTextLength) {
        return LanguageMapper.getLocalisedLanguages(a_maxTextLength, null);
    }

    public static Vector getLocalisedLanguages(int a_maxTextLength, Locale a_loc) {
        Vector<LanguageMapper> localisedCountries = new Vector<LanguageMapper>();
        for (int i = 0; i < ms_languageCodes.length; ++i) {
            localisedCountries.addElement(new LanguageMapper(ms_languageCodes[i], a_maxTextLength, a_loc));
        }
        return Util.sortStrings(localisedCountries);
    }

    protected final String getChooseMessage() {
        return JAPMessages.getString(MSG_CHOOSE_LANGUAGE);
    }

    protected String getJRETransaltionOfISOCode(String a_ISOLanguageCode, Locale a_locale) {
        return new Locale(a_ISOLanguageCode, a_locale.getCountry()).getDisplayLanguage(a_locale);
    }

    private void createLocale() {
        if (this.getISOCode().length() > 0) {
            this.m_locale = new Locale(this.getISOCode(), "");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

