/*
 * Decompiled with CFR 0.152.
 */
package anon.transport.address;

import anon.transport.address.AddressParameter;
import anon.transport.address.IAddress;
import anon.transport.address.MalformedURNException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Endpoint {
    protected String m_transportIdentifier;
    protected Hashtable m_paramters;

    public String getTransportIdentifier() {
        return this.m_transportIdentifier;
    }

    public static String toURN(IAddress a_address) {
        String identifier = a_address.getTransportIdentifier();
        StringBuffer builder = new StringBuffer();
        builder.append("urn:endpoint:");
        builder.append(identifier);
        AddressParameter[] parameters = a_address.getAllParameters();
        int length = parameters.length;
        for (int i = 0; i < length; ++i) {
            builder.append(":");
            builder.append(parameters[i].getName());
            builder.append("(");
            builder.append(parameters[i].getValue());
            builder.append(")");
        }
        return builder.toString();
    }

    public Endpoint(String a_theURN) throws MalformedURNException {
        StringTokenizer st = new StringTokenizer(a_theURN, ":");
        String[] components = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreElements()) {
            components[i++] = st.nextToken();
        }
        if (components.length < 3) {
            throw new MalformedURNException("A valid Endpoint needs at least 3 Components");
        }
        if (!components[0].equals("urn")) {
            throw new MalformedURNException("URN must start with \"urn:\"");
        }
        if (!components[1].equals("endpoint")) {
            throw new MalformedURNException("Can only handle Endpoint-Namespace. Is " + components[1]);
        }
        this.m_transportIdentifier = components[2];
        this.m_paramters = new Hashtable();
        int length = components.length;
        for (i = 3; i < length; ++i) {
            int parentheseIndex = components[i].indexOf("(");
            int decrementedLength = components[i].length() - 1;
            String name = components[i].substring(0, parentheseIndex);
            String value = components[i].substring(++parentheseIndex, decrementedLength);
            this.m_paramters.put(name, new AddressParameter(name, value));
        }
    }

    public String getParameter(String a_name) {
        AddressParameter parameter = (AddressParameter)this.m_paramters.get(a_name);
        return parameter == null ? null : parameter.getValue();
    }

    public AddressParameter[] getAllParameters() {
        AddressParameter[] result = new AddressParameter[this.m_paramters.size()];
        Enumeration en = this.m_paramters.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            result[i++] = (AddressParameter)en.nextElement();
        }
        return result;
    }
}

