/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.IServiceContainer;
import anon.client.AbstractChannel;
import anon.client.BasicTrustModel;
import anon.client.ITrustModel;
import anon.client.MixPacket;
import anon.client.Multiplexer;
import java.io.IOException;
import logging.LogHolder;
import logging.LogType;

public abstract class AbstractControlChannel
extends AbstractChannel {
    private IServiceContainer m_serviceContainer;
    private boolean m_bSendingPacket = false;

    public AbstractControlChannel(int a_channelId, Multiplexer a_parentMultiplexer, IServiceContainer a_serviceContainer) {
        super(a_channelId, a_parentMultiplexer);
        this.m_serviceContainer = a_serviceContainer;
        if (this.m_serviceContainer == null) {
            this.m_serviceContainer = new IServiceContainer(){

                public void keepCurrentService(boolean a_bKeepCurrentService) {
                }

                public boolean isServiceAutoSwitched() {
                    return false;
                }

                public boolean isReconnectedAutomatically() {
                    return false;
                }

                public ITrustModel getTrustModel() {
                    return new BasicTrustModel();
                }

                public void reset() {
                }
            };
        }
        a_parentMultiplexer.getChannelTable().registerControlChannel(a_channelId, this);
    }

    public boolean isSending() {
        return this.m_bSendingPacket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendRawMessage(byte[] a_message) {
        try {
            int currentPacketLength;
            int bytesToSend = a_message.length;
            this.m_bSendingPacket = true;
            do {
                MixPacket currentMixPacket = this.createEmptyMixPacket();
                currentPacketLength = Math.min(bytesToSend, currentMixPacket.getPayloadData().length);
                currentMixPacket.setChannelFlags((short)currentPacketLength);
                System.arraycopy(a_message, a_message.length - bytesToSend, currentMixPacket.getPayloadData(), 0, currentPacketLength);
                this.sendPacket(currentMixPacket);
            } while ((bytesToSend -= currentPacketLength) > 0 && !Thread.currentThread().isInterrupted());
            int n = 0;
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            this.m_bSendingPacket = false;
        }
    }

    public void processReceivedPacket(MixPacket a_mixPacket) {
        short packetDataLength = a_mixPacket.getChannelFlags();
        if (packetDataLength > a_mixPacket.getPayloadData().length || packetDataLength < 0) {
            LogHolder.log(3, LogType.NET, "AbstractControlChannel: processReceivedPacket(): Invalid packet length.");
        } else {
            byte[] packetData = new byte[packetDataLength];
            System.arraycopy(a_mixPacket.getPayloadData(), 0, packetData, 0, packetDataLength);
            this.processPacketData(packetData);
        }
    }

    protected final IServiceContainer getServiceContainer() {
        return this.m_serviceContainer;
    }

    protected abstract void processPacketData(byte[] var1);
}

