/*
 * Decompiled with CFR 0.152.
 */
package misc;

import anon.AnonChannel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class DirektUDPChannel
implements AnonChannel {
    private static final int UDP_PROTOCOL_HEADER_SIZE = 2;
    private AnonUDPChannelOutputStream m_anonUDPOutputStream = null;
    private AnonUDPChannelInputStream m_anonUDPInputStream = null;
    private String m_strDstHost;
    private int m_iDstPort;
    private int m_iSrcPort;
    private boolean m_bIsConnected = false;
    private Socket m_channelUnderlyingChannel;

    protected DirektUDPChannel(Socket a_channelUnderlyingChannel) throws IOException {
        this.m_channelUnderlyingChannel = a_channelUnderlyingChannel;
        this.m_anonUDPInputStream = new AnonUDPChannelInputStream(a_channelUnderlyingChannel.getInputStream());
        this.m_anonUDPOutputStream = new AnonUDPChannelOutputStream(a_channelUnderlyingChannel.getOutputStream());
    }

    public void setDestination(String host, int port) {
        this.m_strDstHost = host;
        this.m_iDstPort = port;
    }

    public void setSourcePort(int port) {
        this.m_iSrcPort = port;
    }

    private void connect() throws IOException {
        int lenHostname = this.m_strDstHost.length();
        byte[] req = new byte[lenHostname + 8];
        req[0] = 1;
        req[1] = 4;
        req[2] = 3;
        req[3] = (byte)lenHostname;
        byte[] bar_hostname = this.m_strDstHost.getBytes();
        System.arraycopy(bar_hostname, 0, req, 4, lenHostname);
        req[4 + lenHostname] = (byte)(this.m_iDstPort >> 8 & 0xFF);
        req[5 + lenHostname] = (byte)(this.m_iDstPort & 0xFF);
        req[6 + lenHostname] = (byte)(this.m_iSrcPort >> 8 & 0xFF);
        req[7 + lenHostname] = (byte)(this.m_iSrcPort & 0xFF);
        this.m_anonUDPOutputStream.writeRaw(req);
        this.m_anonUDPOutputStream.flush();
        this.m_bIsConnected = true;
    }

    public void setSentAutoFlushDelay(int msAutoFlushDelay) {
    }

    public InputStream getInputStream() {
        return this.m_anonUDPInputStream;
    }

    public OutputStream getOutputStream() {
        return this.m_anonUDPOutputStream;
    }

    public void writePacket(byte[] payload) throws IOException {
        this.m_anonUDPOutputStream.write(payload, 0, payload.length);
    }

    public int readPacket(byte[] payload, int off, int len) throws IOException, UDPPacketStreamDesynchronisationException, UDPPacketToLargeException {
        return this.m_anonUDPInputStream.readPacket(payload, off, len);
    }

    public int getOutputBlockSize() {
        return 996;
    }

    public void close() {
        try {
            this.m_channelUnderlyingChannel.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isClosed() {
        return this.m_channelUnderlyingChannel.isClosed();
    }

    class AnonUDPChannelInputStream
    extends InputStream {
        private InputStream m_In;
        private int m_iRemaingLenUDPPayload;

        AnonUDPChannelInputStream(InputStream in) {
            this.m_In = in;
            this.m_iRemaingLenUDPPayload = -1;
        }

        public void close() throws IOException {
            this.m_In.close();
        }

        public synchronized int read() throws IOException {
            return -1;
        }

        public synchronized int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            if (this.m_iRemaingLenUDPPayload <= 0) {
                this.m_iRemaingLenUDPPayload = this.m_In.read();
                this.m_iRemaingLenUDPPayload <<= 8;
                this.m_iRemaingLenUDPPayload |= this.m_In.read() & 0xFF;
                this.m_iRemaingLenUDPPayload &= 0xFFFF;
            }
            int ret = Math.min(this.m_iRemaingLenUDPPayload, len);
            if ((ret = this.m_In.read(b, off, ret)) >= 0) {
                this.m_iRemaingLenUDPPayload -= ret;
            }
            return ret;
        }

        public synchronized int readPacket(byte[] b, int off, int len) throws IOException, UDPPacketStreamDesynchronisationException, UDPPacketToLargeException {
            if (this.m_iRemaingLenUDPPayload <= 0) {
                this.m_iRemaingLenUDPPayload = this.m_In.read();
                this.m_iRemaingLenUDPPayload <<= 8;
                this.m_iRemaingLenUDPPayload |= this.m_In.read() & 0xFF;
                this.m_iRemaingLenUDPPayload &= 0xFFFF;
            } else {
                throw new UDPPacketStreamDesynchronisationException();
            }
            if (this.m_iRemaingLenUDPPayload > len) {
                throw new UDPPacketToLargeException();
            }
            len = this.m_iRemaingLenUDPPayload;
            while (this.m_iRemaingLenUDPPayload > 0) {
                int ret = this.m_In.read(b, off, this.m_iRemaingLenUDPPayload);
                if (ret >= 0) {
                    this.m_iRemaingLenUDPPayload -= ret;
                    off += ret;
                    continue;
                }
                return ret;
            }
            return len;
        }
    }

    class AnonUDPChannelOutputStream
    extends OutputStream {
        OutputStream m_Out;

        AnonUDPChannelOutputStream(OutputStream out) {
            this.m_Out = out;
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void writeRaw(byte[] b) throws IOException {
            this.m_Out.write(b, 0, b.length);
        }

        public void write(int b) throws IOException {
            this.m_Out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            if (!DirektUDPChannel.this.m_bIsConnected) {
                DirektUDPChannel.this.connect();
            }
            byte[] firstPacket = new byte[998];
            firstPacket[0] = (byte)(len >> 8 & 0xFF);
            firstPacket[1] = (byte)(len & 0xFF);
            int i = Math.min(firstPacket.length - 2, len);
            System.arraycopy(b, off, firstPacket, 2, i);
            this.m_Out.write(firstPacket, 0, i + 2);
            len -= i;
            off += i;
            while (len > 0) {
                i = Math.min(998, len);
                this.m_Out.write(b, off, i);
                off += i;
                len -= i;
            }
        }

        public void flush() throws IOException {
            this.m_Out.flush();
        }

        public void close() throws IOException {
            this.m_Out.close();
        }
    }

    public class UDPPacketStreamDesynchronisationException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }

    public class UDPPacketToLargeException
    extends Exception {
        private static final long serialVersionUID = 1L;
    }
}

