/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.util;

import org.apache.oro.util.GenericCache;
import org.apache.oro.util.GenericCacheEntry;

public final class CacheLRU
extends GenericCache {
    private int __head = 0;
    private int __tail = 0;
    private int[] __next = new int[this._cache.length];
    private int[] __prev = new int[this._cache.length];

    public CacheLRU(int capacity) {
        super(capacity);
        int i = 0;
        while (i < this.__next.length) {
            this.__prev[i] = -1;
            this.__next[i] = -1;
            ++i;
        }
    }

    public CacheLRU() {
        this(20);
    }

    private void __moveToFront(int index) {
        if (this.__head != index) {
            int next = this.__next[index];
            int prev = this.__prev[index];
            this.__next[prev] = next;
            if (next >= 0) {
                this.__prev[next] = prev;
            } else {
                this.__tail = prev;
            }
            this.__prev[index] = -1;
            this.__next[index] = this.__head;
            this.__prev[this.__head] = index;
            this.__head = index;
        }
    }

    public synchronized Object getElement(Object key) {
        Object obj = this._table.get(key);
        if (obj != null) {
            GenericCacheEntry entry = (GenericCacheEntry)obj;
            this.__moveToFront(entry._index);
            return entry._value;
        }
        return null;
    }

    public final synchronized void addElement(Object key, Object value) {
        Object obj = this._table.get(key);
        if (obj != null) {
            GenericCacheEntry entry = (GenericCacheEntry)obj;
            entry._value = value;
            entry._key = key;
            this.__moveToFront(entry._index);
            return;
        }
        if (!this.isFull()) {
            if (this._numEntries > 0) {
                this.__prev[this._numEntries] = this.__tail;
                this.__next[this._numEntries] = -1;
                this.__moveToFront(this._numEntries);
            }
            ++this._numEntries;
        } else {
            this._table.remove(this._cache[this.__tail]._key);
            this.__moveToFront(this.__tail);
        }
        this._cache[this.__head]._value = value;
        this._cache[this.__head]._key = key;
        this._table.put(key, this._cache[this.__head]);
    }
}

