/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.paxos.integration;

import anon.crypto.SignatureVerifier;
import anon.crypto.XMLSignature;
import anon.util.XMLUtil;
import anon.util.ZLibTools;
import infoservice.agreement.paxos.messages.CollectMessage;
import infoservice.agreement.paxos.messages.FreezeProofMessage;
import infoservice.agreement.paxos.messages.PaxosMessage;
import java.util.Enumeration;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class InfoServiceMessageFactory {
    public static PaxosMessage decode(byte[] a_data) {
        byte[] data = null;
        try {
            data = ZLibTools.decompress(a_data);
            Document doc = XMLUtil.toXMLDocument(data);
            return InfoServiceMessageFactory.parseDocument(doc);
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.AGREEMENT, "Unable to decode given message");
            return null;
        }
    }

    private static PaxosMessage parseDocument(Document a_doc) {
        Node rootNode = a_doc.getFirstChild();
        String nodeName = rootNode.getNodeName();
        PaxosMessage result = null;
        result = nodeName.equals(PaxosMessage.FREEZEPROOF) ? new FreezeProofMessage() : (nodeName.equals(PaxosMessage.COLLECT) ? new CollectMessage() : new PaxosMessage(nodeName));
        Node tmp = XMLUtil.getFirstChildByName(rootNode, "RoundNr");
        result.setRound(XMLUtil.parseValue(tmp, -1));
        tmp = XMLUtil.getFirstChildByName(rootNode, "Initiator");
        result.setInitiator(XMLUtil.parseValue(tmp, ""));
        tmp = XMLUtil.getFirstChildByName(rootNode, "Proposal");
        result.setProposal(XMLUtil.parseValue(tmp, ""));
        tmp = XMLUtil.getFirstChildByName(rootNode, "Sender");
        result.setSender(XMLUtil.parseValue(tmp, ""));
        tmp = XMLUtil.getFirstChildByName(rootNode, "PaxosInstance");
        result.setPaxosInstanceIdentifier(XMLUtil.parseValue(tmp, ""));
        if (result instanceof FreezeProofMessage) {
            tmp = XMLUtil.getFirstChildByName(rootNode, "WeakValue");
            ((FreezeProofMessage)result).setWeakValue(XMLUtil.parseValue(tmp, ""));
            tmp = XMLUtil.getFirstChildByName(rootNode, "StrongValue");
            ((FreezeProofMessage)result).setStrongValue(XMLUtil.parseValue(tmp, ""));
            ((FreezeProofMessage)result).setSignedData(rootNode);
        }
        if (result instanceof CollectMessage) {
            InfoServiceMessageFactory.parseProofs(rootNode, (CollectMessage)result);
        }
        if (InfoServiceMessageFactory.isSane(a_doc, result)) {
            return result;
        }
        return null;
    }

    private static void parseProofs(Node rootNode, CollectMessage message) {
        Node proofs = XMLUtil.getFirstChildByName(rootNode, "FreezeProofs");
        Node proof = proofs.getFirstChild();
        Vector<FreezeProofMessage> freezeProofs = new Vector<FreezeProofMessage>();
        do {
            FreezeProofMessage msg = InfoServiceMessageFactory.createFreezeProof(proof);
            freezeProofs.add(msg);
        } while ((proof = proof.getNextSibling()) != null);
        message.setProofs(freezeProofs);
    }

    private static FreezeProofMessage createFreezeProof(Node rootNode) {
        FreezeProofMessage result = new FreezeProofMessage();
        Node tmp = XMLUtil.getFirstChildByName(rootNode, "RoundNr");
        result.setRound(XMLUtil.parseValue(tmp, -1));
        tmp = XMLUtil.getFirstChildByName(rootNode, "Initiator");
        result.setInitiator(XMLUtil.parseValue(tmp, ""));
        tmp = XMLUtil.getFirstChildByName(rootNode, "Proposal");
        result.setProposal(XMLUtil.parseValue(tmp, ""));
        tmp = XMLUtil.getFirstChildByName(rootNode, "Sender");
        result.setSender(XMLUtil.parseValue(tmp, ""));
        tmp = XMLUtil.getFirstChildByName(rootNode, "PaxosInstance");
        result.setPaxosInstanceIdentifier(XMLUtil.parseValue(tmp, ""));
        tmp = XMLUtil.getFirstChildByName(rootNode, "WeakValue");
        result.setWeakValue(XMLUtil.parseValue(tmp, ""));
        tmp = XMLUtil.getFirstChildByName(rootNode, "StrongValue");
        result.setStrongValue(XMLUtil.parseValue(tmp, ""));
        result.setSignatureOk(SignatureVerifier.getInstance().verifyXml((Element)rootNode, 2));
        result.setSignedData(rootNode);
        return result;
    }

    private static boolean isSane(Document a_doc, PaxosMessage a_msg) {
        boolean result = true;
        result &= InfoServiceMessageFactory.checkOriginator(a_doc, a_msg.getSender());
        result &= SignatureVerifier.getInstance().verifyXml(a_doc, 2);
        if (a_msg instanceof FreezeProofMessage) {
            ((FreezeProofMessage)a_msg).setSignatureOk(result);
        }
        if (a_msg instanceof CollectMessage) {
            result &= InfoServiceMessageFactory.checkProofs((CollectMessage)a_msg);
        }
        return result;
    }

    private static boolean checkProofs(CollectMessage message) {
        boolean result = true;
        Enumeration en = message.getProofs().elements();
        while (en.hasMoreElements()) {
            FreezeProofMessage msg = (FreezeProofMessage)en.nextElement();
            result &= msg.isSignatureOk();
        }
        return result;
    }

    private static boolean checkOriginator(Node a_node, String a_sender) {
        String ski = "";
        try {
            XMLSignature t = XMLSignature.getUnverified(a_node);
            if (t != null) {
                ski = t.getXORofSKIs();
            }
        }
        catch (Exception t) {
            // empty catch block
        }
        boolean ok = a_sender.equalsIgnoreCase(ski);
        if (!ok) {
            LogHolder.log(1, LogType.NET, "Possibly forged message received! SenderID: " + a_sender + " was signed with a certificate with SKI: " + ski + ")");
        }
        return ok;
    }
}

