/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.multicast;

import infoservice.agreement.common.TimeoutThread;
import infoservice.agreement.logging.GiveThingsAName;
import infoservice.agreement.logging.IAgreementLog;
import infoservice.agreement.multicast.AgreementMessageTypes;
import infoservice.agreement.multicast.EchoMulticastAgreementHandlerImpl;
import infoservice.agreement.multicast.interfaces.IAgreementHandler;
import infoservice.agreement.multicast.interfaces.IConsensusLog;
import infoservice.agreement.multicast.messages.AMessage;
import infoservice.agreement.multicast.messages.CommitMessage;
import infoservice.agreement.multicast.messages.EchoMessage;
import infoservice.agreement.multicast.messages.InitMessage;
import infoservice.agreement.multicast.messages.RejectMessage;
import infoservice.dynamic.DynamicConfiguration;
import java.util.Enumeration;
import java.util.Hashtable;

public class ConsensusLogEchoMulticast
implements IConsensusLog {
    private InitMessage m_initMessage = null;
    private Hashtable m_echoMessagesHashTable = new Hashtable();
    private Hashtable m_commitMessagesHashTable = new Hashtable();
    private Hashtable m_rejectMessagesHashTable = new Hashtable();
    private IAgreementLog m_logger = null;
    private boolean m_agreed = false;
    private boolean m_comitted = false;
    private boolean m_timedOut = false;
    private TimeoutThread timeoutThread;
    private IAgreementHandler m_handler;
    private String m_consensusId = "";
    private int m_criticalMasses = Integer.MAX_VALUE;
    private String m_initiatorId = "";
    private boolean m_rejected = false;
    private boolean m_restarted = false;
    private String m_lastCommonRandom = null;

    public ConsensusLogEchoMulticast(EchoMulticastAgreementHandlerImpl a_handler, InitMessage a_initMessage) {
        this.initializeConsensusLog(a_handler, a_initMessage.getConsensusId(), null, a_initMessage.getInitiatorsId());
        this.addInitMessage(a_initMessage);
    }

    public ConsensusLogEchoMulticast(EchoMulticastAgreementHandlerImpl a_handler, String a_consensusId, IAgreementLog a_log, String a_initiatorsId) {
        this.initializeConsensusLog(a_handler, a_consensusId, a_log, a_initiatorsId);
    }

    public ConsensusLogEchoMulticast(EchoMulticastAgreementHandlerImpl a_handler, InitMessage a_initMessage, IAgreementLog a_log) {
        this.initializeConsensusLog(a_handler, a_initMessage.getConsensusId(), a_log, a_initMessage.getInitiatorsId());
    }

    private void initializeConsensusLog(EchoMulticastAgreementHandlerImpl a_handler, String a_consensusId, IAgreementLog a_log, String a_initiatorsId) {
        this.m_handler = a_handler;
        this.m_criticalMasses = (this.m_handler.getInfoService().getNumberOfAllInfoservices() * 2 + 1) / 3;
        this.m_consensusId = a_consensusId;
        this.m_initiatorId = a_initiatorsId;
        this.m_logger = a_log;
        this.timeoutThread = new TimeoutThread(this, DynamicConfiguration.getInstance().getEmcConsensusLogTimeout());
        this.timeoutThread.start();
    }

    private boolean checkGenericMessage(AMessage a_msg) {
        if (!a_msg.isSignatureOK()) {
            this.debug("checkGeneric: " + AgreementMessageTypes.getTypeAsString(a_msg.getMessageType()) + ":Invalid signature");
            return false;
        }
        if (!this.getConsensusID().equals(a_msg.getConsensusId())) {
            this.debug("checkGeneric: " + AgreementMessageTypes.getTypeAsString(a_msg.getMessageType()) + ": Wrong consensus id\n" + this.getConsensusID() + "\n" + a_msg.getConsensusId());
            return false;
        }
        if (this.m_timedOut) {
            this.debug("checkGeneric: " + AgreementMessageTypes.getTypeAsString(a_msg.getMessageType()) + ": Timed out!!!  LogId: " + this.getConsensusID());
            return false;
        }
        return true;
    }

    public boolean addInitMessage(InitMessage a_msg) {
        if (!this.checkInitMessage(a_msg)) {
            return false;
        }
        this.m_initMessage = a_msg;
        this.m_initiatorId = a_msg.getInitiatorsId();
        String initiatorsName = GiveThingsAName.getNameForNumber(a_msg.getInitiatorsId());
        this.debug(" <---- ADD InitMessage FROM " + initiatorsName + " " + a_msg);
        return true;
    }

    private boolean checkInitMessage(InitMessage a_msg) {
        if (this.m_initMessage != null) {
            this.debug("OVERWRITE ERROR: addInitMessage(): " + a_msg);
            return false;
        }
        return this.checkGenericMessage(a_msg);
    }

    public boolean addEchoMessage(EchoMessage a_msg) {
        if (!this.checkEchoMessage(a_msg)) {
            return false;
        }
        this.m_echoMessagesHashTable.put(a_msg.getHashKey(), a_msg);
        String sendersName = GiveThingsAName.getNameForNumber(a_msg.getSenderId());
        this.debug(" <---- ADD EchoMessage FROM " + sendersName + " " + a_msg);
        return true;
    }

    private boolean checkEchoMessage(EchoMessage a_msg) {
        if (!this.checkGenericMessage(a_msg)) {
            return false;
        }
        if (this.m_echoMessagesHashTable.containsKey(a_msg.getHashKey())) {
            this.debug(" ----- DISCARD DUPLICATE EchoMessage FROM " + a_msg.getSenderId() + " " + a_msg);
            return false;
        }
        return true;
    }

    public boolean addCommitMessage(CommitMessage a_msg) {
        if (!this.checkCommitMessage(a_msg)) {
            return false;
        }
        this.setAgreed(true);
        this.m_commitMessagesHashTable.put(a_msg.getHashKey(), a_msg);
        String sendersName = GiveThingsAName.getNameForNumber(a_msg.getSenderId());
        this.debug(" <---- ADD CommitMessage FROM " + sendersName + " " + a_msg);
        return true;
    }

    private boolean checkCommitMessage(CommitMessage a_msg) {
        if (!this.checkGenericMessage(a_msg)) {
            return false;
        }
        if (this.m_commitMessagesHashTable.containsKey(a_msg.getHashKey())) {
            this.debug("addCommitMessage(): Duplicate :: " + a_msg);
            return false;
        }
        Hashtable<String, EchoMessage> hashtable = new Hashtable<String, EchoMessage>(a_msg.getEchoMessages().size());
        Enumeration enEcho = a_msg.getEchoMessages().elements();
        while (enEcho.hasMoreElements()) {
            EchoMessage echo = (EchoMessage)enEcho.nextElement();
            if (!echo.isSignatureOK()) {
                return false;
            }
            if (hashtable.containsKey(echo.getHashKey())) continue;
            hashtable.put(echo.getHashKey(), echo);
        }
        a_msg.setEchoMessages(hashtable);
        if (a_msg.getEchoMessages().size() < this.m_criticalMasses) {
            this.debug("addCommitMessage(): CriticalMass (" + this.m_criticalMasses + ") can't be achieved by " + a_msg.getEchoMessages().size() + " EchoMessages:: \n" + a_msg);
            return false;
        }
        return true;
    }

    public void addRejectMessage(RejectMessage a_msg) {
        if (!this.checkRejectMessage(a_msg)) {
            return;
        }
        this.m_rejectMessagesHashTable.put(a_msg.getHashKey(), a_msg);
        String sendersName = GiveThingsAName.getNameForNumber(a_msg.getSenderId());
        this.debug(" <---- ADD RejectMessage FROM " + sendersName + " " + a_msg);
    }

    private boolean checkRejectMessage(RejectMessage a_msg) {
        if (!this.checkGenericMessage(a_msg)) {
            return false;
        }
        if (this.m_rejectMessagesHashTable.containsKey(a_msg.getHashKey())) {
            this.debug("addRejectMessage(): Duplicate :: " + a_msg);
            return false;
        }
        if (this.m_rejectMessagesHashTable.size() + 1 > this.m_criticalMasses - 1) {
            this.m_rejected = true;
            this.checkRejectMajority(a_msg);
        }
        return true;
    }

    private void checkRejectMajority(RejectMessage a_msg) {
        Enumeration en = this.m_rejectMessagesHashTable.elements();
        Hashtable amounts = new Hashtable();
        while (en.hasMoreElements()) {
            RejectMessage msg = (RejectMessage)en.nextElement();
            this.putter(amounts, msg);
        }
        this.putter(amounts, a_msg);
        Enumeration en2 = amounts.keys();
        while (en2.hasMoreElements()) {
            String prop = (String)en2.nextElement();
            int count = (Integer)amounts.get(prop);
            if (count < this.m_criticalMasses) continue;
            this.m_lastCommonRandom = prop;
            this.debug(" ----> RESET lastCommonRandom TO " + this.m_lastCommonRandom);
            return;
        }
    }

    private void putter(Hashtable amounts, RejectMessage msg) {
        String prop = msg.getLastCommonRandom();
        Integer count = (Integer)amounts.remove(prop);
        if (count == null) {
            count = new Integer(0);
        }
        count = new Integer(count + 1);
        amounts.put(prop, count);
    }

    public CommitMessage tryToCreateACommitMessage() {
        this.debug("tryToCreateACommitMessage() Got " + this.getEchoMessageCount() + " Need " + this.m_criticalMasses);
        CommitMessage commit = null;
        if (this.getEchoMessageCount() >= this.m_criticalMasses) {
            InitMessage mesg = this.getInitMessages();
            if (mesg == null) {
                this.debug("UHHHHHH MY INIT MESSAGE IS NULL!!");
                return null;
            }
            commit = new CommitMessage(this.getInitMessages(), this.m_handler.getInfoService().getIdentifier(), this.m_echoMessagesHashTable);
        }
        return commit;
    }

    public int getEchoMessageCount() {
        return this.m_echoMessagesHashTable.keySet().size();
    }

    public int getCommitMessageCount() {
        return this.m_commitMessagesHashTable.size();
    }

    @Override
    public synchronized boolean isAgreed() {
        return this.m_agreed;
    }

    @Override
    public synchronized void setAgreed(boolean agreed) {
        this.m_agreed = agreed;
        this.stopTimeout();
    }

    @Override
    public boolean isComitted() {
        return this.m_comitted;
    }

    @Override
    public void setComitted(boolean comitted) {
        this.m_comitted = comitted;
    }

    @Override
    public void stopTimeout() {
        this.timeoutThread.cancel();
    }

    @Override
    public String getConsensusID() {
        return this.m_consensusId;
    }

    public InitMessage getInitMessages() {
        return this.m_initMessage;
    }

    @Override
    public String getInitiatorId() {
        return this.m_initiatorId;
    }

    @Override
    public boolean isRejected() {
        return this.m_rejected;
    }

    @Override
    public String getLastCommonRandom() {
        return this.m_lastCommonRandom;
    }

    public boolean isRestarted() {
        return this.m_restarted;
    }

    public void setRestarted(boolean a_restarted) {
        this.m_restarted = a_restarted;
    }

    private void debug(String a_message) {
        this.m_logger.debug(a_message);
    }

    @Override
    public void timeout(Object a_value) {
        this.m_timedOut = true;
        this.m_handler.notifyConsensusLogTimeout(this);
        this.debug(" TIMEOUT " + this.m_initMessage);
    }
}

