/*
 * Decompiled with CFR 0.152.
 */
package infoservice;

import anon.crypto.SignatureCreator;
import anon.infoservice.AbstractDistributableDatabaseEntry;
import anon.infoservice.Database;
import anon.infoservice.IDistributable;
import anon.infoservice.JAPMinVersion;
import anon.infoservice.JAPVersionInfo;
import anon.infoservice.JavaVersionDBEntry;
import anon.infoservice.MessageDBEntry;
import anon.util.XMLUtil;
import infoservice.Configuration;
import infoservice.InfoServiceDistributor;
import java.io.File;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UpdateInformationHandler
implements Runnable {
    private static UpdateInformationHandler ms_uihInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UpdateInformationHandler getInstance() {
        Class<UpdateInformationHandler> clazz = UpdateInformationHandler.class;
        synchronized (UpdateInformationHandler.class) {
            if (ms_uihInstance == null) {
                ms_uihInstance = new UpdateInformationHandler();
                Thread uihThread = new Thread((Runnable)ms_uihInstance, "UpdateInformationHandler");
                uihThread.setDaemon(true);
                uihThread.start();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return ms_uihInstance;
        }
    }

    private UpdateInformationHandler() {
    }

    @Override
    public void run() {
        while (true) {
            if (Configuration.getInstance().isRootOfUpdateInformation()) {
                Element[] entries;
                block26: {
                    AbstractDistributableDatabaseEntry distributable;
                    block25: {
                        Element jnlpNode;
                        block24: {
                            try {
                                byte[] releaseJnlpData = this.readLocalFile(Configuration.getInstance().getJapReleaseJnlpFile());
                                Document releaseJnlpDocument = XMLUtil.toXMLDocument(releaseJnlpData);
                                jnlpNode = (Element)XMLUtil.getFirstChildByName(releaseJnlpDocument, JAPVersionInfo.getXmlElementName());
                                this.prepareEntryForPropaganda(jnlpNode);
                                Database.getInstance(JAPVersionInfo.class).update(new JAPVersionInfo(jnlpNode, 1));
                            }
                            catch (Exception e) {
                                LogHolder.log(3, LogType.NET, "Error while processing JAP release information: " + e);
                                distributable = (JAPVersionInfo)Database.getInstance(JAPVersionInfo.class).getEntryById("/japRelease.jnlp");
                                if (distributable == null) break block24;
                                InfoServiceDistributor.getInstance().addJob(distributable);
                            }
                        }
                        try {
                            byte[] developmentJnlpData = this.readLocalFile(Configuration.getInstance().getJapDevelopmentJnlpFile());
                            Document developmentJnlpDocument = XMLUtil.toXMLDocument(developmentJnlpData);
                            jnlpNode = (Element)XMLUtil.getFirstChildByName(developmentJnlpDocument, JAPVersionInfo.getXmlElementName());
                            this.prepareEntryForPropaganda(jnlpNode);
                            Database.getInstance(JAPVersionInfo.class).update(new JAPVersionInfo(jnlpNode, 2));
                        }
                        catch (Exception e) {
                            LogHolder.log(3, LogType.NET, "Error while processing JAP development information: " + e);
                            distributable = (JAPVersionInfo)Database.getInstance(JAPVersionInfo.class).getEntryById("/japDevelopment.jnlp");
                            if (distributable == null) break block25;
                            InfoServiceDistributor.getInstance().addJob(distributable);
                        }
                    }
                    try {
                        byte[] minVersionData = this.readLocalFile(Configuration.getInstance().getJapMinVersionFile());
                        Document minVersionDocument = XMLUtil.toXMLDocument(minVersionData);
                        Element japNode = (Element)XMLUtil.getFirstChildByName(minVersionDocument, JAPMinVersion.getXmlElementName());
                        this.prepareEntryForPropaganda(japNode);
                        Database.getInstance(JAPMinVersion.class).update(new JAPMinVersion(japNode));
                    }
                    catch (Exception e) {
                        LogHolder.log(3, LogType.NET, "Error while processing JAP minimum version information: " + e.toString());
                        distributable = (JAPMinVersion)Database.getInstance(JAPMinVersion.class).getEntryById("JAPMinVersion");
                        if (distributable == null) break block26;
                        InfoServiceDistributor.getInstance().addJob(distributable);
                    }
                }
                try {
                    entries = XMLUtil.readElementsByTagName(Configuration.getInstance().getMessageFile(), "Message");
                    for (int i = 0; i < entries.length; ++i) {
                        this.prepareEntryForPropaganda(entries[i]);
                        try {
                            Database.getInstance(MessageDBEntry.class).update(new MessageDBEntry(entries[i]));
                        }
                        catch (Exception ex) {
                            LogHolder.log(3, LogType.NET, "Error while processing message information.", ex);
                        }
                        entries[i] = null;
                    }
                    entries = null;
                }
                catch (Exception a_e) {
                    LogHolder.log(3, LogType.NET, "Error while processing message information.", a_e);
                }
                try {
                    entries = XMLUtil.readElementsByTagName(Configuration.getInstance().getJavaLatestVersionFile(), "JavaVersion");
                    for (int i = 0; i < entries.length; ++i) {
                        this.prepareEntryForPropaganda(entries[i]);
                        try {
                            Database.getInstance(JavaVersionDBEntry.class).update(new JavaVersionDBEntry(entries[i]));
                        }
                        catch (Exception ex) {
                            LogHolder.log(3, LogType.NET, "Error while processing Java version information.", ex);
                        }
                        entries[i] = null;
                    }
                    entries = null;
                }
                catch (Exception a_e) {
                    LogHolder.log(3, LogType.NET, "Error while processing Java version information.", a_e);
                }
            } else {
                Vector distributables = Database.getInstance(JavaVersionDBEntry.class).getEntryList();
                Enumeration enumDistributales = Database.getInstance(JAPVersionInfo.class).getEntrySnapshotAsEnumeration();
                while (enumDistributales.hasMoreElements()) {
                    distributables.addElement(enumDistributales.nextElement());
                }
                enumDistributales = Database.getInstance(JAPMinVersion.class).getEntrySnapshotAsEnumeration();
                while (enumDistributales.hasMoreElements()) {
                    distributables.addElement(enumDistributales.nextElement());
                }
                for (int i = 0; i < distributables.size(); ++i) {
                    if (distributables.elementAt(i) == null) continue;
                    InfoServiceDistributor.getInstance().addJob((IDistributable)distributables.elementAt(i));
                }
                distributables.clear();
                Object var2_2 = null;
            }
            try {
                Thread.sleep(600000L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private byte[] readLocalFile(String a_fileName) {
        try {
            FileReader fr = new FileReader(a_fileName);
            File file = new File(a_fileName);
            int fileSize = (int)file.length();
            char[] readData = new char[fileSize];
            int count = fr.read(readData);
            if (count != fileSize) {
                throw new Exception("Error reading file.");
            }
            fr.close();
            fr = null;
            file = null;
            return new String(readData).getBytes();
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.MISC, "readLocalFile(" + a_fileName + "): " + e);
            return null;
        }
    }

    private void prepareEntryForPropaganda(Element a_entryRootElement) {
        NodeList lastUpdateNodes = a_entryRootElement.getElementsByTagName("LastUpdate");
        for (int i = 0; i < lastUpdateNodes.getLength(); ++i) {
            a_entryRootElement.removeChild(lastUpdateNodes.item(i));
        }
        NodeList signatureNodes = a_entryRootElement.getElementsByTagName("Signature");
        for (int i = 0; i < signatureNodes.getLength(); ++i) {
            a_entryRootElement.removeChild(signatureNodes.item(i));
        }
        Element lastUpdateNode = a_entryRootElement.getOwnerDocument().createElement("LastUpdate");
        XMLUtil.setValue((Node)lastUpdateNode, Long.toString(System.currentTimeMillis()));
        a_entryRootElement.appendChild(lastUpdateNode);
        if (!SignatureCreator.getInstance().signXml(3, a_entryRootElement)) {
            LogHolder.log(4, LogType.MISC, "The update information cannot be signed. Propagate unsigned information.");
        }
    }
}

