/*
 * Decompiled with CFR 0.152.
 */
package infoservice;

import anon.crypto.SignatureCreator;
import anon.crypto.SignatureVerifier;
import anon.infoservice.ANONAddress;
import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.Database;
import anon.infoservice.HttpResponseStructure;
import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.InfoServiceIDEntry;
import anon.infoservice.JAPMinVersion;
import anon.infoservice.JAPVersionInfo;
import anon.infoservice.JavaVersionDBEntry;
import anon.infoservice.ListenerInterface;
import anon.infoservice.MessageDBEntry;
import anon.infoservice.MixCascade;
import anon.infoservice.MixCascadeExitAddresses;
import anon.infoservice.MixInfo;
import anon.infoservice.PerformanceEntry;
import anon.infoservice.StatusInfo;
import anon.pay.PayAccount;
import anon.pay.PaymentInstanceDBEntry;
import anon.terms.template.TermsAndConditionsTemplate;
import anon.util.Util;
import anon.util.XMLUtil;
import infoservice.Configuration;
import infoservice.HTTPResponseGetter;
import infoservice.ISRuntimeStatistics;
import infoservice.InfoService;
import infoservice.JWSInternalCommands;
import infoservice.StatusStatistics;
import infoservice.agreement.IInfoServiceAgreementAdapter;
import infoservice.dynamic.DynamicCommandsExtension;
import infoservice.dynamic.DynamicConfiguration;
import infoservice.japforwarding.JapForwardingTools;
import infoservice.performance.PerformanceRequestHandler;
import infoservice.tor.MixminionDirectoryAgent;
import infoservice.tor.TorDirectoryAgent;
import java.io.File;
import java.net.InetAddress;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class InfoServiceCommands
implements JWSInternalCommands {
    private final HTTPResponseGetter m_isResponseGetter = new HTTPResponseGetter(){

        public Class<InfoServiceDBEntry> getDatabaseClass() {
            return InfoServiceDBEntry.class;
        }
    };
    private final HTTPResponseGetter m_cascadeWebInfoResponseGetter = new HTTPResponseGetter(true){

        public Class<MixCascade> getDatabaseClass() {
            return MixCascade.class;
        }
    };
    private final HTTPResponseGetter m_cascadeResponseGetter = new HTTPResponseGetter(){

        public Class<MixCascade> getDatabaseClass() {
            return MixCascade.class;
        }
    };
    private final HTTPResponseGetter m_messageResponseGetter = new HTTPResponseGetter(){

        public Class<MessageDBEntry> getDatabaseClass() {
            return MessageDBEntry.class;
        }
    };
    private final HTTPResponseGetter m_javaVersionResponseGetter = new HTTPResponseGetter(){

        public Class<JavaVersionDBEntry> getDatabaseClass() {
            return JavaVersionDBEntry.class;
        }
    };
    private final HTTPResponseGetter m_performanceResponseGetter = new HTTPResponseGetter(){

        public Class<PerformanceEntry> getDatabaseClass() {
            return PerformanceEntry.class;
        }
    };
    private final HTTPResponseGetter m_exitAddressListResponseGetter = new HTTPResponseGetter(){

        public Class<MixCascadeExitAddresses> getDatabaseClass() {
            return MixCascadeExitAddresses.class;
        }
    };
    private final HTTPResponseGetter m_tcTemplatesResponseGetter = new HTTPResponseGetter(){

        public Class<TermsAndConditionsTemplate> getDatabaseClass() {
            return TermsAndConditionsTemplate.class;
        }
    };
    private IInfoServiceAgreementAdapter m_agreementAdapter;
    private DynamicCommandsExtension m_dynamicExtension;
    private PerformanceRequestHandler m_perfRequestHandler = new PerformanceRequestHandler();
    private Database m_statusinfoDB = Database.getInstance(StatusInfo.class);
    private Random m_Random = new Random();

    public InfoServiceCommands() {
        if (DynamicConfiguration.getInstance().isConfigured()) {
            this.m_agreementAdapter = DynamicConfiguration.getInstance().getAgreementHandler();
            this.m_dynamicExtension = new DynamicCommandsExtension();
        }
    }

    private HttpResponseStructure infoServerPostHelo(byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(200);
        try {
            LogHolder.log(7, LogType.NET, "Infoserver received: XML: " + new String(a_postData));
            Element infoServiceNode = (Element)XMLUtil.getFirstChildByName(XMLUtil.toXMLDocument(a_postData), "InfoService");
            InfoServiceDBEntry newEntry = new InfoServiceDBEntry(infoServiceNode);
            AbstractDatabaseEntry idEntry = Database.getInstance(InfoServiceIDEntry.class).getEntryById(newEntry.getId());
            if (newEntry.isVerified() && newEntry.isValid()) {
                if (newEntry.isNewerThan(idEntry) && !newEntry.getId().equals(Configuration.getInstance().getID())) {
                    Database.getInstance(InfoServiceIDEntry.class).update(new InfoServiceIDEntry(newEntry));
                    Database.getInstance(InfoServiceDBEntry.class).update(newEntry);
                }
            } else {
                LogHolder.log(4, LogType.NET, "Security check failed for infoservice entry! XML: " + new String(a_postData));
                httpResponse = new HttpResponseStructure(500);
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, e);
            httpResponse = new HttpResponseStructure(400);
        }
        return httpResponse;
    }

    private HttpResponseStructure paymentInstancePostHelo(byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(200);
        try {
            LogHolder.log(7, LogType.NET, "Infoserver received: XML: " + new String(a_postData));
            Element paymentInstanceNode = (Element)XMLUtil.getFirstChildByName(XMLUtil.toXMLDocument(a_postData), "PaymentInstance");
            PaymentInstanceDBEntry newEntry = new PaymentInstanceDBEntry(paymentInstanceNode);
            Database.getInstance(PaymentInstanceDBEntry.class).update(newEntry);
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, e);
            httpResponse = new HttpResponseStructure(400);
        }
        return httpResponse;
    }

    private HttpResponseStructure japFetchPaymentInstanceInfo(String a_piID) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(500);
        try {
            Enumeration en = Database.getInstance(PaymentInstanceDBEntry.class).getEntrySnapshotAsEnumeration();
            while (en.hasMoreElements()) {
                PaymentInstanceDBEntry entry = (PaymentInstanceDBEntry)en.nextElement();
                if (!entry.getId().equals(a_piID)) continue;
                Document doc = XMLUtil.createDocument();
                doc.appendChild(entry.toXmlElement(doc));
                httpResponse = new HttpResponseStructure(doc);
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, e);
        }
        return httpResponse;
    }

    private HttpResponseStructure japFetchPaymentInstances() {
        HttpResponseStructure httpResponse;
        try {
            Document doc = XMLUtil.createDocument();
            Element paymentInstances = doc.createElement("PaymentInstances");
            Enumeration allPaymentInstances = Database.getInstance(PaymentInstanceDBEntry.class).getEntrySnapshotAsEnumeration();
            while (allPaymentInstances.hasMoreElements()) {
                Element paymentInstanceNode = ((PaymentInstanceDBEntry)allPaymentInstances.nextElement()).toXmlElement(doc);
                paymentInstances.appendChild(paymentInstanceNode);
            }
            SignatureCreator.getInstance().signXml(2, paymentInstances);
            doc.appendChild(paymentInstances);
            httpResponse = new HttpResponseStructure(doc);
        }
        catch (Exception e) {
            httpResponse = new HttpResponseStructure(500);
            LogHolder.log(3, LogType.NET, e);
        }
        return httpResponse;
    }

    private HttpResponseStructure messagePost(byte[] a_postData, int a_encoding) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(200);
        try {
            LogHolder.log(7, LogType.NET, "Message received: XML: " + new String(a_postData));
            if (a_encoding != 0) {
                throw new Exception("Unsupported post encoding:" + a_encoding);
            }
            Element mixCascadeNode = (Element)XMLUtil.getFirstChildByName(XMLUtil.toXMLDocument(a_postData), "Message");
            MessageDBEntry entry = new MessageDBEntry(mixCascadeNode);
            Database.getInstance(MessageDBEntry.class).update(entry);
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, e);
            httpResponse = new HttpResponseStructure(400);
        }
        return httpResponse;
    }

    private HttpResponseStructure mixPostHelo(byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(200);
        try {
            LogHolder.log(7, LogType.NET, "Mix HELO received: XML: " + new String(a_postData));
            Element mixNode = (Element)XMLUtil.getFirstChildByName(XMLUtil.toXMLDocument(a_postData), "Mix");
            MixInfo mixEntry = new MixInfo(mixNode);
            if (mixEntry.isVerified() && mixEntry.isValid()) {
                Database.getInstance(MixInfo.class).update(mixEntry);
            } else {
                LogHolder.log(4, LogType.NET, "Signature check failed for Mix entry! XML: " + new String(a_postData));
                httpResponse = new HttpResponseStructure(500);
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, e);
            httpResponse = new HttpResponseStructure(400);
        }
        return httpResponse;
    }

    private HttpResponseStructure mixPostConfigure(byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(200);
        try {
            LogHolder.log(7, LogType.NET, "Mix Configure received: XML: " + new String(a_postData));
            Element mixNode = (Element)XMLUtil.getFirstChildByName(XMLUtil.toXMLDocument(a_postData), "Mix");
            MixInfo mixEntry = new MixInfo(mixNode);
            if (mixEntry.isVerified() && mixEntry.isValid()) {
                Enumeration knownMixCascades = Database.getInstance(MixCascade.class).getEntryList().elements();
                MixCascade assignedCascade = null;
                while (knownMixCascades.hasMoreElements() && assignedCascade == null) {
                    MixCascade currentCascade = (MixCascade)knownMixCascades.nextElement();
                    if (!currentCascade.getMixIds().contains(mixEntry.getId())) continue;
                    assignedCascade = currentCascade;
                }
                if (assignedCascade == null) {
                    mixEntry.setFreeMix(true);
                } else {
                    httpResponse = new HttpResponseStructure(2, 0, XMLUtil.toString(assignedCascade.getXmlStructure()));
                }
                Database.getInstance(MixInfo.class).update(mixEntry);
            } else {
                LogHolder.log(4, LogType.NET, "Signature check failed for Mix entry! XML: " + new String(a_postData));
                httpResponse = new HttpResponseStructure(500);
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, e);
            httpResponse = new HttpResponseStructure(400);
        }
        return httpResponse;
    }

    private HttpResponseStructure japGetMix(String a_mixId) {
        HttpResponseStructure httpResponse;
        try {
            MixInfo mixEntry = (MixInfo)Database.getInstance(MixInfo.class).getEntryById(a_mixId);
            httpResponse = mixEntry == null ? new HttpResponseStructure(404) : new HttpResponseStructure(2, 0, XMLUtil.toString(mixEntry.getXmlStructure()));
        }
        catch (Exception e) {
            httpResponse = new HttpResponseStructure(500);
            LogHolder.log(3, LogType.NET, e);
        }
        return httpResponse;
    }

    private HttpResponseStructure doDNSQuery(byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(400);
        return httpResponse;
    }

    private HttpResponseStructure doDNSQuery(String a_query) {
        HttpResponseStructure httpResponse = null;
        try {
            String strQName = null;
            String strID = null;
            StringTokenizer st = new StringTokenizer(a_query, "&", false);
            while (st.hasMoreTokens()) {
                String strToken = st.nextToken();
                String strValue = strToken.substring(strToken.indexOf(61) + 1);
                if (strToken.startsWith("QNAME")) {
                    strQName = strValue;
                    continue;
                }
                if (!strToken.startsWith("ID")) continue;
                strID = strValue;
            }
            return this.doDNSQuery(strQName, strID);
        }
        catch (Throwable e) {
            httpResponse = new HttpResponseStructure(500);
            LogHolder.log(3, LogType.NET, e);
            return httpResponse;
        }
    }

    private HttpResponseStructure doDNSQuery(String strQName, String strID) {
        if (strQName == null) {
            return null;
        }
        try {
            InetAddress[] addresses;
            Document doc = XMLUtil.createDocument();
            Element elem = XMLUtil.createChildElement(doc, "DNSResponse");
            elem = XMLUtil.createChildElement(elem, "Responses");
            elem = XMLUtil.createChildElement(elem, "Response");
            elem.setAttribute("ID", strID);
            for (InetAddress address : addresses = InetAddress.getAllByName(strQName)) {
                String strAddress = address.getHostAddress();
                XMLUtil.createChildElementWithValue(elem, "A", strAddress);
            }
            return new HttpResponseStructure(doc);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    private HttpResponseStructure japGetTCTemplate(String a_id) {
        HttpResponseStructure httpResponse;
        try {
            TermsAndConditionsTemplate entry = (TermsAndConditionsTemplate)Database.getInstance(TermsAndConditionsTemplate.class).getEntryById(a_id);
            httpResponse = entry == null ? new HttpResponseStructure(404) : new HttpResponseStructure(2, 0, XMLUtil.toByteArray(entry.getXmlStructure()));
        }
        catch (Exception e) {
            httpResponse = new HttpResponseStructure(500);
            LogHolder.log(3, LogType.NET, e);
        }
        return httpResponse;
    }

    private HttpResponseStructure cascadePostStatus(byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(200);
        try {
            LogHolder.log(7, LogType.NET, "Status received: XML: " + new String(a_postData));
            Element mixCascadeStatusNode = (Element)XMLUtil.getFirstChildByName(XMLUtil.toXMLDocument(a_postData), "MixCascadeStatus");
            StatusInfo statusEntry = new StatusInfo(mixCascadeStatusNode);
            if (statusEntry.isVerified() && statusEntry.isValid()) {
                Database.getInstance(StatusInfo.class).update(statusEntry);
                StatusStatistics.getInstance().update(statusEntry);
            } else {
                LogHolder.log(4, LogType.NET, "Signature check failed for mixcascade status entry! XML: " + new String(a_postData));
                httpResponse = new HttpResponseStructure(500);
            }
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.NET, e);
            httpResponse = new HttpResponseStructure(400);
        }
        return httpResponse;
    }

    private HttpResponseStructure japGetCascadeStatus(String a_cascadeId) {
        ++ISRuntimeStatistics.ms_lNrOfGetMixCascadeStatusRequests;
        HttpResponseStructure httpResponse = null;
        try {
            StatusInfo statusEntry = (StatusInfo)this.m_statusinfoDB.getEntryById(a_cascadeId);
            httpResponse = statusEntry == null ? new HttpResponseStructure(404) : new HttpResponseStructure(2, 0, statusEntry.getPostData());
        }
        catch (Exception e) {
            httpResponse = new HttpResponseStructure(500);
            LogHolder.log(3, LogType.NET, e);
        }
        return httpResponse;
    }

    private HttpResponseStructure postLatestJavaVersions(byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(200);
        try {
            LogHolder.log(7, LogType.NET, "Latest Java versions received. XML: " + new String(a_postData));
            Element node = (Element)XMLUtil.getFirstChildByName(XMLUtil.toXMLDocument(a_postData), "JavaVersion");
            if (SignatureVerifier.getInstance().verifyXml(node, 3)) {
                Database.getInstance(JavaVersionDBEntry.class).update(new JavaVersionDBEntry(node));
                httpResponse = new HttpResponseStructure(200);
            } else {
                LogHolder.log(4, LogType.NET, "Signature check failed for Java version entry! XML: " + XMLUtil.toString(node));
                httpResponse = new HttpResponseStructure(500);
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, e);
            httpResponse = new HttpResponseStructure(400);
        }
        return httpResponse;
    }

    private String getHumanStatusHeader() {
        return "<HTML>\n  <HEAD>\n    <TITLE>JAP - InfoService - Cascade Status</TITLE>\n    <STYLE TYPE=\"text/css\">\n      <!--\n        h1 {color:blue; text-align:center;}\n        b,h3,h4,h5 {font-weight:bold; color:maroon;}\n        body {margin-top:0px; margin-left:5px; background-color:white; color:black;}\n        h1,h2,h3,h4,h5,p,address,ol,ul,tr,td,th,blockquote,body,.smalltext,.leftcol {font-family:geneva,arial,helvetica,sans-serif;}\n        p,address,ol,ul,tr,td,th,blockquote {font-size:11pt;}\n        .leftcol,.smalltext {font-size: 10px;}\n        h1 {font-size:17px;}\n        h2 {font-size:16px;}\n        h3 {font-size:15px;}\n        h4 {font-size:14px;}\n        h5 {font-size:13px;}\n        address {font-style:normal;}\n        hr {color:#cccccc;}\n        h2,.leftcol {font-weight:bold; color:#006699;}\n        a:link {color:#006699; font-weight:normal; text-decoration:none;}\n        a:visited {color:#666666; font-weight:normal; text-decoration:none;}\n        a:active {color:#006699; font-weight:normal; text-decoration:none;}\n        a:hover {color:#006699; font-weight:normal; text-decoration:underline;}\n        th {color:white; background:#006699; font-weight:bold; text-align:left;}\n        td.name {border-bottom-style:solid; border-bottom-width:1pt; border-color:#006699; background:#eeeeff;}\n        td.status {border-bottom-style:solid; border-bottom-width:1pt; border-color:#006699;}\n      -->\n    </STYLE>\n    <META HTTP-EQUIV=\"refresh\" CONTENT=\"25\">\n  </HEAD>\n  <BODY BGCOLOR=\"#FFFFFF\">\n    <P ALIGN=\"right\">" + new Date().toString() + "</P>\n";
    }

    private String getHumanStatusFooter() {
        return "    <P>Infoservice [IS.09.010] Startup Time: " + Configuration.getInstance().getStartupTime() + "</P>\n    <HR noShade SIZE=\"1\">\n    <ADDRESS>&copy; 2000 - 2008 The JAP Team - JonDos GmbH</ADDRESS>\n  </BODY>\n</HTML>\n";
    }

    private HttpResponseStructure humanGetPerfStatus() {
        HttpResponseStructure httpResponse;
        try {
            String htmlData = this.getHumanStatusHeader();
            htmlData = htmlData + "<a href=\"/status\">Go to Server Status</a><br /><br />";
            if (Configuration.getInstance().isPerfEnabled() && InfoService.getPerfMeter() != null) {
                int totalUpdates = InfoService.getPerfMeter().getLastTotalUpdates();
                htmlData = htmlData + "    <table style=\"align: left\" border=\"0\" width=\"30%\"><tr><th colspan=\"2\">Performance Monitoring Enabled</th></tr>\n<tr><td class=\"name\">Proxy host</td><td class=\"status\">" + Configuration.getInstance().getPerformanceMeterConfig()[0] + "</td></tr><tr><td class=\"name\">Proxy port</td><td class=\"status\">" + Configuration.getInstance().getPerformanceMeterConfig()[1] + "<td></tr><tr><td class=\"name\">Datasize</td><td class=\"status\">" + Util.formatBytesValueWithUnit(((Integer)Configuration.getInstance().getPerformanceMeterConfig()[2]).intValue()) + "<td></tr><tr><td class=\"name\">Major interval</td><td class=\"status\">" + Configuration.getInstance().getPerformanceMeterConfig()[3] + " ms<td></tr><tr><td class=\"name\">Requests per interval</td><td class=\"status\">" + Configuration.getInstance().getPerformanceMeterConfig()[4] + "<td></tr><tr><td class=\"name\">Stop requests after</td><td class=\"status\">" + Configuration.getInstance().getPerformanceMeterConfig()[5] + " ms<td></tr><tr><td class=\"name\">Account directory</td><td class=\"status\">" + Configuration.getInstance().getPerfAccountDirectory() + "<td></tr><tr><td class=\"name\">Last successful update</td><td class=\"status\">" + (InfoService.getPerfMeter().getLastSuccessfulUpdate() == 0L ? "(never)" : new Date(InfoService.getPerfMeter().getLastSuccessfulUpdate()).toString()) + "</td></tr><tr><td class=\"name\">Current time</td><td class=\"status\">" + new Date().toString() + "</td></tr><tr><td class=\"name\">Next update attempt</td><td class=\"status\">" + (InfoService.getPerfMeter().getNextUpdate() == 0L ? "(unknown)" : new Date(InfoService.getPerfMeter().getNextUpdate()).toString()) + "</td></tr><tr><td class=\"name\">Last run total updates</td><td class=\"status\">" + totalUpdates + "</td></tr><tr><td class=\"name\">Update runtime / average</td><td class=\"status\">" + InfoService.getPerfMeter().getLastUpdateRuntime() + " ms" + (totalUpdates > 1 ? " / " + InfoService.getPerfMeter().getLastUpdateRuntime() / (long)totalUpdates + " ms" : "") + "</td></tr><tr><td class=\"name\">Last Cascade updated</td><td class=\"status\">" + InfoService.getPerfMeter().getLastCascadeUpdated() + "</td></tr></table><br /><table style=\"align: left\" border=\"0\" width=\"30%\"><tr><td class=\"name\">Accumulated Total Traffic</td><td class=\"status\">" + Util.formatBytesValueWithUnit(InfoService.getPerfMeter().getBytesRecvd()) + "</td></tr></table><br />";
                Vector vPIs = Database.getInstance(PaymentInstanceDBEntry.class).getEntryList();
                for (int i = 0; i < vPIs.size(); ++i) {
                    PaymentInstanceDBEntry pi = (PaymentInstanceDBEntry)vPIs.elementAt(i);
                    htmlData = htmlData + "<h2><a href=\"/paymentinstance/" + pi.getId() + "\">" + pi.getName() + "</a></h2><table style=\"align: left\" border=\"0\" width=\"30%\"><tr><td class=\"name\">Estimated PayTraffic per Day</td><td class=\"status\">" + Util.formatBytesValueWithUnit(InfoService.getPerfMeter().calculatePayTrafficPerDay(pi.getId())) + "</td></tr><tr><td class=\"name\">Remaining PayCredit</td><td class=\"status\">" + Util.formatBytesValueWithUnit(InfoService.getPerfMeter().getRemainingCredit(pi.getId())) + "</td></tr><tr><td class=\"name\">Estimated Pay End Time</td><td class=\"status\">" + (InfoService.getPerfMeter().calculateRemainingPayTime(pi.getId()) == 0L ? "(unknown)" : new Date(InfoService.getPerfMeter().calculateRemainingPayTime(pi.getId())).toString()) + "</td></tr></table><br />";
                }
                if (vPIs.size() == 0) {
                    htmlData = htmlData + "Waiting for PaymentInstance data...<br /><br />";
                }
                htmlData = htmlData + "    <table style=\"align: left\" border=\"0\" width=\"100%\"><tr><th>Account Number</th><th>Remaining</th><th>Monthly</th><th>Account File</th><th>Last Modified</th><th>Payment instance</th></tr>\n";
                Timestamp now = new Timestamp(System.currentTimeMillis());
                if (vPIs.size() != 0) {
                    Hashtable usedFiles = InfoService.getPerfMeter().getUsedAccountFiles();
                    Enumeration keys = usedFiles.keys();
                    while (keys.hasMoreElements()) {
                        File file = (File)keys.nextElement();
                        PayAccount account = (PayAccount)usedFiles.get(file);
                        htmlData = htmlData + "<tr><td class=\"name\">" + account.getAccountNumber() + "</td><td class=\"status\">" + (account.isCharged(now) ? "" + Util.formatBytesValueWithUnit(account.getCurrentCredit()) : "0") + "</td><td class=\"status\">" + (account.getVolumeBytesMonthly() > 0L ? "" + Util.formatBytesValueWithUnit(account.getVolumeBytesMonthly()) : "0") + "</td><td class=\"name\">" + file.getName() + "</td><td class=\"status\">" + new Date(account.getBackupTime()) + "</td><td class=\"name\">" + account.getPIID() + "</td></tr>";
                    }
                }
                htmlData = htmlData + "</table><br />";
            } else {
                htmlData = htmlData + "Performance Monitoring disabled.";
            }
            htmlData = htmlData + this.getHumanStatusFooter();
            httpResponse = new HttpResponseStructure(1, 0, htmlData);
        }
        catch (Exception e) {
            httpResponse = new HttpResponseStructure(500);
            LogHolder.log(3, LogType.MISC, e);
        }
        return httpResponse;
    }

    private HttpResponseStructure humanGetDelayValues(String a_cascadeId, int day) {
        HttpResponseStructure httpResponse;
        try {
            String htmlData = this.getHumanStatusHeader();
            PerformanceEntry entry = (PerformanceEntry)Database.getInstance(PerformanceEntry.class).getEntryById(a_cascadeId);
            htmlData = htmlData + "<a href=\"/status\">Back to Server Status</a><br /><br />";
            htmlData = htmlData + "<b>Delay values</b><br /><br />";
            htmlData = entry == null ? htmlData + "No performance data found." : htmlData + entry.delayToHTML(day);
            htmlData = htmlData + this.getHumanStatusFooter();
            httpResponse = new HttpResponseStructure(1, 0, htmlData);
        }
        catch (Exception e) {
            httpResponse = new HttpResponseStructure(500);
            LogHolder.log(3, LogType.MISC, e);
        }
        return httpResponse;
    }

    private HttpResponseStructure humanGetSpeedValues(String a_cascadeId, int day) {
        HttpResponseStructure httpResponse;
        try {
            String htmlData = this.getHumanStatusHeader();
            PerformanceEntry entry = (PerformanceEntry)Database.getInstance(PerformanceEntry.class).getEntryById(a_cascadeId);
            htmlData = htmlData + "<a href=\"/status\">Back to Server Status</a><br /><br />";
            htmlData = htmlData + "<b>Speed values</b><br /><br />";
            htmlData = entry == null ? htmlData + "No performance data found." : htmlData + entry.speedToHTML(day);
            htmlData = htmlData + this.getHumanStatusFooter();
            httpResponse = new HttpResponseStructure(1, 0, htmlData);
        }
        catch (Exception e) {
            httpResponse = new HttpResponseStructure(500);
            LogHolder.log(3, LogType.MISC, e);
        }
        return httpResponse;
    }

    private HttpResponseStructure humanGetUsersValues(String a_cascadeId, int day) {
        HttpResponseStructure httpResponse;
        try {
            String htmlData = this.getHumanStatusHeader();
            PerformanceEntry entry = (PerformanceEntry)Database.getInstance(PerformanceEntry.class).getEntryById(a_cascadeId);
            htmlData = htmlData + "<a href=\"/status\">Back to Server Status</a><br /><br />";
            htmlData = htmlData + "<b>User numbers</b><br /><br />";
            htmlData = entry == null ? htmlData + "No performance data found." : htmlData + entry.usersToHTML(day);
            htmlData = htmlData + this.getHumanStatusFooter();
            httpResponse = new HttpResponseStructure(1, 0, htmlData);
        }
        catch (Exception e) {
            httpResponse = new HttpResponseStructure(500);
            LogHolder.log(3, LogType.MISC, e);
        }
        return httpResponse;
    }

    private HttpResponseStructure humanGetStatus() {
        HttpResponseStructure httpResponse;
        try {
            Vector infoservices;
            String htmlData = this.getHumanStatusHeader();
            htmlData = htmlData + "    <H2>InfoService Status (" + Configuration.getInstance().getID() + ")</H2>\n    <P>InfoService Name: " + Configuration.getInstance().getOwnName() + "<BR></P>\n";
            htmlData = htmlData + "    <TABLE BORDER=\"0\">\n      <COLGROUP>\n        <COL WIDTH=\"20%\">\n        <COL WIDTH=\"15%\">\n        <COL WIDTH=\"10%\">\n        <COL WIDTH=\"10%\">\n" + (Configuration.getInstance().isPassive() && !Configuration.getInstance().isPerfEnabled() ? "        <COL WIDTH=\"10%\">\n        <COL WIDTH=\"10%\">\n        <COL WIDTH=\"10%\">\n" : "        <COL WIDTH=\"15%\">\n        <COL WIDTH=\"15%\">\n        <COL WIDTH=\"5%\">\n") + "        <COL WIDTH=\"5%\">\n      </COLGROUP>\n      <TR>\n        <TH>Cascade Name</TH>\n        <TH>Cascade ID</TH>\n        <TH>Active Users</TH>\n        <TH>Traffic Situation</TH>\n" + (Configuration.getInstance().isPassive() && !Configuration.getInstance().isPerfEnabled() ? "        <TH>Delay Bound</TH>\n" : "        <TH>Delay (Avg) [Bound]</TH>\n") + (Configuration.getInstance().isPassive() && !Configuration.getInstance().isPerfEnabled() ? "        <TH>Speed Bound</TH>\n" : "        <TH>Speed (Avg) [Bound]</TH>\n") + "        <TH>Mixed Packets</TH>\n        <TH>Last Notification</TH>\n      </TR>\n";
            Hashtable hashStatusInfo = Database.getInstance(StatusInfo.class).getEntryHash();
            Enumeration enumCascades = Database.getInstance(MixCascade.class).getEntrySnapshotAsEnumeration();
            while (enumCascades.hasMoreElements()) {
                MixCascade cascade = (MixCascade)enumCascades.nextElement();
                if (hashStatusInfo.containsKey(cascade.getId())) continue;
                hashStatusInfo.put(cascade.getId(), StatusInfo.createDummyStatusInfo(cascade.getId()));
            }
            Enumeration enumer = hashStatusInfo.elements();
            while (enumer.hasMoreElements()) {
                StatusInfo info = (StatusInfo)enumer.nextElement();
                htmlData = htmlData + "      " + info.getHtmlTableLine(Configuration.getInstance().isPassive() && !Configuration.getInstance().isPerfEnabled()) + "\n";
            }
            htmlData = htmlData + "    </TABLE><BR>";
            htmlData = htmlData + "<a href=\"" + "/cascadewebinfos" + "\">List available Mixes</a>";
            if (Configuration.getInstance().isPassive()) {
                htmlData = !Configuration.getInstance().isPerfEnabled() ? htmlData + "<p><b>This Info Service is passive and only collects and combines the more detailed information from other Info Services.</b></p>\n" : htmlData + "<p><b>This Info Service is passive: it does performance tests, but does not forward any data to other Info Services.</b></p>\n";
            }
            if ((infoservices = Database.getInstance(InfoServiceDBEntry.class).getEntryList()).size() > 0) {
                htmlData = htmlData + "<H2>Available active Info Services:</H2>\n";
                for (int i = 0; i < infoservices.size(); ++i) {
                    Vector interfaces;
                    InfoServiceDBEntry entry = (InfoServiceDBEntry)infoservices.elementAt(i);
                    if (entry.isBootstrap() || (interfaces = entry.getListenerInterfaces()).size() == 0) continue;
                    ListenerInterface listener = null;
                    for (int j = 0; j < interfaces.size(); ++j) {
                        if (((ListenerInterface)interfaces.elementAt(j)).getPort() != 80) continue;
                        listener = (ListenerInterface)interfaces.elementAt(j);
                    }
                    if (listener == null) {
                        listener = (ListenerInterface)interfaces.elementAt(0);
                    }
                    htmlData = htmlData + "<a href=\"http://" + listener.getHost() + ":" + listener.getPort() + "/status\">" + entry.getName() + "</a><br>\n";
                }
                htmlData = htmlData + "<br>\n";
            }
            if (Configuration.getInstance().isPerfEnabled() && InfoService.getPerfMeter() != null) {
                htmlData = htmlData + "<a href=\"/perfstatus\">Performance Monitoring enabled</a>";
            }
            htmlData = htmlData + "<BR>\n" + ISRuntimeStatistics.getAsHTML();
            htmlData = htmlData + this.getHumanStatusFooter();
            httpResponse = new HttpResponseStructure(1, 0, htmlData);
        }
        catch (Exception e) {
            httpResponse = new HttpResponseStructure(500);
            LogHolder.log(3, LogType.MISC, e);
        }
        return httpResponse;
    }

    private HttpResponseStructure infoServiceIndexPage() {
        String htmlData = "<HTML>\n  <HEAD>\n    <TITLE>InfoService</TITLE>\n    <STYLE TYPE=\"text/css\">\n      <!--\n        h1 {color:blue; text-align:center;}\n        b,h3,h4,h5 {font-weight:bold; color:maroon;}\n        body {margin-top:0px; margin-left:5px; background-color:white; color:black;}\n        h1,h2,h3,h4,h5,p,address,ol,ul,tr,td,th,blockquote,body,.smalltext,.leftcol {font-family:geneva,arial,helvetica,sans-serif;}\n        p,address,ol,ul,tr,td,th,blockquote {font-size:11pt;}\n        .leftcol,.smalltext {font-size: 10px;}\n        h1 {font-size:17px;}\n        h2 {font-size:16px;}\n        h3 {font-size:15px;}\n        h4 {font-size:14px;}\n        h5 {font-size:13px;}\n        address {font-style:normal;}\n        hr {color:#cccccc;}\n        h2,.leftcol {font-weight:bold; color:#006699;}\n        a:link {color:#006699; font-weight:normal; text-decoration:none;}\n        a:visited {color:#666666; font-weight:normal; text-decoration:none;}\n        a:active {color:#006699; font-weight:normal; text-decoration:none;}\n        a:hover {color:#006699; font-weight:normal; text-decoration:underline;}\n        th {color:white; background:#006699; font-weight:bold; text-align:left;}\n        td.name {border-bottom-style:solid; border-bottom-width:1pt; border-color:#006699; background:#eeeeff;}\n        td.status {border-bottom-style:solid; border-bottom-width:1pt; border-color:#006699;}\n      -->\n    </STYLE>\n    <META HTTP-EQUIV=\"refresh\" CONTENT=\"25\">\n  </HEAD>\n  <BODY BGCOLOR=\"#FFFFFF\">\n    <P ALIGN=\"right\">" + new Date().toString() + "</P>\n";
        htmlData = htmlData + "    <H2>InfoService Name: " + Configuration.getInstance().getOwnName() + "</H2>\n    <P>Infoservice [" + "IS.09.010" + "] Startup Time: " + Configuration.getInstance().getStartupTime() + "</P>\n   <P>This is an InfoService for AN.ON/JonDonym technology networks.<br>\n   It is a distributed storage for network information and does not harm anyone.<br>\n   If you do not want your computer contacting it, please stop using AN.ON/JonDonym software and services.\n    <HR noShade SIZE=\"1\">\n    <ADDRESS>&copy; 2000 - 2008 The JAP Team - JonDos GmbH</ADDRESS>\n  </BODY>\n</HTML>\n";
        HttpResponseStructure httpResponse = new HttpResponseStructure(1, 0, htmlData);
        return httpResponse;
    }

    private HttpResponseStructure fetchAllMixes() {
        HttpResponseStructure httpResponse;
        try {
            Document doc = XMLUtil.createDocument();
            Element mixesNode = doc.createElement("Mixes");
            Enumeration knownMixes = Database.getInstance(MixInfo.class).getEntrySnapshotAsEnumeration();
            while (knownMixes.hasMoreElements()) {
                MixInfo mixInfo = (MixInfo)knownMixes.nextElement();
                Element mixNode = mixInfo.getXmlStructure();
                if (mixNode == null) {
                    String hostName = "unknown";
                    try {
                        hostName = mixInfo.getFirstHostName();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    LogHolder.log(0, LogType.MISC, "Mix node XML is null for Mix " + mixInfo.getId() + " (" + mixInfo.getName() + ")! Hostname: " + hostName + " Operator: " + mixInfo.getServiceOperator().getOrganization() + ", " + mixInfo.getServiceOperator().getEMail());
                    continue;
                }
                mixNode = (Element)XMLUtil.importNode(doc, mixNode, true);
                mixesNode.appendChild(mixNode);
            }
            SignatureCreator.getInstance().signXml(2, mixesNode);
            doc.appendChild(mixesNode);
            httpResponse = new HttpResponseStructure(doc);
        }
        catch (Exception e) {
            httpResponse = new HttpResponseStructure(500);
            LogHolder.log(3, LogType.MISC, e);
        }
        return httpResponse;
    }

    private HttpResponseStructure fetchAvailableMixes() {
        HttpResponseStructure httpResponse;
        try {
            Document doc = XMLUtil.createDocument();
            Element mixesNode = doc.createElement("Mixes");
            Enumeration knownMixes = Database.getInstance(MixInfo.class).getEntrySnapshotAsEnumeration();
            while (knownMixes.hasMoreElements()) {
                MixInfo mixEntry = (MixInfo)knownMixes.nextElement();
                if (!mixEntry.isFreeMix()) continue;
                Element mixNode = (Element)XMLUtil.importNode(doc, mixEntry.getXmlStructure(), true);
                mixesNode.appendChild(mixNode);
            }
            doc.appendChild(mixesNode);
            httpResponse = new HttpResponseStructure(doc);
        }
        catch (Exception e) {
            httpResponse = new HttpResponseStructure(500);
            LogHolder.log(3, LogType.MISC, e);
        }
        return httpResponse;
    }

    private HttpResponseStructure getCascadeInfo(int a_supportedEncodings, String a_cascadeId) {
        HttpResponseStructure httpResponse;
        try {
            MixCascade mixCascadeEntry = (MixCascade)Database.getInstance(MixCascade.class).getEntryById(a_cascadeId);
            httpResponse = mixCascadeEntry == null ? new HttpResponseStructure(404) : ((a_supportedEncodings & 1) > 0 ? new HttpResponseStructure(2, 1, mixCascadeEntry.getCompressedData()) : new HttpResponseStructure(2, 0, XMLUtil.toString(mixCascadeEntry.getXmlStructure())));
        }
        catch (Exception e) {
            httpResponse = new HttpResponseStructure(500);
            LogHolder.log(3, LogType.MISC, e);
        }
        return httpResponse;
    }

    private HttpResponseStructure getInfoServiceInfo(String a_infoserviceId) {
        HttpResponseStructure httpResponse;
        try {
            InfoServiceDBEntry infoserviceEntry = (InfoServiceDBEntry)Database.getInstance(InfoServiceDBEntry.class).getEntryById(a_infoserviceId);
            httpResponse = infoserviceEntry == null ? new HttpResponseStructure(404) : new HttpResponseStructure(2, 0, XMLUtil.toString(infoserviceEntry.getXmlStructure()));
        }
        catch (Exception e) {
            httpResponse = new HttpResponseStructure(500);
            LogHolder.log(3, LogType.MISC, e);
        }
        return httpResponse;
    }

    private HttpResponseStructure echoIP(InetAddress a_sourceAddress) {
        Document docEchoIP = XMLUtil.createDocument();
        Element nodeEchoIP = docEchoIP.createElement("EchoIP");
        Element nodeIP = docEchoIP.createElement("IP");
        docEchoIP.appendChild(nodeEchoIP);
        nodeEchoIP.appendChild(nodeIP);
        SignatureCreator.getInstance().signXml(2, nodeEchoIP);
        XMLUtil.setValue((Node)nodeIP, a_sourceAddress.getHostAddress());
        HttpResponseStructure httpResponse = new HttpResponseStructure(2, 0, XMLUtil.toString(docEchoIP));
        return httpResponse;
    }

    private HttpResponseStructure getTorNodesList(int a_supportedEncodings) {
        int encoding;
        ++ISRuntimeStatistics.ms_lNrOfGetTorNodesRequests;
        HttpResponseStructure httpResponse = null;
        byte[] torNodesList = null;
        if ((a_supportedEncodings & 1) > 0) {
            encoding = 1;
            torNodesList = TorDirectoryAgent.getInstance().getCompressedTorNodesList();
        } else {
            encoding = 0;
            torNodesList = TorDirectoryAgent.getInstance().getTorNodesList();
        }
        if (torNodesList != null) {
            try {
                httpResponse = new HttpResponseStructure(0, encoding, torNodesList);
            }
            catch (Exception e) {
                LogHolder.log(3, LogType.MISC, e);
                httpResponse = new HttpResponseStructure(500);
            }
        } else {
            httpResponse = new HttpResponseStructure(500);
        }
        return httpResponse;
    }

    private HttpResponseStructure getMixminionNodesList() {
        HttpResponseStructure httpResponse = null;
        byte[] mixminionNodesList = null;
        mixminionNodesList = MixminionDirectoryAgent.getInstance().getMixminionNodesList();
        if (mixminionNodesList != null) {
            try {
                httpResponse = new HttpResponseStructure(0, 2, mixminionNodesList);
            }
            catch (Exception e) {
                LogHolder.log(3, LogType.MISC, e);
                httpResponse = new HttpResponseStructure(500);
            }
        } else {
            httpResponse = new HttpResponseStructure(500);
        }
        return httpResponse;
    }

    private HttpResponseStructure addJapForwarder(byte[] a_postData, InetAddress a_sourceAddress) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(400);
        String answer = JapForwardingTools.addForwarder(a_postData, a_sourceAddress);
        if (answer != null) {
            httpResponse = new HttpResponseStructure(2, 0, answer);
        }
        return httpResponse;
    }

    private HttpResponseStructure renewJapForwarder(byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(400);
        String answer = JapForwardingTools.renewForwarder(a_postData);
        if (answer != null) {
            httpResponse = new HttpResponseStructure(2, 0, answer);
        }
        return httpResponse;
    }

    private HttpResponseStructure getJapForwarder() {
        HttpResponseStructure httpResponse = new HttpResponseStructure(500);
        String answer = JapForwardingTools.getForwarder();
        if (answer != null) {
            httpResponse = new HttpResponseStructure(2, 0, answer);
        }
        return httpResponse;
    }

    private HttpResponseStructure japPostCurrentJapVersion(byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(200);
        try {
            LogHolder.log(7, LogType.NET, "JAPMinVersion received: XML: " + new String(a_postData));
            Element japNode = (Element)XMLUtil.getFirstChildByName(XMLUtil.toXMLDocument(a_postData), JAPMinVersion.getXmlElementName());
            if (SignatureVerifier.getInstance().verifyXml(japNode, 3)) {
                JAPMinVersion minVersionEntry = new JAPMinVersion(japNode);
                Database.getInstance(JAPMinVersion.class).update(minVersionEntry);
            } else {
                LogHolder.log(4, LogType.NET, "Signature check failed for JAPMinVersion entry! XML: " + new String(a_postData));
                httpResponse = new HttpResponseStructure(500);
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, e);
            httpResponse = new HttpResponseStructure(400);
        }
        return httpResponse;
    }

    private HttpResponseStructure japGetCurrentJapVersion() {
        JAPMinVersion minVersionEntry;
        ++ISRuntimeStatistics.ms_lNrOfGetMinJapVersion;
        HttpResponseStructure httpResponse = null;
        JAPMinVersion oldMinVersion = Configuration.getInstance().getJapMinVersionOld();
        double updatePropability = Configuration.getInstance().getJapUpdatePropability();
        httpResponse = oldMinVersion != null && updatePropability < 1.0 && this.m_Random.nextDouble() >= updatePropability ? new HttpResponseStructure(2, 0, oldMinVersion.getPostData()) : ((minVersionEntry = (JAPMinVersion)Database.getInstance(JAPMinVersion.class).getEntryById("JAPMinVersion")) != null ? new HttpResponseStructure(2, 0, minVersionEntry.getPostData()) : new HttpResponseStructure(404));
        return httpResponse;
    }

    private HttpResponseStructure postJnlpFile(String a_fileName, byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(200);
        try {
            LogHolder.log(7, LogType.NET, "JNLP file received (" + a_fileName + "): XML: " + new String(a_postData));
            Element jnlpNode = (Element)XMLUtil.getFirstChildByName(XMLUtil.toXMLDocument(a_postData), JAPVersionInfo.getXmlElementName());
            if (SignatureVerifier.getInstance().verifyXml(jnlpNode, 3)) {
                JAPVersionInfo jnlpEntry = null;
                if (a_fileName.equals("/japRelease.jnlp")) {
                    jnlpEntry = new JAPVersionInfo(jnlpNode, 1);
                } else if (a_fileName.equals("/japDevelopment.jnlp")) {
                    jnlpEntry = new JAPVersionInfo(jnlpNode, 2);
                } else {
                    throw new Exception("InfoServiceCommands: postJnlpFile: Invalid filename specified (" + a_fileName + ").");
                }
                Database.getInstance(JAPVersionInfo.class).update(jnlpEntry);
            } else {
                LogHolder.log(4, LogType.NET, "Signature check failed for JNLP file! XML: " + new String(a_postData));
                httpResponse = new HttpResponseStructure(500);
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, e);
            httpResponse = new HttpResponseStructure(400);
        }
        return httpResponse;
    }

    private HttpResponseStructure getJnlpFile(String a_fileName, int a_httpMethod) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(404);
        JAPVersionInfo jnlpFile = (JAPVersionInfo)Database.getInstance(JAPVersionInfo.class).getEntryById(a_fileName);
        if (jnlpFile != null) {
            httpResponse = a_httpMethod == 1 ? new HttpResponseStructure(10, 0, XMLUtil.toString(jnlpFile.getXmlStructure())) : (a_httpMethod == 3 ? new HttpResponseStructure(10, 0, XMLUtil.toString(jnlpFile.getXmlStructure()), true) : new HttpResponseStructure(400));
        }
        return httpResponse;
    }

    private HttpResponseStructure postANONAddress(String id, byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(200);
        try {
            Document doc = XMLUtil.toXMLDocument(a_postData);
            Element elemANONAddress = (Element)XMLUtil.getFirstChildByName(doc, ANONAddress.getXmlElementName());
            ANONAddress anonaddress = new ANONAddress(id, elemANONAddress);
            Database.getInstance(ANONAddress.class).update(anonaddress);
        }
        catch (Throwable e) {
            LogHolder.log(3, LogType.NET, e);
            httpResponse = new HttpResponseStructure(400);
        }
        return httpResponse;
    }

    private HttpResponseStructure getANONAddress(String id) {
        HttpResponseStructure httpResponse = null;
        ANONAddress addr = (ANONAddress)Database.getInstance(ANONAddress.class).getEntryById(id);
        httpResponse = addr != null ? new HttpResponseStructure(2, 0, addr.getPostData()) : new HttpResponseStructure(404);
        return httpResponse;
    }

    @Override
    public HttpResponseStructure processCommand(int method, int a_supportedEncodings, String command, byte[] postData, InetAddress a_sourceAddress) {
        if (method == 2) {
            ++ISRuntimeStatistics.ms_lNrOfPosts;
        } else if (method == 1) {
            ++ISRuntimeStatistics.ms_lNrOfGets;
        } else {
            ++ISRuntimeStatistics.ms_lNrOfOtherMethod;
        }
        HttpResponseStructure httpResponse = null;
        if (command.startsWith("/mixcascadestatus/") && method == 1) {
            String cascadeId = command.substring(18);
            httpResponse = this.japGetCascadeStatus(cascadeId);
        } else if (command.equals("/infoservice") && method == 2) {
            httpResponse = this.infoServerPostHelo(postData);
        } else if (command.startsWith("/infoservice/") && method == 1) {
            String infoserviceId = command.substring(13);
            httpResponse = this.getInfoServiceInfo(infoserviceId);
        } else if ((command.equals("/infoservices") || command.equals("/infoservices/")) && method == 1) {
            ++ISRuntimeStatistics.ms_lNrOfGetInfoservicesRequests;
            httpResponse = this.m_isResponseGetter.fetchResponse(a_supportedEncodings, false);
        } else if (command.equals("/infoserviceserials") && method == 1) {
            ++ISRuntimeStatistics.ms_lNrOfGetInfoserviceserialsRequests;
            httpResponse = this.m_isResponseGetter.fetchResponse(a_supportedEncodings, true);
        } else if (command.equals("/robots.txt") && method == 1) {
            String txtData = "User-agent: *\nDisallow: /";
            httpResponse = new HttpResponseStructure(0, 0, txtData);
        } else if (command.equals("/favicon.ico") && method == 1) {
            httpResponse = new HttpResponseStructure(404);
        } else if (command.equals("/cascade") && method == 2) {
            httpResponse = DynamicCommandsExtension.cascadePostHelo(postData, a_supportedEncodings);
        } else if (command.equals("/cascadeserials") && method == 1) {
            ++ISRuntimeStatistics.ms_lNrOfGetCascadeserialsRequests;
            httpResponse = this.m_cascadeResponseGetter.fetchResponse(a_supportedEncodings, true);
        } else if (command.startsWith("/cascades") && method == 1) {
            ++ISRuntimeStatistics.ms_lNrOfGetCascadesRequests;
            httpResponse = this.m_cascadeResponseGetter.fetchResponse(a_supportedEncodings, false);
        } else if (command.startsWith("/performanceinfo") && method == 1) {
            ++ISRuntimeStatistics.ms_lNrOfPerformanceInfoRequests;
            httpResponse = this.m_performanceResponseGetter.fetchResponse(a_supportedEncodings, false);
        } else if (command.startsWith("/exitaddresses") && method == 1) {
            httpResponse = this.m_exitAddressListResponseGetter.fetchResponse(a_supportedEncodings, false);
        } else if (command.startsWith("/cascadewebinfos") && method == 1) {
            httpResponse = this.m_cascadeWebInfoResponseGetter.fetchResponse(a_supportedEncodings, false);
        } else if (command.startsWith("/cascadewebinfo/") && method == 1) {
            String cascadeID = command.substring("/cascadewebinfo/".length());
            Document doc = Database.getInstance(MixCascade.class).getWebInfos(cascadeID);
            httpResponse = doc == null ? new HttpResponseStructure(400) : new HttpResponseStructure(doc);
        } else if (command.equals("/helo") && method == 2) {
            httpResponse = this.mixPostHelo(postData);
        } else if (command.equals("/configure") && method == 2) {
            httpResponse = this.mixPostConfigure(postData);
        } else if (command.startsWith("/mixinfo/") && method == 1) {
            ++ISRuntimeStatistics.ms_lNrOfGetMixinfoRequests;
            String mixId = command.substring(9);
            httpResponse = this.japGetMix(mixId);
        } else if (command.equals("/feedback") && method == 2) {
            httpResponse = this.cascadePostStatus(postData);
        } else if (command.equals("/tctemplateserials") && method == 1) {
            httpResponse = this.m_tcTemplatesResponseGetter.fetchResponse(a_supportedEncodings, true);
        } else if (command.equals("/tctemplates") && method == 1) {
            httpResponse = this.m_tcTemplatesResponseGetter.fetchResponse(a_supportedEncodings, false);
        } else if (command.startsWith("/tctemplate/") && method == 1) {
            httpResponse = this.japGetTCTemplate(command.substring("/tctemplate/".length()));
        } else if (command.startsWith("/status") && method == 1) {
            ++ISRuntimeStatistics.ms_lNrOfGetStatus;
            httpResponse = this.humanGetStatus();
        } else if (command.equals("/") && method == 1) {
            ++ISRuntimeStatistics.ms_lNrOfGetStatus;
            httpResponse = this.infoServiceIndexPage();
        } else if (command.startsWith("/perfstatus") && method == 1) {
            httpResponse = this.humanGetPerfStatus();
        } else if (command.startsWith("/values") && method == 1) {
            StringTokenizer t = new StringTokenizer(command.substring(7), "/");
            String cascadeId = null;
            String entry = null;
            int day = Calendar.getInstance().get(7);
            if (t.hasMoreTokens()) {
                entry = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                cascadeId = t.nextToken();
            }
            if (t.hasMoreTokens()) {
                try {
                    day = Integer.parseInt(t.nextToken());
                }
                catch (NumberFormatException ex) {
                    day = -1;
                }
            }
            httpResponse = entry.equals("delay") && cascadeId != null && day >= 0 && day <= 7 ? this.humanGetDelayValues(cascadeId, day) : (entry.equals("speed") && cascadeId != null && day >= 0 && day <= 7 ? this.humanGetSpeedValues(cascadeId, day) : (entry.equals("users") && cascadeId != null && day >= 0 && day <= 7 ? this.humanGetUsersValues(cascadeId, day) : new HttpResponseStructure(404)));
        } else if (command.startsWith("/mixes") && method == 1) {
            httpResponse = this.fetchAllMixes();
        } else if (command.startsWith("/availablemixes") && method == 1) {
            httpResponse = this.fetchAvailableMixes();
        } else if (command.equals("/messages") && method == 1) {
            httpResponse = this.m_messageResponseGetter.fetchResponse(a_supportedEncodings, false);
        } else if (command.equals("/messageserials") && method == 1) {
            httpResponse = this.m_messageResponseGetter.fetchResponse(a_supportedEncodings, true);
        } else if (command.equals("/message") && method == 2) {
            httpResponse = this.messagePost(postData, a_supportedEncodings);
        } else if (command.startsWith("/cascadeinfo/") && method == 1) {
            ++ISRuntimeStatistics.ms_lNrOfGetCascadeinfoRequests;
            String cascadeId = command.substring(13);
            httpResponse = this.getCascadeInfo(a_supportedEncodings, cascadeId);
        } else if (command.equals("/tornodes") && method == 1) {
            httpResponse = this.getTorNodesList(a_supportedEncodings);
        } else if (command.equals("/mixminionnodes") && method == 1) {
            httpResponse = this.getMixminionNodesList();
        } else if (command.equals("/addforwarder") && method == 2) {
            ++ISRuntimeStatistics.ms_lNrOfGetForwarding;
            httpResponse = this.addJapForwarder(postData, a_sourceAddress);
        } else if (command.equals("/renewforwarder") && method == 2) {
            ++ISRuntimeStatistics.ms_lNrOfGetForwarding;
            httpResponse = this.renewJapForwarder(postData);
        } else if (command.equals("/getforwarder") && method == 1) {
            ++ISRuntimeStatistics.ms_lNrOfGetForwarding;
            httpResponse = this.getJapForwarder();
        } else if (command.equals("/currentjavaversion")) {
            if (method == 1) {
                httpResponse = this.m_javaVersionResponseGetter.fetchResponse(a_supportedEncodings, false);
            } else if (method == 2) {
                httpResponse = this.postLatestJavaVersions(postData);
            }
        } else if (command.equals("/currentjavaversionSerials")) {
            httpResponse = this.m_javaVersionResponseGetter.fetchResponse(a_supportedEncodings, true);
        } else if (command.equals("/currentjapversion") && method == 2) {
            httpResponse = this.japPostCurrentJapVersion(postData);
        } else if (command.equals("/currentjapversion") && method == 1) {
            httpResponse = this.japGetCurrentJapVersion();
        } else if ((command.equals("/japRelease.jnlp") || command.equals("/japDevelopment.jnlp")) && method == 2) {
            httpResponse = this.postJnlpFile(command, postData);
        } else if ((command.equals("/japRelease.jnlp") || command.equals("/japDevelopment.jnlp")) && (method == 1 || method == 3)) {
            httpResponse = this.getJnlpFile(command, method);
        } else if (command.startsWith("/echoip") && (method == 1 || method == 3)) {
            httpResponse = this.echoIP(a_sourceAddress);
        } else if (command.equals("/paymentinstance") && method == 2) {
            ++ISRuntimeStatistics.ms_lNrOfGetPaymentRequests;
            httpResponse = this.paymentInstancePostHelo(postData);
        } else if (command.startsWith("/paymentinstances") && method == 1) {
            ++ISRuntimeStatistics.ms_lNrOfGetPaymentRequests;
            httpResponse = this.japFetchPaymentInstances();
        } else if (command.startsWith("/paymentinstance/") && method == 1) {
            ++ISRuntimeStatistics.ms_lNrOfGetPaymentRequests;
            String piID = command.substring(17);
            httpResponse = this.japFetchPaymentInstanceInfo(piID);
        } else if (command.startsWith("/connectivity") && method == 2) {
            httpResponse = this.m_dynamicExtension != null ? this.m_dynamicExtension.mixPostConnectivityTest(a_sourceAddress, postData) : new HttpResponseStructure(202);
        } else if (command.startsWith("/dynacascade") && method == 2) {
            httpResponse = this.m_dynamicExtension != null ? this.m_dynamicExtension.lastMixPostDynaCascade(postData) : new HttpResponseStructure(202);
        } else if (command.startsWith("/newcascadeinformationavailable/") && method == 1) {
            String piID = command.substring(32);
            httpResponse = this.m_dynamicExtension != null ? this.m_dynamicExtension.isNewCascadeAvailable(piID) : new HttpResponseStructure(202);
        } else if (command.startsWith("/reconfigure/") && method == 1) {
            String piID = command.substring(13);
            httpResponse = this.m_dynamicExtension != null ? this.m_dynamicExtension.reconfigureMix(piID) : new HttpResponseStructure(202);
        } else if (command.startsWith("/agreement") && method == 2) {
            httpResponse = this.m_agreementAdapter != null ? this.m_agreementAdapter.handleMessage(postData) : new HttpResponseStructure(202);
        } else if (command.startsWith("/startagreement") && method == 1) {
            if (this.m_agreementAdapter != null) {
                this.m_agreementAdapter.startProtocolByOperator();
                httpResponse = new HttpResponseStructure(200);
            } else {
                httpResponse = new HttpResponseStructure(202);
            }
        } else if (command.startsWith("/virtualcascades") && method == 1) {
            httpResponse = this.m_dynamicExtension != null ? this.m_dynamicExtension.virtualCascadeStatus() : new HttpResponseStructure(202);
        } else if (command.startsWith("/requestperformancetoken") && method == 2) {
            httpResponse = this.m_perfRequestHandler.handlePerformanceTokenRequest(postData);
        } else if (command.startsWith("/requestperformance") && method == 2) {
            httpResponse = this.m_perfRequestHandler.handlePerformanceRequest(a_sourceAddress, postData);
        } else if (command.startsWith("/dnsquery")) {
            if (method == 1) {
                String query = command.substring(10);
                httpResponse = this.doDNSQuery(query);
            } else if (method == 2) {
                httpResponse = this.doDNSQuery(postData);
            }
        } else if (command.startsWith("/anonaddress/")) {
            String id = command.substring(13);
            if (method == 1) {
                httpResponse = this.getANONAddress(id);
            } else if (method == 2) {
                httpResponse = this.postANONAddress(id, postData);
            }
        } else {
            ++ISRuntimeStatistics.ms_lNrOfUnknownRequests;
        }
        return httpResponse;
    }
}

