/*
 * Decompiled with CFR 0.152.
 */
package infoservice;

import anon.crypto.CertPath;
import anon.crypto.SignatureVerifier;
import anon.infoservice.Database;
import anon.infoservice.DatabaseMessage;
import anon.infoservice.MixCascade;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class CertificateManager
implements Observer {
    private Hashtable m_certificateLocks = new Hashtable();

    public CertificateManager() {
        Database.getInstance(MixCascade.class).addObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable a_observedObject, Object a_message) {
        try {
            if (a_observedObject == Database.getInstance(MixCascade.class)) {
                DatabaseMessage message = (DatabaseMessage)a_message;
                switch (message.getMessageCode()) {
                    case 1: {
                        this.updateEntry((MixCascade)message.getMessageData());
                        break;
                    }
                    case 2: {
                        this.updateEntry((MixCascade)message.getMessageData());
                        break;
                    }
                    case 3: {
                        this.removeEntry((MixCascade)message.getMessageData());
                        break;
                    }
                    case 4: {
                        Hashtable hashtable = this.m_certificateLocks;
                        synchronized (hashtable) {
                            Enumeration allLocks = this.m_certificateLocks.keys();
                            while (allLocks.hasMoreElements()) {
                                this.removeEntry((MixCascade)allLocks.nextElement());
                            }
                            break;
                        }
                    }
                    case 5: {
                        Hashtable hashtable = this.m_certificateLocks;
                        synchronized (hashtable) {
                            Enumeration allEntries = ((Vector)message.getMessageData()).elements();
                            while (allEntries.hasMoreElements()) {
                                this.updateEntry((MixCascade)allEntries.nextElement());
                            }
                            break;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEntry(MixCascade a_newEntry) {
        Hashtable hashtable = this.m_certificateLocks;
        synchronized (hashtable) {
            CertPath newCertificate = a_newEntry.getCertPath().getFirstVerifiedPath();
            Integer oldEntryCertificateLock = null;
            boolean removeCertificateLock = false;
            if (newCertificate != null) {
                int newCertificateLock = SignatureVerifier.getInstance().getVerificationCertificateStore().addCertificateWithVerification(newCertificate, 2, false);
                if (newCertificateLock != -1) {
                    oldEntryCertificateLock = this.m_certificateLocks.put(a_newEntry, new Integer(newCertificateLock));
                    if (oldEntryCertificateLock != null) {
                        LogHolder.log(7, LogType.MISC, "The lock on the certificate of the MixCascade '" + a_newEntry.getId() + "' was updated in the certificate store.");
                    } else {
                        LogHolder.log(7, LogType.MISC, "The lock on the certificate of the MixCascade '" + a_newEntry.getId() + "' was added to the certificate store.");
                    }
                } else {
                    removeCertificateLock = true;
                }
            } else {
                removeCertificateLock = true;
            }
            if (removeCertificateLock && (oldEntryCertificateLock = (Integer)this.m_certificateLocks.remove(a_newEntry)) != null) {
                LogHolder.log(7, LogType.MISC, "CertificateManager: updateEntry: The lock on the certificate of the MixCascade '" + a_newEntry.getId() + "' was removed from the certificate store. Cannot add the certificate from the updated MixCascade entry.");
            }
            if (oldEntryCertificateLock != null) {
                SignatureVerifier.getInstance().getVerificationCertificateStore().removeCertificateLock(oldEntryCertificateLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEntry(MixCascade a_entryToRemove) {
        Hashtable hashtable = this.m_certificateLocks;
        synchronized (hashtable) {
            Integer certificateLock = (Integer)this.m_certificateLocks.remove(a_entryToRemove);
            if (certificateLock != null) {
                SignatureVerifier.getInstance().getVerificationCertificateStore().removeCertificateLock(certificateLock);
                LogHolder.log(7, LogType.MISC, "CertificateManager: removeEntry: The lock on the certificate of the MixCascade '" + a_entryToRemove.getId() + "' was removed from the certificate store.");
            }
        }
    }
}

