/*
 * Decompiled with CFR 0.152.
 */
package anon.pay;

import anon.crypto.IVerifyable;
import anon.crypto.JAPCertificate;
import anon.crypto.MultiCertPath;
import anon.crypto.SignatureCreator;
import anon.crypto.SignatureVerifier;
import anon.crypto.XMLSignature;
import anon.infoservice.AbstractDistributableCertifiedDatabaseEntry;
import anon.infoservice.ListenerInterface;
import anon.infoservice.ServiceSoftware;
import anon.pay.PayAccountsFile;
import anon.util.JAPMessages;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PaymentInstanceDBEntry
extends AbstractDistributableCertifiedDatabaseEntry
implements IVerifyable {
    public static final String XML_ELEMENT_NAME = "PaymentInstance";
    public static final String XML_ELEMENT_CONTAINER_NAME = "PaymentInstances";
    private static final String MSG_TEST_NAME = (class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = PaymentInstanceDBEntry.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry).getName() + ".testInstanceAlternativeName";
    private static final String XML_ELEM_NAME = "Name";
    private static final String XML_ELEM_CERT = "Certificate";
    private static final String XML_ELEM_NET = "Network";
    private static final String XML_ELEM_WEBSHOP_URLS = "WebshopURLs";
    private static final String XML_ELEM_FREE_CODE_URLS = "FreeCodeURLs";
    private static final String XML_ELEM_WEBSHOP_URL = "URL";
    private static final String XML_ATTR_WEBSHOP_AFFILIATE_ARGUMENT = "affiliateArgument";
    private static final String XML_ATTR_WEBSHOP_ARGUMENT = "shopArgument";
    private static final String XML_ATTR_WEBSHOP_LANGUAGE_ARGUMENT = "language";
    private static final String XML_ATTR_WEBSHOP_TRANSACTION_ARGUMENT = "transactionArgument";
    private static final String XML_ATTR_WEBSHOP_RATE_ARGUMENT = "rateArgument";
    private String m_strPaymentInstanceId;
    private boolean m_bIsTest = false;
    private Element m_xmlDescription;
    private XMLSignature m_signature;
    private MultiCertPath m_certPath;
    private Hashtable m_hashWebshopURLs = new Hashtable();
    private Hashtable m_hashFreeCodeURLs = new Hashtable();
    private String m_affiliateArgument;
    private String m_argLanguage;
    private String m_shopArgument;
    private String m_argTransaction;
    private String m_argRate;
    private long m_creationTimeStamp;
    private long m_serialNumber;
    private Vector m_listenerInterfaces;
    private String m_name;
    private String m_strOrganisation;
    static /* synthetic */ Class class$anon$pay$PaymentInstanceDBEntry;

    public PaymentInstanceDBEntry(Element elemRoot) throws XMLParseException {
        this(elemRoot, 0L);
    }

    public PaymentInstanceDBEntry(Element elemRoot, long a_expireTime) throws XMLParseException {
        super(a_expireTime == 0L ? System.currentTimeMillis() + 900000L : a_expireTime);
        int i;
        XMLUtil.assertNotNull(elemRoot);
        this.m_xmlDescription = elemRoot;
        String name = XMLUtil.parseValue(XMLUtil.getFirstChildByName(elemRoot, XML_ELEM_NAME), null);
        if (name == null) {
            throw new XMLParseException(XML_ELEM_NAME);
        }
        this.m_signature = SignatureVerifier.getInstance().getVerifiedXml(elemRoot, 4);
        if (this.m_signature != null) {
            this.m_certPath = this.m_signature.getMultiCertPath();
            if (this.m_certPath != null) {
                this.m_strOrganisation = this.m_certPath.getSubject().getOrganisation();
            }
        }
        this.m_strPaymentInstanceId = elemRoot.getAttribute("id");
        if (!this.checkId()) {
            throw new XMLParseException(elemRoot.getNodeName(), "Invalid Payment-Instance ID: " + this.m_strPaymentInstanceId);
        }
        this.m_name = XMLUtil.parseValue(XMLUtil.getFirstChildByName(elemRoot, XML_ELEM_NAME), "");
        this.checkName();
        this.m_creationTimeStamp = XMLUtil.parseValue(XMLUtil.getFirstChildByName(elemRoot, "LastUpdate"), -1L);
        if (this.m_creationTimeStamp == -1L) {
            throw new XMLParseException("LastUpdate");
        }
        this.m_serialNumber = XMLUtil.parseAttribute((Node)elemRoot, "serial", this.m_creationTimeStamp);
        Node nodeURL = XMLUtil.getFirstChildByName(elemRoot, XML_ELEM_WEBSHOP_URLS);
        NodeList nodesURL = XMLUtil.getElementsByTagName(nodeURL, XML_ELEM_WEBSHOP_URL);
        this.m_affiliateArgument = XMLUtil.parseAttribute(nodeURL, XML_ATTR_WEBSHOP_AFFILIATE_ARGUMENT, null);
        this.m_argLanguage = XMLUtil.parseAttribute(nodeURL, XML_ATTR_WEBSHOP_LANGUAGE_ARGUMENT, null);
        this.m_shopArgument = XMLUtil.parseAttribute(nodeURL, XML_ATTR_WEBSHOP_ARGUMENT, null);
        this.m_argRate = XMLUtil.parseAttribute(nodeURL, XML_ATTR_WEBSHOP_RATE_ARGUMENT, null);
        this.m_argTransaction = XMLUtil.parseAttribute(nodeURL, XML_ATTR_WEBSHOP_TRANSACTION_ARGUMENT, null);
        this.m_hashWebshopURLs = new Hashtable();
        for (i = 0; nodesURL != null && i < nodesURL.getLength(); ++i) {
            try {
                this.m_hashWebshopURLs.put(XMLUtil.parseAttribute(nodesURL.item(i), "lang", "en"), new URL(XMLUtil.parseValue(nodesURL.item(i), null)));
                continue;
            }
            catch (MalformedURLException e) {
                LogHolder.log(5, LogType.PAY, e);
            }
        }
        if (this.m_hashWebshopURLs.size() == 0) {
            this.m_hashWebshopURLs = null;
        }
        nodeURL = XMLUtil.getFirstChildByName(elemRoot, XML_ELEM_FREE_CODE_URLS);
        nodesURL = XMLUtil.getElementsByTagName(nodeURL, XML_ELEM_WEBSHOP_URL);
        this.m_hashFreeCodeURLs = new Hashtable();
        for (i = 0; nodesURL != null && i < nodesURL.getLength(); ++i) {
            try {
                this.m_hashFreeCodeURLs.put(XMLUtil.parseAttribute(nodesURL.item(i), "lang", "en"), new URL(XMLUtil.parseValue(nodesURL.item(i), null)));
                continue;
            }
            catch (MalformedURLException e) {
                LogHolder.log(5, LogType.PAY, e);
            }
        }
        if (this.m_hashFreeCodeURLs.size() == 0) {
            this.m_hashFreeCodeURLs = null;
        }
        Node listenerInterfacesNode = XMLUtil.getFirstChildByName(XMLUtil.getFirstChildByName(elemRoot, XML_ELEM_NET), "ListenerInterfaces");
        XMLUtil.assertNotNull(listenerInterfacesNode);
        NodeList listenerInterfaceNodes = ((Element)listenerInterfacesNode).getElementsByTagName("ListenerInterface");
        if (listenerInterfaceNodes.getLength() == 0) {
            throw new XMLParseException("ListenerInterface");
        }
        this.m_listenerInterfaces = new Vector();
        for (int i2 = 0; i2 < listenerInterfaceNodes.getLength(); ++i2) {
            this.m_listenerInterfaces.addElement(new ListenerInterface((Element)listenerInterfaceNodes.item(i2)));
        }
    }

    public PaymentInstanceDBEntry(String a_id, String a_name, JAPCertificate a_cert, Enumeration a_listeners, String software_version, long creationTime, long a_serialNumber, Hashtable a_hashURLs, Hashtable a_hashFreeCodeURLs, String a_affiliateArgument, String a_argTransaction, String a_argPlanName, String a_shopArgument, String a_argLanguage) {
        super(System.currentTimeMillis() + 900000L);
        String strLang;
        Element elemShopUrl;
        Enumeration enumUrls;
        Element elemShopUrls;
        this.m_shopArgument = a_shopArgument;
        this.m_argLanguage = a_argLanguage;
        this.m_affiliateArgument = a_affiliateArgument;
        this.m_argTransaction = a_argTransaction;
        this.m_argRate = a_argPlanName;
        this.m_strPaymentInstanceId = a_id;
        this.m_creationTimeStamp = creationTime;
        this.m_serialNumber = a_serialNumber;
        this.m_name = a_name;
        if (a_hashURLs != null) {
            this.m_hashWebshopURLs = (Hashtable)a_hashURLs.clone();
            if (this.m_hashWebshopURLs.size() == 0) {
                this.m_hashWebshopURLs = null;
            }
        }
        if (a_hashFreeCodeURLs != null) {
            this.m_hashFreeCodeURLs = (Hashtable)a_hashFreeCodeURLs.clone();
            if (this.m_hashFreeCodeURLs.size() == 0) {
                this.m_hashFreeCodeURLs = null;
            }
        }
        Document doc = XMLUtil.createDocument();
        Element elemRoot = doc.createElement(XML_ELEMENT_NAME);
        doc.appendChild(elemRoot);
        XMLUtil.setAttribute(elemRoot, "id", this.m_strPaymentInstanceId);
        XMLUtil.setAttribute(elemRoot, "serial", this.m_serialNumber);
        Element elemName = doc.createElement(XML_ELEM_NAME);
        XMLUtil.setValue((Node)elemName, this.m_name);
        elemRoot.appendChild(elemName);
        ServiceSoftware software = new ServiceSoftware(software_version);
        elemRoot.appendChild(software.toXmlElement(doc));
        Element elemNet = doc.createElement(XML_ELEM_NET);
        elemRoot.appendChild(elemNet);
        Element elemListeners = doc.createElement("ListenerInterfaces");
        elemNet.appendChild(elemListeners);
        while (a_listeners.hasMoreElements()) {
            ListenerInterface li = (ListenerInterface)a_listeners.nextElement();
            elemListeners.appendChild(li.toXmlElement(doc));
        }
        if (this.m_hashWebshopURLs != null) {
            elemShopUrls = doc.createElement(XML_ELEM_WEBSHOP_URLS);
            enumUrls = this.m_hashWebshopURLs.keys();
            if (this.m_affiliateArgument != null) {
                XMLUtil.setAttribute(elemShopUrls, XML_ATTR_WEBSHOP_AFFILIATE_ARGUMENT, this.m_affiliateArgument);
            }
            if (this.m_shopArgument != null) {
                XMLUtil.setAttribute(elemShopUrls, XML_ATTR_WEBSHOP_ARGUMENT, this.m_shopArgument);
            }
            if (this.m_argLanguage != null) {
                XMLUtil.setAttribute(elemShopUrls, XML_ATTR_WEBSHOP_LANGUAGE_ARGUMENT, this.m_argLanguage);
            }
            if (this.m_argTransaction != null) {
                XMLUtil.setAttribute(elemShopUrls, XML_ATTR_WEBSHOP_TRANSACTION_ARGUMENT, this.m_argTransaction);
            }
            if (this.m_argRate != null) {
                XMLUtil.setAttribute(elemShopUrls, XML_ATTR_WEBSHOP_RATE_ARGUMENT, this.m_argRate);
            }
            while (enumUrls.hasMoreElements()) {
                elemShopUrl = doc.createElement(XML_ELEM_WEBSHOP_URL);
                strLang = (String)enumUrls.nextElement();
                XMLUtil.setAttribute(elemShopUrl, "lang", strLang);
                XMLUtil.setValue((Node)elemShopUrl, ((URL)this.m_hashWebshopURLs.get(strLang)).toString());
                elemShopUrls.appendChild(elemShopUrl);
            }
            elemRoot.appendChild(elemShopUrls);
        }
        if (this.m_hashFreeCodeURLs != null) {
            elemShopUrls = doc.createElement(XML_ELEM_FREE_CODE_URLS);
            enumUrls = this.m_hashFreeCodeURLs.keys();
            while (enumUrls.hasMoreElements()) {
                elemShopUrl = doc.createElement(XML_ELEM_WEBSHOP_URL);
                strLang = (String)enumUrls.nextElement();
                XMLUtil.setAttribute(elemShopUrl, "lang", strLang);
                XMLUtil.setValue((Node)elemShopUrl, ((URL)this.m_hashFreeCodeURLs.get(strLang)).toString());
                elemShopUrls.appendChild(elemShopUrl);
            }
            elemRoot.appendChild(elemShopUrls);
        }
        Element elemLastUpdate = doc.createElement("LastUpdate");
        XMLUtil.setValue((Node)elemLastUpdate, this.m_creationTimeStamp);
        elemRoot.appendChild(elemLastUpdate);
        if (a_cert != null) {
            Element elemCert = doc.createElement(XML_ELEM_CERT);
            elemRoot.appendChild(elemCert);
            elemCert.appendChild(a_cert.toXmlElement(doc));
            this.m_signature = SignatureCreator.getInstance().getSignedXml(4, elemRoot);
            if (this.m_signature != null) {
                this.m_certPath = this.m_signature.getMultiCertPath();
            }
            if (this.m_certPath == null) {
                LogHolder.log(2, LogType.MISC, "Document could not be signed!");
            }
            this.m_strOrganisation = a_cert.getSubject().getOrganisation();
        }
        this.m_xmlDescription = elemRoot;
    }

    public URL getWebshopURL() {
        return this.getWebshopURL(0L, null);
    }

    public URL getFreeCodeURL() {
        URL url = null;
        if (this.m_hashFreeCodeURLs != null && this.m_hashFreeCodeURLs.size() > 0 && (url = (URL)this.m_hashFreeCodeURLs.get(JAPMessages.getLocale().getLanguage().toLowerCase())) == null) {
            url = (URL)this.m_hashFreeCodeURLs.get("en");
        }
        return url;
    }

    public URL getWebshopURL(long a_lTransactionID, String a_rateID) {
        URL url = null;
        Hashtable<String, Object> hashArgs = new Hashtable<String, Object>();
        if (this.m_hashWebshopURLs != null && this.m_hashWebshopURLs.size() > 0) {
            url = (URL)this.m_hashWebshopURLs.get(JAPMessages.getLocale().getLanguage().toLowerCase());
            if (url == null) {
                url = (URL)this.m_hashWebshopURLs.get("en");
            }
            String strAffiliate = PayAccountsFile.getInstance().getAffiliate(this.m_strPaymentInstanceId, false);
            if (this.m_affiliateArgument != null && strAffiliate != null) {
                int index = strAffiliate.indexOf("_");
                if (this.m_shopArgument != null && index > 0 && strAffiliate.length() > index + 1) {
                    String strShop = strAffiliate.substring(0, index);
                    strAffiliate = strAffiliate.substring(index + 1, strAffiliate.length());
                    hashArgs.put(this.m_shopArgument, strShop);
                }
                hashArgs.put(this.m_affiliateArgument, strAffiliate);
            }
            if (this.m_argLanguage != null) {
                hashArgs.put(this.m_argLanguage, JAPMessages.getLocale().getLanguage());
            }
            if (this.m_argRate != null && a_rateID != null) {
                hashArgs.put(this.m_argRate, a_rateID);
            }
            if (this.m_argTransaction != null && a_lTransactionID > 0L) {
                hashArgs.put(this.m_argTransaction, new Long(a_lTransactionID));
            }
            if (url != null && hashArgs.size() > 0) {
                String strUrl = url.toString();
                Enumeration enumKeys = hashArgs.keys();
                while (enumKeys.hasMoreElements()) {
                    strUrl = strUrl.indexOf("?") > 0 ? strUrl + "&" : strUrl + "?";
                    String strKey = (String)enumKeys.nextElement();
                    strUrl = strUrl + strKey + "=" + hashArgs.get(strKey).toString();
                }
                try {
                    url = new URL(strUrl);
                }
                catch (MalformedURLException e) {
                    LogHolder.log(1, LogType.PAY, e);
                }
            }
        }
        return url;
    }

    public boolean isPersistanceDeletionAllowed() {
        return XMLUtil.getStorageMode() == 2;
    }

    public void deletePersistence() {
        if (this.isPersistanceDeletionAllowed()) {
            this.m_signature = null;
        }
    }

    public boolean isVerified() {
        if (this.m_certPath != null) {
            return this.m_certPath.isVerified();
        }
        return false;
    }

    public boolean isValid() {
        if (this.m_certPath != null) {
            return this.m_certPath.isValid(new Date());
        }
        return false;
    }

    public XMLSignature getSignature() {
        return this.m_signature;
    }

    public MultiCertPath getCertPath() {
        return this.m_certPath;
    }

    public String toString() {
        return this.getName();
    }

    public String getOrganisation() {
        return this.m_strOrganisation;
    }

    public String getId() {
        return this.m_strPaymentInstanceId;
    }

    public boolean equals(Object a_paymentInstance) {
        if (!(a_paymentInstance instanceof PaymentInstanceDBEntry) || a_paymentInstance == null) {
            return false;
        }
        PaymentInstanceDBEntry paymentInstance = (PaymentInstanceDBEntry)a_paymentInstance;
        return paymentInstance.getId() == this.getId() || paymentInstance.getId().equals(this.getId());
    }

    public int hashCode() {
        if (this.m_strPaymentInstanceId == null) {
            return 0;
        }
        return this.m_strPaymentInstanceId.hashCode();
    }

    public String getName() {
        return this.m_name;
    }

    public Enumeration getListenerInterfaces() {
        Random random = new Random();
        Vector interfaces = (Vector)this.m_listenerInterfaces.clone();
        Vector interfacesReturned = new Vector();
        while (interfaces.size() > 0) {
            int currentIndex = Math.abs(random.nextInt() % interfaces.size());
            interfacesReturned.addElement(interfaces.elementAt(currentIndex));
            interfaces.removeElementAt(currentIndex);
        }
        return interfacesReturned.elements();
    }

    public long getVersionNumber() {
        return this.m_serialNumber;
    }

    public long getLastUpdate() {
        return this.m_creationTimeStamp;
    }

    public String getPostFile() {
        return "/paymentinstance";
    }

    public Element getXmlStructure() {
        return this.m_xmlDescription;
    }

    public boolean isTest() {
        return this.m_bIsTest;
    }

    private void checkName() {
        if (this.m_name != null) {
            StringTokenizer tokenizer = new StringTokenizer(this.m_name);
            while (tokenizer.hasMoreElements()) {
                if (!tokenizer.nextToken().toLowerCase().equals("test")) continue;
                this.m_bIsTest = true;
                String strName = JAPMessages.getString(MSG_TEST_NAME);
                if (strName.equals(MSG_TEST_NAME)) break;
                this.m_name = strName;
                break;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

