/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.message;

import anon.crypto.MyAES;
import anon.util.ByteArrayUtil;
import anon.util.ZLibTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.bouncycastle.crypto.digests.SHA1Digest;

public class MixMinionCryptoUtil {
    public static byte[] randomArray(int len) {
        byte[] ret = new byte[len];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(ret);
        return ret;
    }

    static byte[] xor(byte[] one, byte[] two) {
        if (one.length != two.length) {
            return null;
        }
        byte[] result = new byte[one.length];
        for (int i = 0; i < one.length; ++i) {
            result[i] = (byte)(one[i] ^ two[i]);
        }
        return result;
    }

    public static byte[] hash(byte[] x) {
        SHA1Digest myDigest = new SHA1Digest();
        myDigest.update(x, 0, x.length);
        byte[] ret = new byte[myDigest.getDigestSize()];
        myDigest.doFinal(ret, 0);
        return ret;
    }

    public static Vector subVector(Vector v, int offset, int len) {
        Vector erg = new Vector();
        for (int i = offset; i < offset + len; ++i) {
            erg.addElement(v.elementAt(i));
        }
        return erg;
    }

    public static byte[] Encrypt(byte[] K, byte[] M) {
        return MixMinionCryptoUtil.xor(M, MixMinionCryptoUtil.createPRNG(K, M.length));
    }

    static byte[] createPRNG(byte[] key, int len) {
        MyAES engine = new MyAES();
        byte[] data = new byte[len];
        byte[] counter = new byte[16];
        byte[] counterOut = new byte[16];
        try {
            engine.init(true, key);
            int datapos = 0;
            while (len >= 16) {
                engine.processBlockECB(counter, counterOut);
                System.arraycopy(counterOut, 0, data, datapos, 16);
                int carry = 1;
                for (int i = counter.length - 1; i >= 0; --i) {
                    int x = (counter[i] & 0xFF) + carry;
                    carry = x > 255 ? 1 : 0;
                    counter[i] = (byte)x;
                }
                len -= 16;
                datapos += 16;
            }
            if (len > 0) {
                engine.processBlockECB(counter, counterOut);
                System.arraycopy(counterOut, 0, data, datapos, len);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            return null;
        }
        return data;
    }

    public static byte[] SPRP_Encrypt(byte[] K, byte[] M) {
        byte[] h1 = new byte[20];
        byte[] K1 = K;
        h1[19] = 1;
        byte[] K2 = MixMinionCryptoUtil.xor(K, h1);
        h1[19] = 2;
        byte[] K3 = MixMinionCryptoUtil.xor(K, h1);
        h1[19] = 3;
        byte[] K4 = MixMinionCryptoUtil.xor(K, h1);
        byte[] L = ByteArrayUtil.copy(M, 0, 20);
        byte[] R = ByteArrayUtil.copy(M, 20, M.length - 20);
        R = MixMinionCryptoUtil.Encrypt(ByteArrayUtil.copy(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(K1, L, K1)), 0, 16), R);
        L = MixMinionCryptoUtil.xor(L, MixMinionCryptoUtil.hash(ByteArrayUtil.conc(K2, R, K2)));
        R = MixMinionCryptoUtil.Encrypt(ByteArrayUtil.copy(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(K3, L, K3)), 0, 16), R);
        L = MixMinionCryptoUtil.xor(L, MixMinionCryptoUtil.hash(ByteArrayUtil.conc(K4, R, K4)));
        return ByteArrayUtil.conc(L, R);
    }

    public static byte[] SPRP_Decrypt(byte[] K, byte[] M) {
        byte[] h1 = new byte[20];
        byte[] K1 = K;
        h1[19] = 1;
        byte[] K2 = MixMinionCryptoUtil.xor(K, h1);
        h1[19] = 2;
        byte[] K3 = MixMinionCryptoUtil.xor(K, h1);
        h1[19] = 3;
        byte[] K4 = MixMinionCryptoUtil.xor(K, h1);
        byte[] L = ByteArrayUtil.copy(M, 0, 20);
        byte[] R = ByteArrayUtil.copy(M, 20, M.length - 20);
        L = MixMinionCryptoUtil.xor(L, MixMinionCryptoUtil.hash(ByteArrayUtil.conc(K4, R, K4)));
        R = MixMinionCryptoUtil.Encrypt(ByteArrayUtil.copy(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(K3, L, K3)), 0, 16), R);
        L = MixMinionCryptoUtil.xor(L, MixMinionCryptoUtil.hash(ByteArrayUtil.conc(K2, R, K2)));
        R = MixMinionCryptoUtil.Encrypt(ByteArrayUtil.copy(MixMinionCryptoUtil.hash(ByteArrayUtil.conc(K1, L, K1)), 0, 16), R);
        return ByteArrayUtil.conc(L, R);
    }

    static byte[] compressData(byte[] message) {
        byte[] compress = ZLibTools.compress(message);
        if (compress[0] != 120 || compress[1] + 256 != 218) {
            throw new RuntimeException("The Compressed Messege didn't start with 0x78DA");
        }
        return compress;
    }

    static byte[] decompressData(byte[] message) {
        return ZLibTools.decompress(message);
    }

    private static byte[] ZIPcompressData(byte[] message) {
        byte[] compress = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ZipOutputStream zip = new ZipOutputStream(baos);
            zip.setLevel(9);
            zip.setMethod(8);
            ZipEntry e = new ZipEntry("MixMinionZip");
            zip.putNextEntry(e);
            zip.write(message);
            zip.flush();
            zip.close();
            baos.flush();
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        compress = baos.toByteArray();
        if (!ByteArrayUtil.equal(message, MixMinionCryptoUtil.ZIPextractData(compress))) {
            throw new RuntimeException("Something with Compression/Decompression was wrong!");
        }
        return compress;
    }

    private static byte[] ZIPextractData(byte[] payload) {
        byte[] message = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(payload);
        try {
            ZipInputStream zip = new ZipInputStream(bais);
            ZipEntry e = zip.getNextEntry();
            boolean go = true;
            int size = -1;
            while (go) {
                ++size;
                int c = ((InflaterInputStream)zip).read();
                byte[] b = new byte[]{(byte)c};
                if (c != -1) {
                    message = ByteArrayUtil.conc(message, b);
                    continue;
                }
                go = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return message;
    }

    private static byte[] GZIPcompressData(byte[] message) {
        byte[] payload = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(baos);
            gzip.write(message);
            gzip.flush();
            gzip.close();
            baos.flush();
            baos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        payload = baos.toByteArray();
        return payload;
    }

    private static byte[] GZIPextractData(byte[] payload) {
        byte[] message = null;
        ByteArrayInputStream bais = new ByteArrayInputStream(payload);
        try {
            GZIPInputStream gzip = new GZIPInputStream(bais);
            boolean go = true;
            int size = -1;
            while (go) {
                ++size;
                int c = gzip.read();
                byte[] b = new byte[]{(byte)c};
                if (c != -1) {
                    message = ByteArrayUtil.conc(message, b);
                    continue;
                }
                go = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return message;
    }
}

