/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.crypto.MyRandom;
import anon.infoservice.ListenerInterface;
import java.util.Vector;

public class RandomListenerInterfaceSwitcher {
    private Vector m_vecListenerInterfaces;
    private Vector m_vecTried = new Vector();
    private Vector m_vecRemaining;
    private Vector m_vecTimeOutPorts;
    private int m_iPreferredPort;
    private int m_iMaxTried;
    private MyRandom m_random;

    public RandomListenerInterfaceSwitcher(Vector a_vecListenerInterfaces, int a_iPreferredPort, int a_iMaxTried, Vector a_vecTimeOutPorts) {
        this.m_vecListenerInterfaces = a_vecListenerInterfaces != null ? (Vector)a_vecListenerInterfaces.clone() : new Vector();
        this.m_vecTimeOutPorts = a_vecTimeOutPorts != null ? a_vecTimeOutPorts : new Vector();
        this.m_iPreferredPort = Math.min(a_iPreferredPort, 65535);
        this.m_iMaxTried = Math.max(1, a_iMaxTried);
        this.m_random = new MyRandom();
    }

    private boolean containsPort(Vector a_vecToCheck, int a_iPort) {
        for (int i = 0; i < a_vecToCheck.size(); ++i) {
            if (!(a_vecToCheck.elementAt(i) instanceof Integer ? (Integer)a_vecToCheck.elementAt(i) == a_iPort : ((ListenerInterface)a_vecToCheck.elementAt(i)).getPort() == a_iPort)) continue;
            return true;
        }
        return false;
    }

    private ListenerInterface getNextRandomInterface() {
        if (this.m_vecRemaining.size() == 0) {
            return null;
        }
        int iNext = this.m_random.nextInt(this.m_vecRemaining.size());
        ListenerInterface currentInterface = (ListenerInterface)this.m_vecRemaining.elementAt(iNext);
        this.m_vecRemaining.removeElementAt(iNext);
        return currentInterface;
    }

    private void resetRandomInterfaces() {
        if (this.m_vecListenerInterfaces == null) {
            return;
        }
        this.m_vecRemaining = (Vector)this.m_vecListenerInterfaces.clone();
        block0: for (int i = 0; i < this.m_vecTried.size(); ++i) {
            for (int j = 0; j < this.m_vecRemaining.size(); ++j) {
                if (((ListenerInterface)this.m_vecRemaining.elementAt(j)).getPort() != ((Integer)this.m_vecTried.elementAt(i)).intValue()) continue;
                this.m_vecRemaining.removeElementAt(j);
                continue block0;
            }
        }
    }

    public synchronized ListenerInterface getNextInterface() {
        ListenerInterface currentInterface;
        boolean bUse = false;
        this.resetRandomInterfaces();
        while (true) {
            if (this.m_vecTried.size() >= this.m_iMaxTried) {
                return null;
            }
            currentInterface = this.getNextRandomInterface();
            if (currentInterface == null) {
                ++this.m_iMaxTried;
                if (this.m_iPreferredPort > 0 && !this.m_vecTried.contains(new Integer(this.m_iPreferredPort))) {
                    this.m_vecTried.addElement(new Integer(this.m_iPreferredPort));
                    this.resetRandomInterfaces();
                    continue;
                }
                if (!this.m_vecTried.contains(new Integer(443))) {
                    this.m_vecTried.addElement(new Integer(443));
                    this.resetRandomInterfaces();
                    continue;
                }
                if (!this.m_vecTried.contains(new Integer(80))) {
                    this.m_vecTried.addElement(new Integer(80));
                    this.resetRandomInterfaces();
                    continue;
                }
                return null;
            }
            if (!this.containsPort(this.m_vecTimeOutPorts, this.m_iPreferredPort) && this.m_iPreferredPort > 0 && this.containsPort(this.m_vecListenerInterfaces, this.m_iPreferredPort) && !this.m_vecTried.contains(new Integer(this.m_iPreferredPort))) {
                if (currentInterface.getPort() != this.m_iPreferredPort) continue;
                bUse = true;
            }
            if (!bUse && !this.containsPort(this.m_vecTimeOutPorts, 443) && this.containsPort(this.m_vecListenerInterfaces, 443) && !this.m_vecTried.contains(new Integer(443))) {
                if (currentInterface.getPort() != 443) continue;
                bUse = true;
            }
            if (!bUse && this.containsPort(this.m_vecListenerInterfaces, 80) && !this.containsPort(this.m_vecTimeOutPorts, 80) && !this.m_vecTried.contains(new Integer(80))) {
                if (currentInterface.getPort() != 80) continue;
                bUse = true;
            }
            this.m_vecTried.addElement(new Integer(currentInterface.getPort()));
            if (currentInterface.isValid()) break;
            ++this.m_iMaxTried;
        }
        if (this.m_vecTimeOutPorts.size() >= 2) {
            this.m_vecTimeOutPorts.removeAllElements();
        }
        return currentInterface;
    }
}

