/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.params.KeyParameter;

public class MyAES {
    private AESFastEngine m_AES = new AESFastEngine();
    private byte[] m_arCounter = null;
    private byte[] m_arCounterOut = null;
    private int m_posCTR = 0;

    public synchronized void init(boolean bEncrypt, byte[] a_aesKey) throws Exception {
        this.init(bEncrypt, a_aesKey, 0, a_aesKey.length);
    }

    public synchronized void init(boolean bEncrypt, byte[] a_aesKey, int off, int len) throws Exception {
        this.m_AES.init(bEncrypt, new KeyParameter(a_aesKey, off, len));
        this.m_arCounter = null;
        this.m_arCounterOut = null;
        this.m_posCTR = 0;
    }

    public synchronized void processBlockECB(byte[] a_InData, byte[] a_OutData) throws Exception {
        this.m_AES.processBlock(a_InData, 0, a_OutData, 0);
    }

    public synchronized byte[] processBlockECB(byte[] a_plainData) throws Exception {
        byte[] cipherBlock = new byte[16];
        this.m_AES.processBlock(a_plainData, 0, cipherBlock, 0);
        return cipherBlock;
    }

    public void processBytesCTR(byte[] in, int inOff, byte[] out, int outOff, int len) throws Exception {
        if (this.m_arCounterOut == null) {
            this.m_arCounterOut = new byte[16];
            this.m_posCTR = 0;
            this.m_arCounter = new byte[16];
        }
        while (len > 0) {
            if (this.m_posCTR == 0) {
                this.processBlockECB(this.m_arCounter, this.m_arCounterOut);
            }
            while (this.m_posCTR < this.m_arCounterOut.length) {
                out[outOff] = (byte)(this.m_arCounterOut[this.m_posCTR] ^ in[inOff]);
                ++outOff;
                ++inOff;
                ++this.m_posCTR;
                if (--len != 0) continue;
                return;
            }
            this.m_posCTR = 0;
            int carry = 1;
            for (int i = this.m_arCounter.length - 1; i >= 0; --i) {
                int x = (this.m_arCounter[i] & 0xFF) + carry;
                carry = x > 255 ? 1 : 0;
                this.m_arCounter[i] = (byte)x;
            }
        }
    }
}

