/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.ITrustModel;
import anon.client.TrustModel;
import anon.infoservice.AbstractMixCascadeContainer;
import anon.infoservice.Database;
import anon.infoservice.MixCascade;
import anon.pay.PayAccountsFile;
import anon.util.JAPMessages;
import anon.util.Util;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public abstract class AbstractAutoSwitchedMixCascadeContainer
extends AbstractMixCascadeContainer {
    public static final MixCascade INITIAL_DUMMY_SERVICE;
    private static final long MINIMUM_NEXT_WAITING_TIME = 250L;
    private long m_lLastNextRequest = 0L;
    private Hashtable m_alreadyTriedCascades;
    private Random m_random;
    private MixCascade m_initialCascade;
    private MixCascade m_currentCascade;
    private boolean m_bKeepCurrentCascade;
    private boolean m_bSkipInitialCascade;
    private String m_strStartupServiceId;
    private boolean m_bInitialRun;
    static /* synthetic */ Class class$anon$infoservice$MixCascade;
    static /* synthetic */ Class class$anon$client$TrustModel$ForcePremiumIfChargedAccountAttribute;

    public AbstractAutoSwitchedMixCascadeContainer(boolean a_bSkipInitialCascade, MixCascade a_initialCascade, String a_strStartupServiceId) {
        if (a_initialCascade == null) {
            if (INITIAL_DUMMY_SERVICE == null) {
                throw new NullPointerException("Initial cascade is null!");
            }
            a_initialCascade = INITIAL_DUMMY_SERVICE;
            a_initialCascade.showAsTrusted(true);
        }
        this.m_bInitialRun = a_initialCascade == INITIAL_DUMMY_SERVICE;
        this.m_strStartupServiceId = a_strStartupServiceId;
        this.m_bSkipInitialCascade = a_bSkipInitialCascade;
        this.m_alreadyTriedCascades = new Hashtable();
        this.m_random = new Random(System.currentTimeMillis());
        this.m_random.nextInt();
        this.m_currentCascade = this.m_initialCascade = a_initialCascade;
        this.m_bKeepCurrentCascade = false;
    }

    public final MixCascade getInitialCascade() {
        return this.m_initialCascade;
    }

    public void reset() {
        this.m_alreadyTriedCascades.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MixCascade getNextRandomCascade() {
        Hashtable hashtable = this.m_alreadyTriedCascades;
        synchronized (hashtable) {
            this.reset();
            return this.getNextCascade(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final MixCascade getNextCascade() {
        Hashtable hashtable = this.m_alreadyTriedCascades;
        synchronized (hashtable) {
            try {
                Thread.sleep(Math.max(0L, this.m_lLastNextRequest + 250L - System.currentTimeMillis()));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.m_lLastNextRequest = System.currentTimeMillis();
            return this.getNextCascade(false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final MixCascade getNextCascade(boolean a_bForceNextRandom, boolean a_bUseSkippedServices) {
        Hashtable hashtable = this.m_alreadyTriedCascades;
        synchronized (hashtable) {
            if (!TrustModel.getCurrentTrustModel().hasTrustedCascades()) {
                this.m_alreadyTriedCascades.put(this.m_currentCascade.getId(), this.m_currentCascade);
            } else if (!(this.isServiceAutoSwitched() || a_bForceNextRandom || this.m_strStartupServiceId != null && this.m_strStartupServiceId.equals(INITIAL_DUMMY_SERVICE.getId()) || this.m_currentCascade == INITIAL_DUMMY_SERVICE && !this.isSuitableCascade((MixCascade)Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = AbstractAutoSwitchedMixCascadeContainer.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryById(this.m_strStartupServiceId)))) {
                this.reset();
                this.m_bKeepCurrentCascade = false;
                if (this.m_initialCascade == INITIAL_DUMMY_SERVICE) {
                    if (this.m_strStartupServiceId == null && this.m_currentCascade != INITIAL_DUMMY_SERVICE) {
                        this.m_initialCascade = this.m_currentCascade;
                    } else {
                        MixCascade startupService = (MixCascade)Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = AbstractAutoSwitchedMixCascadeContainer.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryById(this.m_strStartupServiceId);
                        if (startupService != null) {
                            this.m_initialCascade = startupService;
                        }
                    }
                }
                if (this.m_currentCascade == INITIAL_DUMMY_SERVICE) {
                    this.update(this.m_initialCascade, false);
                }
            } else if (this.m_bKeepCurrentCascade && !a_bForceNextRandom && TrustModel.getCurrentTrustModel().isTrusted(this.m_currentCascade) && this.m_currentCascade != INITIAL_DUMMY_SERVICE) {
                this.m_bKeepCurrentCascade = false;
                this.m_alreadyTriedCascades.put(this.m_currentCascade.getId(), this.m_currentCascade);
            } else {
                MixCascade currentCascade = null;
                boolean forward = true;
                Vector availableCascades = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = AbstractAutoSwitchedMixCascadeContainer.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryList();
                if (availableCascades.size() > 0) {
                    int i;
                    int chosenCascadeIndex = this.m_random.nextInt();
                    if (chosenCascadeIndex < 0) {
                        chosenCascadeIndex *= -1;
                        forward = false;
                    }
                    chosenCascadeIndex %= availableCascades.size();
                    Vector<MixCascade> vecSuitableFound = new Vector<MixCascade>();
                    for (i = 0; i < availableCascades.size(); ++i) {
                        currentCascade = (MixCascade)availableCascades.elementAt(chosenCascadeIndex);
                        if (this.m_alreadyTriedCascades.containsKey(currentCascade.getId())) {
                            currentCascade = null;
                        } else if (!this.isSuitableCascade(currentCascade)) {
                            this.m_alreadyTriedCascades.put(currentCascade.getId(), currentCascade);
                            currentCascade = null;
                        } else {
                            if (!a_bUseSkippedServices && currentCascade.getNumberOfOperators() <= 1) {
                                Hashtable hashAvailable = Database.getInstance(class$anon$infoservice$MixCascade == null ? AbstractAutoSwitchedMixCascadeContainer.class$("anon.infoservice.MixCascade") : class$anon$infoservice$MixCascade).getEntryHash();
                                Enumeration<Object> enumTried = this.m_alreadyTriedCascades.keys();
                                while (enumTried.hasMoreElements()) {
                                    hashAvailable.remove(enumTried.nextElement());
                                }
                                enumTried = hashAvailable.elements();
                                while (enumTried.hasMoreElements()) {
                                    MixCascade tmpCascade = (MixCascade)enumTried.nextElement();
                                    if (tmpCascade.getNumberOfOperators() <= 1 || !this.isSuitableCascade(tmpCascade)) continue;
                                    currentCascade = null;
                                    break;
                                }
                            }
                            if (currentCascade != null) {
                                double iProbability = Math.max(0.05, Math.pow(currentCascade.getDistribution(), 2.0) / Math.pow(6.0, 2.0));
                                if (this.m_random.nextDouble() <= iProbability) break;
                                if (!vecSuitableFound.contains(currentCascade)) {
                                    vecSuitableFound.addElement(currentCascade);
                                }
                                currentCascade = null;
                            }
                        }
                        if (forward) {
                            chosenCascadeIndex = (chosenCascadeIndex + 1) % availableCascades.size();
                            continue;
                        }
                        if (--chosenCascadeIndex >= 0) continue;
                        chosenCascadeIndex = availableCascades.size() - 1;
                    }
                    if (currentCascade == null && vecSuitableFound.size() > 0) {
                        for (i = 0; i < vecSuitableFound.size(); ++i) {
                            if (currentCascade != null && currentCascade.getDistribution() >= ((MixCascade)vecSuitableFound.elementAt(i)).getDistribution() || !this.isSuitableCascade((MixCascade)vecSuitableFound.elementAt(i))) continue;
                            currentCascade = (MixCascade)vecSuitableFound.elementAt(i);
                        }
                    }
                }
                if (currentCascade == null && !a_bUseSkippedServices) {
                    return this.getNextCascade(a_bForceNextRandom, true);
                }
                if (currentCascade == null) {
                    this.reset();
                    availableCascades = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = AbstractAutoSwitchedMixCascadeContainer.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryList(true);
                    for (int i = 0; i < availableCascades.size(); ++i) {
                        if (!this.isSuitableCascade((MixCascade)availableCascades.elementAt(i))) continue;
                        currentCascade = (MixCascade)availableCascades.elementAt(i);
                        LogHolder.log(4, LogType.MISC, "Tried all services, but did not find any suitable... Now using random service: " + currentCascade);
                        break;
                    }
                    if (currentCascade == null && (currentCascade = this.m_currentCascade) != INITIAL_DUMMY_SERVICE) {
                        LogHolder.log(4, LogType.MISC, "Tried all services, but did not find any suitable... Now re-using current service: " + currentCascade);
                    }
                }
                this.m_alreadyTriedCascades.put(currentCascade.getId(), currentCascade);
                this.update(currentCascade, false);
            }
            if (this.m_bSkipInitialCascade || this.m_initialCascade == INITIAL_DUMMY_SERVICE) {
                this.m_initialCascade = this.m_currentCascade;
            }
            this.m_bSkipInitialCascade = false;
        }
        return this.m_currentCascade;
    }

    public abstract boolean isServiceAutoSwitched();

    public abstract boolean isReconnectedAutomatically();

    public abstract boolean hasUserAllowedPaidServices(String var1);

    public final String getStartupServiceId() {
        return this.m_strStartupServiceId;
    }

    private final boolean isSuitableCascade(MixCascade a_cascade) {
        if (a_cascade == null) {
            return false;
        }
        TrustModel model = TrustModel.getCurrentTrustModel();
        if (!model.isPaymentForced() && (a_cascade.isPayment() ? PayAccountsFile.getInstance().getChargedAccount(a_cascade.getPIID()) == null && (!this.hasUserAllowedPaidServices(a_cascade.getPIID()) || PayAccountsFile.getInstance().getAccountWaitingForTransaction(a_cascade.getPIID()) != null) : !PayAccountsFile.getInstance().isNewUser() && model.getAttribute(class$anon$client$TrustModel$ForcePremiumIfChargedAccountAttribute == null ? (class$anon$client$TrustModel$ForcePremiumIfChargedAccountAttribute = AbstractAutoSwitchedMixCascadeContainer.class$("anon.client.TrustModel$ForcePremiumIfChargedAccountAttribute")) : class$anon$client$TrustModel$ForcePremiumIfChargedAccountAttribute).getTrustCondition() == 2 && this.hasUserAllowedPaidServices(a_cascade.getPIID()) && PayAccountsFile.getInstance().getAccountWaitingForTransaction(a_cascade.getPIID()) == null && model.hasPremiumCascades())) {
            return false;
        }
        if (this.m_initialCascade != null && this.m_bSkipInitialCascade && a_cascade.equals(this.m_initialCascade)) {
            return false;
        }
        return model.isTrusted(a_cascade);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(MixCascade a_cascade, boolean a_bEnforceInitialRun) {
        this.m_bInitialRun = false;
        Hashtable hashtable = this.m_alreadyTriedCascades;
        synchronized (hashtable) {
            this.m_bKeepCurrentCascade = true;
            if (this.m_currentCascade == null && a_cascade != null || this.m_currentCascade != null && a_cascade == null || !this.m_currentCascade.equals(a_cascade) || !this.getTrustModel().isTrusted(this.m_currentCascade)) {
                this.setChanged();
            }
            this.m_currentCascade = a_cascade;
            if (this.m_initialCascade == null) {
                this.m_initialCascade = this.m_currentCascade;
            }
            if (a_bEnforceInitialRun) {
                this.m_bInitialRun = true;
            }
            this.notifyObservers(this.m_currentCascade);
        }
    }

    public final MixCascade getCurrentCascade() {
        return this.m_currentCascade;
    }

    public final boolean setCurrentCascade(MixCascade a_cascade) {
        if (!this.getTrustModel().isTrusted(a_cascade)) {
            return false;
        }
        this.update(a_cascade, true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void keepCurrentService(boolean a_bKeepCurrentCascade) {
        Hashtable hashtable = this.m_alreadyTriedCascades;
        synchronized (hashtable) {
            this.m_bKeepCurrentCascade = a_bKeepCurrentCascade;
        }
    }

    public final ITrustModel getTrustModel() {
        return TrustModel.getCurrentTrustModel();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MixCascade initial;
        try {
            initial = new MixCascade("-", "-", "0.0.0.0", 6544, System.currentTimeMillis()){

                public String getName() {
                    return JAPMessages.getString("noCascadesAvail");
                }

                public Vector getDecomposedCascadeName() {
                    return Util.toVector(this.getName());
                }
            };
            initial.showAsTrusted(true);
            initial.setUserDefined(false, null);
        }
        catch (Exception a_e) {
            initial = null;
        }
        INITIAL_DUMMY_SERVICE = initial;
    }
}

