/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;

public class FTPListParseEngine {
    private Vector entries = new Vector();
    int aktIndex = 0;
    FTPFileEntryParser parser = null;

    public FTPListParseEngine(FTPFileEntryParser fTPFileEntryParser) {
        this.parser = fTPFileEntryParser;
    }

    public void readServerList(InputStream inputStream, String string) throws IOException {
        this.entries = new Vector();
        this.readStream(inputStream, string);
        this.parser.preParse(this.entries);
        this.resetIterator();
    }

    public void readServerList(InputStream inputStream) throws IOException {
        this.readServerList(inputStream, null);
    }

    private void readStream(InputStream inputStream, String string) throws IOException {
        BufferedReader bufferedReader = string == null ? new BufferedReader(new InputStreamReader(inputStream)) : new BufferedReader(new InputStreamReader(inputStream, string));
        String string2 = this.parser.readNextEntry(bufferedReader);
        while (string2 != null) {
            this.entries.addElement(string2);
            string2 = this.parser.readNextEntry(bufferedReader);
        }
        bufferedReader.close();
    }

    public FTPFile[] getNext(int n) {
        Object object;
        Vector<FTPFile> vector = new Vector<FTPFile>();
        int n2 = n;
        while (n2 > 0 && this.aktIndex < this.entries.size()) {
            object = (String)this.entries.elementAt(this.aktIndex);
            ++this.aktIndex;
            FTPFile fTPFile = this.parser.parseFTPEntry((String)object);
            vector.addElement(fTPFile);
            --n2;
        }
        object = new FTPFile[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public FTPFile[] getPrevious(int n) {
        Object object;
        Vector<FTPFile> vector = new Vector<FTPFile>();
        int n2 = n;
        while (n2 > 0 && this.aktIndex > 0) {
            object = (String)this.entries.elementAt(this.aktIndex);
            --this.aktIndex;
            FTPFile fTPFile = this.parser.parseFTPEntry((String)object);
            vector.insertElementAt(fTPFile, 0);
            --n2;
        }
        object = new FTPFile[vector.size()];
        vector.copyInto((Object[])object);
        return object;
    }

    public FTPFile[] getFiles() throws IOException {
        Object[] objectArray;
        Vector<FTPFile> vector = new Vector<FTPFile>();
        Enumeration enumeration = this.entries.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (String)enumeration.nextElement();
            FTPFile fTPFile = this.parser.parseFTPEntry((String)objectArray);
            vector.addElement(fTPFile);
        }
        objectArray = new FTPFile[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public boolean hasNext() {
        return this.aktIndex < this.entries.size();
    }

    public boolean hasPrevious() {
        return this.aktIndex > 0;
    }

    public void resetIterator() {
        this.aktIndex = 0;
    }
}

